/* {{{1 GNU General Public License

Program Tops - a stack-based computing environment
Copyright (C) 1999-2005  Dale R. Williamson

Author: Dale R. Williamson <dale.williamson@prodigy.net>

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software Foundation,
Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
1}}} */

/* word.p  May 1999

Program native word patterns

This file is included when word.c is compiled.

----------------------------------------------------------------------*/

/* Words for libraries within the catalog */

/* Numbers of libraries match this enum from lib.h:
   enum libs {LIB0=0,LIB1,LIB2,LIB3,LIB4,NLIBS}; */
&& constant("LIB0","0")
&& constant("LIB1","1")
&& constant("LIB2","2")
&& constant("LIB3","3")
&& constant("LIB4","4")

/* "function" is a keyword string recognized by the parser, prs.c, 
and really is not a word; use noop() for dummy word function: */
&& native("function",(unsigned long (*)()) noop)

&& native("libget",(unsigned long (*)()) libget)
&& native("libput",(unsigned long (*)()) libput)
&& native("lcatitems",(unsigned long (*)()) lcatitems)
&& native("lexists?",(unsigned long (*)()) lexists)
&& native("catlib",(unsigned long (*)()) xcatlib)

&& native("eval",(unsigned long (*)()) pmain)
&& native("parse",(unsigned long (*)()) parse)
&& native("parse1",(unsigned long (*)()) parse1)
&& native("parse_driver",(unsigned long (*)()) parse_driver)
&& native("pmain",(unsigned long (*)()) pmain)
&& native("ptrace",(unsigned long (*)()) ptrace)
&& native("ptraceoff",(unsigned long (*)()) ptraceoff)

&& native("stp",(unsigned long (*)()) stp)

/*--------------------------------------------------------------------*/

/* Words for applications */

/* Networks by D. Williamson, December 2001; Ref: net.c, term.c */
#ifdef NET
&& native("BLOCK",(unsigned long (*)()) block1)
&& native("HOLD",(unsigned long (*)()) blockhold)
&& native("COG",(unsigned long (*)()) cog) 
&& native("conn_alarm,",(unsigned long (*)()) conn_alarm) /* term.c */
&& native("CONNECT",(unsigned long (*)()) CONNECT)
&& native("connect",(unsigned long (*)()) connect1)
&& native("CONNTO",(unsigned long (*)())  connto_val)
&& native("connto",(unsigned long (*)())  connto)
&& native("client_open",(unsigned long (*)()) client_open)
&& native("clientindex",(unsigned long (*)())  clientindex)
&& native("clientIPs",(unsigned long (*)())  clientIPs)
&& native("clientLOGINs",(unsigned long (*)())  clientLOGINs)
&& native("clientLOGIN_set",(unsigned long (*)())  clientLOGIN_set)
&& native("clients",(unsigned long (*)()) clients)
&& native("clientsockets",(unsigned long (*)()) clientsockets)
&& native("clienttimesoff",(unsigned long (*)()) clienttimesoff)
&& native("clienttimeson",(unsigned long (*)()) clienttimeson)
&& native("DSERVER",(unsigned long (*)()) server1)
&& native("exe_remote",(unsigned long (*)()) exe_remote)
&& native("exe_remote,",(unsigned long (*)()) EXE_REMOTE)
&& native("export8n",(unsigned long (*)()) export8n)
&& native("FOREVER",(unsigned long (*)()) FOREVER_set) 
&& native("import8n",(unsigned long (*)()) import8n)
&& native("_IPhost",(unsigned long (*)()) _IPhost)
&& native("netendian",(unsigned long (*)()) netendian)
&& native("netrate",(unsigned long (*)()) netrate)
&& native("NETRATE",(unsigned long (*)())  netrate_val)
&& native("netvolread",(unsigned long (*)()) netvolread)
&& native("netvolwrite",(unsigned long (*)()) netvolwrite)
&& native("new_client_timeout",(unsigned long (*)()) new_client_timeout)
&& native("NEW_CLIENT_TIMEOUT",(unsigned long (*)()) NEW_CLIENT_TIMEOUT)
&& native("nextport",(unsigned long (*)()) nextport)
&& native("ntrace",(unsigned long (*)()) ntrace)
&& native("nontrace",(unsigned long (*)()) ntraceoff)
&& native("NTRACE",(unsigned long (*)()) ntraceflag)
&& native("ptrCls",(unsigned long (*)()) ptrCls)
&& native("ptrCls_upd",(unsigned long (*)()) ptrCls_upd)
&& native("ptrRun",(unsigned long (*)()) ptrRun)
&& native("ptrRun_upd",(unsigned long (*)()) ptrRun_upd)
&& native("READ_F",(unsigned long (*)()) read_f)
&& native("READY",(unsigned long (*)()) setready)
&& native("remotefd",(unsigned long (*)()) remotefd)
&& native("remoteget",(unsigned long (*)()) remoteget)
&& native("remoteput",(unsigned long (*)()) remoteput)
&& native("remoteputf",(unsigned long (*)()) remoteputf)
&& native("remoteputf0",(unsigned long (*)()) remoteputf0)
&& native("remoteputfb",(unsigned long (*)()) remoteputfb)
&& native("remoteputmat",(unsigned long (*)()) remoteputmat)
&& native("remoterun",(unsigned long (*)()) remoterun)
&& native("remoterun2",(unsigned long (*)()) remoterun2)
&& native("remoterun_DELAY",(unsigned long (*)()) remoterun_DELAY)
&& native("remoterun_delay",(unsigned long (*)()) remoterun_delay)
&& native("sclose",(unsigned long (*)()) sclose)
&& native("sflush",(unsigned long (*)()) sflush)
&& native("SELECT",(unsigned long (*)()) setselect)
&& native("serverclose",(unsigned long (*)()) serverclose)
&& native("SERVER",(unsigned long (*)()) server)
&& native("socket",(unsigned long (*)()) socket1)
&& native("socket_open",(unsigned long (*)()) socket_open)
&& native("socket_readable",(unsigned long (*)()) test_socket_readable)
&& native("socket_writable",(unsigned long (*)()) test_socket_writable)
&& native("unblock,",(unsigned long (*)()) unblock) /* term.c */
&& native("WAIT_BEGIN",(unsigned long (*)()) WAIT_BEGIN)
&& native("WAIT_END",(unsigned long (*)()) WAIT_END)

#ifdef OPENSSL 
   && native("SERVER_SSL",(unsigned long (*)()) server2)
   && native("DSERVER_SSL",(unsigned long (*)()) server3)
   && native("SSLconnto",(unsigned long (*)()) SSLconnto)
#endif

#ifdef KEYBOARD
&& native("remoteprompter",(unsigned long (*)()) remoteprompter)
#endif

#if defined(VT) || defined(VTAIX)
/* These are in vt.c: */
#ifdef VT
/* Not for AIX: */
&& native("getattr",(unsigned long (*)()) getattr)
&& native("dispattr",(unsigned long (*)()) dispattr)
#endif
&& native("vtparse1",(unsigned long (*)()) vtparse1)
&& native("vtparse2",(unsigned long (*)()) vtparse2)
&& native("vtparse3",(unsigned long (*)()) vtparse3)
&& native("vtreserved",(unsigned long (*)()) vtreserved)
#endif /* VT or VTAIX */

#endif /* NET */

/* Matrix functions by A. Danial, November 2001 Ref: mat.c */ 
&& native("tril",(unsigned long (*)()) tril)
&& native("triu",(unsigned long (*)()) triu)

/* Words that run LAPACK functions by D. Williamson, November 2001 
   Ref: lapack.c */
#ifdef LAPACK
&& native("dgeev",(unsigned long (*)()) dgeev1)
&& native("dgeev2",(unsigned long (*)()) dgeev2)
&& native("dgemm",(unsigned long (*)()) dgemm1)
&& native("dgesv",(unsigned long (*)()) dgesv1)
&& native("dsygv",(unsigned long (*)()) dsygv1)
&& native("dgetri",(unsigned long (*)()) dgetri1)
&& native("dgetrf",(unsigned long (*)()) dgetrf1)
&& native("dgetrs",(unsigned long (*)()) dgetrs1)
&& native("dpotrf",(unsigned long (*)()) dpotrf1)
&& native("reigSSL",(unsigned long (*)()) dsygv1)
&& native("zdscal",(unsigned long (*)()) zdscal1)
&& native("zgemm",(unsigned long (*)()) zgemm1)
&& native("zgesv",(unsigned long (*)()) zgesv1)
&& native("zggev",(unsigned long (*)()) zggev1)

#endif

/* Words for relational database interaction via SQL by A. Danial Nov 2003
   Ref: sql.c */
#ifdef SQLITE
&& native("db_open"  ,     (unsigned long (*)()) db_open)
&& native("db_open2" ,     (unsigned long (*)()) db_open2)
&& native("db_attach",     (unsigned long (*)()) db_attach)
&& native("db_detach",     (unsigned long (*)()) db_detach)
&& native("db_close" ,     (unsigned long (*)()) db_close)
&& native("sql",           (unsigned long (*)()) sql)
#endif

/* Sparse matrix by A. Danial, October 2001 Ref: sparse.c */
&& native("sparse",        (unsigned long (*)()) sparse)
&& native("dense",         (unsigned long (*)()) dense)
&& native("speye",         (unsigned long (*)()) speye)
&& native("spbend",        (unsigned long (*)()) spbend)
&& native("sprand",        (unsigned long (*)()) sprand)
&& native("spy",           (unsigned long (*)()) spy)
&& native("spdiag",        (unsigned long (*)()) spdiag)
&& native("spdump",        (unsigned long (*)()) spdump)
&& native("sperror",       (unsigned long (*)()) sperror)
&& native("spnull",        (unsigned long (*)()) spnull)
&& native("spadd",         (unsigned long (*)()) spadd)
&& native("spmult",        (unsigned long (*)()) spmult)
&& native("spscale",       (unsigned long (*)()) spscale)
&& native("spones",        (unsigned long (*)()) spones)
&& native("spreal_imag",   (unsigned long (*)()) spreal_imag)
&& native("spparkn",       (unsigned long (*)()) spparkn)
&& native("spconvert",     (unsigned long (*)()) spconvert)
&& native("sp2ijv",        (unsigned long (*)()) sp2ijv)
&& native("sppilen",       (unsigned long (*)()) sppilen)
&& native("spcatch",       (unsigned long (*)()) spcatch)
&& native("spreach",       (unsigned long (*)()) spreach)
&& native("spcomb",        (unsigned long (*)()) spcomb)
&& native("sprake",        (unsigned long (*)()) sprake)
&& native("spmesh",        (unsigned long (*)()) spmesh)
&& native("spmult_ss_rr",  (unsigned long (*)()) spmult_ss_rr)
&& native("spmult_ss_rc",  (unsigned long (*)()) spmult_ss_rc)
&& native("spmult_ss_cr",  (unsigned long (*)()) spmult_ss_cr)
&& native("spmult_ss_cc",  (unsigned long (*)()) spmult_ss_cc)
&& native("spmult_sym_low_sd_rr",(unsigned long (*)()) spmult_sym_low_sd_rr)
&& native("spinfo",        (unsigned long (*)()) spinfo)
&& native("spsum",         (unsigned long (*)()) spsum)
&& native("spflip_sym",    (unsigned long (*)()) spflip_sym)
&& native("spinflate",     (unsigned long (*)()) spinflate)
&& native("index_align",   (unsigned long (*)()) index_align)
&& native("index_merge",   (unsigned long (*)()) index_merge)
&& native("spadd_ijv",     (unsigned long (*)()) spadd_ijv)
&& native("is_sparse",     (unsigned long (*)()) is_sparse_word)
&& native("show_tag",      (unsigned long (*)()) show_tag)
&& native("set_tag",       (unsigned long (*)()) set_tag)
&& native("clr_tag",       (unsigned long (*)()) clr_tag)
&& native("get_tag",       (unsigned long (*)()) get_tag)
#ifdef UMFPACK
&& native("splu",          (unsigned long (*)()) splu)
&& native("spfbs",         (unsigned long (*)()) spfbs)
#endif
#ifdef ARPACK
&& native("speig_near_shift",  (unsigned long (*)()) speig_near_shift)
#endif

/* FFTW interface by A. Danial, September 2001 Ref: fftw_driver.c */
#if defined(FFTW) || defined(FFTW3)
&& native("fft",      (unsigned long (*)()) fft)
&& native("ifft",     (unsigned long (*)()) ifft)
&& native("cfft",     (unsigned long (*)()) cfft)
&& native("icfft",    (unsigned long (*)()) icfft)
#endif

/* OP4 and XDB by A. Danial, August 2001 Ref: op4.c, ordering.c, 
   xdbfetch.c */
&& native("sort_seq", (unsigned long (*)()) sort_seq)
&& native("reorder",  (unsigned long (*)()) reorder)
&& native("ascending",(unsigned long (*)()) ascending)
&& native("new_name", (unsigned long (*)()) new_name)
&& native("loadop4",  (unsigned long (*)()) loadop4)
&& native("scanop4",  (unsigned long (*)()) scanop4)
&& native("saveop4",  (unsigned long (*)()) saveop4)
&& native("countop4", (unsigned long (*)()) countop4)
#ifdef XDB
&& native("xdbfetch", (unsigned long (*)()) xdbfetch)
#endif

/* Hash by D. Williamson, June 2001 
   Ref: hash.c */
&& native("_hash",(unsigned long (*)()) hash)
&& native("hash_ActiveBins",(unsigned long (*)()) hash_ActiveBins)
&& native("hash_bin_fetch1",(unsigned long (*)()) hash_bin_fetch1)
&& native("hash_lookup1",(unsigned long (*)()) hash_lookup1)

/* Engineering and scientific subroutine library by A. Danial
   and D. Williamson, May 2001
   Ref: essl.c */

#if defined(ESSL)
&& native("reigSSL",(unsigned long (*)()) reigSSL)
&& native("dsygv",(unsigned long (*)()) reigSSL)
&& native("solveSSL",(unsigned long (*)()) solveSSL)
&& native("symSSL",(unsigned long (*)()) symSSL)
&& native("trilowSSL",(unsigned long (*)()) trilowSSL)
#endif

#if defined(ESSL) || defined(LAPACK)
&& native("ceigSSL",(unsigned long (*)()) ceigSSL)
&& native("cmpySSL",(unsigned long (*)()) cmpySSL)
&& native("diagpostSSL",(unsigned long (*)()) diagpostSSL)
&& native("*dotSSL",(unsigned long (*)()) dotprodSSL)
&& native("movecSSL",(unsigned long (*)()) movecSSL)
&& native("mpySSL",(unsigned long (*)()) mpySSL)
&& native("plusSSL",(unsigned long (*)()) plusSSL)
&& native("*fSSL",(unsigned long (*)()) starfSSL)

/* For essl compatibility with some existing .v files: */
&& native("ceigESSL",(unsigned long (*)()) ceigSSL)
&& native("cmpyESSL",(unsigned long (*)()) cmpySSL)
&& native("diagpostESSL",(unsigned long (*)()) diagpostSSL)
&& native("*dotESSL",(unsigned long (*)()) dotprodSSL)
&& native("movecESSL",(unsigned long (*)()) movecSSL)
&& native("mpyESSL",(unsigned long (*)()) mpySSL)
&& native("plusESSL",(unsigned long (*)()) plusSSL)
&& native("*fESSL",(unsigned long (*)()) starfSSL)
#endif

/* Matlab application program interface by D. Williamson, April 2001
   Ref: matlab.c */
#ifdef MLAB
&& native("_engClose",(unsigned long (*)()) _engClose)
&& native("_engEval",(unsigned long (*)()) _engEval)
&& native("_engGet",(unsigned long (*)()) _engGet)
&& native("_engOpen",(unsigned long (*)()) _engOpen)
&& native("_engPut",(unsigned long (*)()) _engPut)
#endif

/* Linux mgetty voice modem interface by D. Williamson, January 2001
   Ref: vmo.c */
#ifdef VMO 
&& native("vfprops",(unsigned long (*)()) vfprops)
&& native("vmcommand",(unsigned long (*)()) vmcommand)
&& native("vmcompression",(unsigned long (*)()) vmcompression)
&& native("vmdiagnostics",(unsigned long (*)()) vmdiagnostics)
&& native("vmdial",(unsigned long (*)()) vmdial)
&& native("vmflow",(unsigned long (*)()) vmflow)
&& native("vmlog",(unsigned long (*)()) vmlog)
&& native("vmplay",(unsigned long (*)()) vmplay)
&& native("vmrecord",(unsigned long (*)()) vmrecord)
&& native("vmregister",(unsigned long (*)()) vmregister)
&& native("vmstate",(unsigned long (*)()) vmstate)
&& native("vmstop",(unsigned long (*)()) vmstop)
&& native("vmstruct",(unsigned long (*)()) vmstruct)
&& native("vmunregister",(unsigned long (*)()) vmunregister)
&& native("vmwatch",(unsigned long (*)()) vmwatch)
#endif

/*--------------------------------------------------------------------*/

/* Program native words and native constants by D. Williamson, 
   May 1999 */
&& native("swap",(unsigned long (*)()) swap)
&& native("back",(unsigned long (*)()) swap)
&& native("bob",(unsigned long (*)()) swap)
&& native("duck",(unsigned long (*)()) swap)
&& native("nod",(unsigned long (*)()) swap)
&& native("rose",(unsigned long (*)()) swap)

&& native("dup",(unsigned long (*)()) dup1s)
&& native("again",(unsigned long (*)()) dup1s)
&& native("ape",(unsigned long (*)()) dup1s)
&& native("its",(unsigned long (*)()) dup1s)
&& native("these",(unsigned long (*)()) dup1s)
&& native("this",(unsigned long (*)()) dup1s)
&& native("too",(unsigned long (*)()) dup1s)
&& native("uh",(unsigned long (*)()) dup1s)
&& native("what",(unsigned long (*)()) dup1s)
&& native("2dup",(unsigned long (*)()) dup2s)
&& native("3dup",(unsigned long (*)()) dup3s)
&& native("cop",(unsigned long (*)()) cop)

&& native("over",(unsigned long (*)()) over)
&& native("that",(unsigned long (*)()) over)
&& native("those",(unsigned long (*)()) over)

&& native("drop",(unsigned long (*)()) drop)
&& native("club",(unsigned long (*)()) drop)
&& native("eat",(unsigned long (*)()) drop)
&& native("fling",(unsigned long (*)()) drop)
&& native("hawk",(unsigned long (*)()) drop)
&& native("trash",(unsigned long (*)()) drop)
&& native("whack",(unsigned long (*)()) drop)

&& native("xx",(unsigned long (*)()) clear_stack)
&& native("xl",(unsigned long (*)()) clear_temp_stack)
&& native("clrfs",(unsigned long (*)()) clrfs)
&& native("2drop",(unsigned long (*)()) drop2)

&& native("lop",(unsigned long (*)()) lop)
&& native("pick",(unsigned long (*)()) pick)
&& native("other",(unsigned long (*)()) other)
&& native("them",(unsigned long (*)()) other)
&& native("roll",(unsigned long (*)()) roll)
&& native("rot",(unsigned long (*)()) rot)
&& native("rev",(unsigned long (*)()) rev)
&& native("revn",(unsigned long (*)()) revn)
&& native("depth",(unsigned long (*)()) depth)
&& native("depthMIN",(unsigned long (*)()) depthMIN)
&& native("depthMIN_set",(unsigned long (*)()) depthMIN_set)
&& native("depthSTK",(unsigned long (*)()) depthSTK)

&& native("pull",(unsigned long (*)()) lpull)
&& native("push",(unsigned long (*)()) lpush)
&& native("peek",(unsigned long (*)()) lpeek)
&& native("peel",(unsigned long (*)()) lpick)
&& native("tdepth",(unsigned long (*)()) tdepth)
&& native("tok",(unsigned long (*)()) tok)

&& native("pickfs",(unsigned long (*)()) pickfs)
&& native("pullfs",(unsigned long (*)()) pullfs)
&& native("pushfs",(unsigned long (*)()) pushfs)
&& native("fsdepth",(unsigned long (*)()) fsdepth)

&& native("noop",(unsigned long (*)()) noop)
&& native("@*",(unsigned long (*)()) noop)
&& native("+",(unsigned long (*)()) plus)
&& native("plus",(unsigned long (*)()) plus)
&& native("+d",(unsigned long (*)()) plusd)
&& native("plusi",(unsigned long (*)()) plusi)
&& native("-",(unsigned long (*)()) minus)
&& native("minus",(unsigned long (*)()) minus)
&& native("less",(unsigned long (*)()) minus)
&& native("-d",(unsigned long (*)()) minusd)
&& native("*",(unsigned long (*)()) star)
&& native("star",(unsigned long (*)()) star)
&& native("mpydg",(unsigned long (*)()) mpydg)
&& native("overlay",(unsigned long (*)()) overlay)
&& native("mpy",(unsigned long (*)()) mpy)
&& native("mpyad",(unsigned long (*)()) mpyad)
&& native("*f",(unsigned long (*)()) starf)
&& native("*by",(unsigned long (*)()) starby)
&& native("*dot",(unsigned long (*)()) dotprod)
&& native("*cross",(unsigned long (*)()) cross)
&& native("*diagonal",(unsigned long (*)()) diagpost)
&& native("diagpost",(unsigned long (*)()) diagpost)
&& native("diagpre",(unsigned long (*)()) diagpre)
&& native("cross-correlation",(unsigned long (*)()) cross_correlation)
&& native("norm",(unsigned long (*)()) norm)
&& native("mag",(unsigned long (*)()) mag)
&& native("/",(unsigned long (*)()) slash)
&& native("slash",(unsigned long (*)()) slash)
&& native("/f",(unsigned long (*)()) slashf)
&& native("/by",(unsigned long (*)()) slashby)
&& native("/mod",(unsigned long (*)()) slashmod)
&& native("modq",(unsigned long (*)()) slashmod) /* for parsing */
&& native("mod",(unsigned long (*)()) mod)
&& native("%",(unsigned long (*)()) mod1)
&& native("pow",(unsigned long (*)()) power)
&& native("^by",(unsigned long (*)()) power1)
&& native("sqrt",(unsigned long (*)()) sqrt1) 
&& native("**",(unsigned long (*)()) power)
&& native("^",(unsigned long (*)()) power)
&& native("negate",(unsigned long (*)()) negate)
&& native("abs",(unsigned long (*)()) abs1)
&& native("max",(unsigned long (*)()) max1)
&& native("max1",(unsigned long (*)()) max2)
&& native("mmax1",(unsigned long (*)()) mmax1)
&& native("maxfetch",(unsigned long (*)()) maxfetch)
&& native("min",(unsigned long (*)()) min1)
&& native("min1",(unsigned long (*)()) min2)
&& native("mmin1",(unsigned long (*)()) mmin1)
&& native("nzmin1",(unsigned long (*)()) nzmin1)
&& native("minfetch",(unsigned long (*)()) minfetch)
&& native("partials",(unsigned long (*)()) partials)
&& native("compareRef",(unsigned long (*)()) compare)
&& native("filter",(unsigned long (*)()) filter1)
&& native("lag",(unsigned long (*)()) lag)
&& native("delta",(unsigned long (*)()) delta)
&& native("stats",(unsigned long (*)()) stats)
&& native("colsort",(unsigned long (*)()) colsort)
&& native("colsort1",(unsigned long (*)()) colsort1)
&& native("ceig",(unsigned long (*)()) ceig)
&& native("conj",(unsigned long (*)()) conj1)
&& native("s3coef",(unsigned long (*)()) s3coef)
&& native("s3eval",(unsigned long (*)()) s3eval)
&& native("complex",(unsigned long (*)()) dblcmplx)
&& native("cmplxmatch",(unsigned long (*)()) cmplxmatch)
&& native("is_complex",(unsigned long (*)()) is_complex_word) 
&& native("real-imag",(unsigned long (*)()) cmplxdbl)
&& native("Im",(unsigned long (*)()) cmpximag)
&& native("Re",(unsigned long (*)()) cmpxreal)

&& native("nit",(unsigned long (*)()) nit)
&& native("1-",(unsigned long (*)()) nit)
&& native("tic",(unsigned long (*)()) tic)
&& native("1+",(unsigned long (*)()) tic)

&& native("ln",(unsigned long (*)()) ln)
&& native("log",(unsigned long (*)()) ln)
&& native("e^",(unsigned long (*)()) exp1)
&& native("log10",(unsigned long (*)()) log10_)
&& native("10^",(unsigned long (*)()) tenpow)
&& native("log2",(unsigned long (*)()) log2a)
&& native("2^",(unsigned long (*)()) twopow)
&& native("log5",(unsigned long (*)()) log5)
&& native("5^",(unsigned long (*)()) fivepow)
&& native("cos",(unsigned long (*)()) cos1)
&& native("sin",(unsigned long (*)()) sin1)
&& native("tan",(unsigned long (*)()) tan1)
&& native("cosh",(unsigned long (*)()) cosh1)
&& native("sinh",(unsigned long (*)()) sinh1)
&& native("tanh",(unsigned long (*)()) tanh1)
&& native("atan2",(unsigned long (*)()) atan2_)

/*--------------------------------------------------------------------*/

&& constant("pi", "3.14159265358979323846")
&& constant("2pi","6.28318530717958623200")

&& constant("cyc/rad","0.15915494309189535")
&& constant("cyc_per_rad","0.15915494309189535")

&& constant("deg/rad","57.295779513082323")
&& constant("deg_per_rad","57.295779513082323")

&& constant("rad/cyc","6.2831853071795862320")
&& constant("rad_per_cyc","6.2831853071795862320")

&& constant("rad/deg","0.017453292519943295")
&& constant("rad_per_deg","0.017453292519943295")

&& constant("cm/in","2.54")
&& constant("cm_per_in","2.54")

&& constant("mm/in","25.4")
&& constant("mm_per_in","25.4")

&& constant("oh","0.0")
&& constant("zero","0.0")
&& constant("once","1.0")
&& constant("one","1.0")
&& constant("twice","2.0")
&& constant("two","2.0")
&& constant("three","3.0")
&& constant("four","4.0")
&& constant("five","5.0")
&& constant("six","6.0")
&& constant("seven","7.0")
&& constant("eight","8.0")
&& constant("nine","9.0")
&& constant("ten","10.0")
&& constant("NL","10")
&& constant("ESC","27")
&& constant("BL","32")

&& native("INF",(unsigned long (*)()) INFpos)
&& native("Inf",(unsigned long (*)()) INFpos)
&& native("GIJILLION",(unsigned long (*)()) INFpos)
&& native("nullbyte",(unsigned long (*)()) nullbyte)
&& native("NULLch",(unsigned long (*)()) nullbyte)

&& native("-INF",(unsigned long (*)()) INFneg)
&& native("-Inf",(unsigned long (*)()) INFneg)
&& native("UNDEF",(unsigned long (*)()) INFneg)
&& native("UDEF",(unsigned long (*)()) INFneg)
&& native("endian",(unsigned long (*)()) byteorder1)

&& constant("LITTLE_ENDIAN","1234")
&& constant("BIG_ENDIAN","4321")
&& constant("PDP_ENDIAN","3412")

&& constant("MILLION","1+6")

/*--------------------------------------------------------------------*/

&& native("define:",(unsigned long (*)()) define)
&& native("defname",(unsigned long (*)()) defname)
&& native("tag",(unsigned long (*)()) tag)
&& native("tagsep",(unsigned long (*)()) tagsep)
&& native("fence",(unsigned long (*)()) fence)
&& native("fence_at",(unsigned long (*)()) fence_at)
&& native("notag",(unsigned long (*)()) notag)
&& native("inline",(unsigned long (*)()) inline1)
&& native("inlinex",(unsigned long (*)()) inlinex)
&& native("-inlinex",(unsigned long (*)()) inlinex1)
&& native("pf",(unsigned long (*)()) inlinex1)
&& native("macro",(unsigned long (*)()) inlinex1)
&& native("inline:",(unsigned long (*)()) inline2)
&& native("execute",(unsigned long (*)()) execute)
&& native("main",(unsigned long (*)()) main1)
&& native("mainif",(unsigned long (*)()) mainif)
&& native("local",(unsigned long (*)()) local)
&& native("loca",(unsigned long (*)()) local)
&& native("libpry",(unsigned long (*)()) libpry)
&& native("runlevel",(unsigned long (*)()) runlevel)
&& native("list:",(unsigned long (*)()) list)
&& native("vector:",(unsigned long (*)()) list)
&& native("\"",(unsigned long (*)()) pushq3)
&& native("'",(unsigned long (*)()) pushq3)

&& native("{\"",(unsigned long (*)()) pushtex3)
/* This one always trips me up (see the ABC part):

   When using {" ... "}, the text being enclosed is on separate
   lines between the brace-quotes, as in

      {" text on this line is skipped

         --- blank lines are included ---

         This is some
         text that will

         appear on the

         stack as a
         text volume.

         --- blank lines are included ---

  ABC "} left justify, "myText" book

  Any text preceding the closing "} on its line, like ABC, will be
  missed.
*/

&& native("book",(unsigned long (*)()) book1)
&& native("_container",(unsigned long (*)()) container)
&& native("equate",(unsigned long (*)()) into)
&& native("called",(unsigned long (*)()) into)
&& native("into",(unsigned long (*)()) into)
&& native("is",(unsigned long (*)()) into)
&& native("are",(unsigned long (*)()) into)
&& native("makes",(unsigned long (*)()) into)
&& native("onto",(unsigned long (*)()) into)
&& native("says",(unsigned long (*)()) into)
&& native("run",(unsigned long (*)()) run)
&& native("runt",(unsigned long (*)()) runt)

&& native("ptr",(unsigned long (*)()) ptr)
&& native("matptr",(unsigned long (*)()) matptr)
&& native("volptr",(unsigned long (*)()) matptr)
&& native("ptr?",(unsigned long (*)()) ptrq)
&& native("ptrtok",(unsigned long (*)()) ptrtok)
&& native("ptrtable",(unsigned long (*)()) ptrtable)
&& native("exe",(unsigned long (*)()) exe)
&& native("exe?",(unsigned long (*)()) exeq)
&& native("pryexe",(unsigned long (*)()) pryexe)

&& native("mallinfo",(unsigned long (*)()) mallinfo1)
&& native("memarena",(unsigned long (*)()) memarena)
&& native("memfreed",(unsigned long (*)()) memfreed)
&& native("memprobe",(unsigned long (*)()) memprobe)
&& native("memprobe1",(unsigned long (*)()) memprobe1)
&& native("meminuse",(unsigned long (*)()) meminuse)
&& native("memfree",(unsigned long (*)()) memfree)
&& native("mempeek",(unsigned long (*)()) mempeek)
&& native("mempull",(unsigned long (*)()) mempull)
&& native("memput",(unsigned long (*)()) memput)
&& native("memptr",(unsigned long (*)()) memput)
&& native("memptrshow",(unsigned long (*)()) memptrshow)
&& native("getbrk",(unsigned long (*)()) getbrk)
&& native("setbrk",(unsigned long (*)()) setbrk)

&& native("end",(unsigned long (*)()) end1)
&& native("[Enter]",(unsigned long (*)()) end1)
&& native(";",(unsigned long (*)()) end1)

&& native("feed",(unsigned long (*)()) feed)

&& native("halt",(unsigned long (*)()) halt)
&& native("HALT",(unsigned long (*)()) HALT)
&& native("jmptable",(unsigned long (*)()) jmptable)
&& native("return",(unsigned long (*)()) return1)
&& native("return2",(unsigned long (*)()) return2)
&& native("erp",(unsigned long (*)()) erp)
&& native("ersys",(unsigned long (*)()) ersys)
&& native("ertrip",(unsigned long (*)()) ertrip)
&& native("done",(unsigned long (*)()) done)
&& native("done_off",(unsigned long (*)()) doneoff)

/* Allows tutorial phrases, like: pi 6 dup 25 [Enter key] */
&& native("[Enter",(unsigned long (*)()) done)

&& native("source",(unsigned long (*)()) source)
&& native("include",(unsigned long (*)()) source)
&& native("asciiload",(unsigned long (*)()) asciiload)
&& native("asciiread",(unsigned long (*)()) asciiread)
&& native("matread",(unsigned long (*)()) matread)
&& native("file?",(unsigned long (*)()) fileq)
&& native("filefound",(unsigned long (*)()) filefound)
&& native("file",(unsigned long (*)()) fileopen)
&& native("open",(unsigned long (*)()) fileopen)
&& native("filetemp",(unsigned long (*)()) fileopen1)
&& native("filetrue",(unsigned long (*)()) fileid)
&& native("fseek",(unsigned long (*)()) fileseek)
&& native("fstep",(unsigned long (*)()) filestep)
&& native("fpos",(unsigned long (*)()) fpos1)
&& native("fget",(unsigned long (*)()) fileget)
&& native("fgetr",(unsigned long (*)()) filegetr)
&& native("fput",(unsigned long (*)()) fileput)
&& native("fputr",(unsigned long (*)()) fileputr)
&& native("fclose",(unsigned long (*)()) fileclose)
&& native("xray",(unsigned long (*)()) xray)
&& native("close",(unsigned long (*)()) fileclose)
&& native("save",(unsigned long (*)()) fsave)
&& native("append",(unsigned long (*)()) fappend)
&& native("fallow",(unsigned long (*)()) fallow)
&& native("filesize",(unsigned long (*)()) filesize)
&& native("fsize",(unsigned long (*)()) filesize1)
&& native("filetime",(unsigned long (*)()) filetime)
&& native("filectime",(unsigned long (*)()) filectime)
&& native("fileatime",(unsigned long (*)()) fileatime)
&& native("dir?",(unsigned long (*)()) dirq)
&& native("dirnames",(unsigned long (*)()) dirnames)
&& native("dirsize",(unsigned long (*)()) dirsize)
&& native("chdir",(unsigned long (*)()) chdir1)
&& native("chmod",(unsigned long (*)()) chmodf)
&& native("chperm",(unsigned long (*)()) chperm)
&& native("ascii",(unsigned long (*)()) ascii)
&& native("binary",(unsigned long (*)()) binary)
&& native("new",(unsigned long (*)()) new)
&& native("old",(unsigned long (*)()) old)
&& native("export1",(unsigned long (*)()) export1)
&& native("export2",(unsigned long (*)()) export2)
&& native("export4",(unsigned long (*)()) export4)
&& native("export8",(unsigned long (*)()) export8)
&& native("import1",(unsigned long (*)()) import1)
&& native("import2",(unsigned long (*)()) import2)
&& native("import4",(unsigned long (*)()) import4)
&& native("import4f",(unsigned long (*)()) import4f)
&& native("import8",(unsigned long (*)()) import8)
&& native("uimport1",(unsigned long (*)()) uimport1)
&& native("uimport2",(unsigned long (*)()) uimport2)
&& native("uimport4",(unsigned long (*)()) uimport4)
&& native("get",(unsigned long (*)()) get)
&& native("getn",(unsigned long (*)()) getn)
&& native("put",(unsigned long (*)()) put)
&& native("putn",(unsigned long (*)()) putn)
&& native("toc",(unsigned long (*)()) toc)
&& native("get4",(unsigned long (*)()) get4)
&& native("get4c",(unsigned long (*)()) get4c)
&& native("put4",(unsigned long (*)()) put4)
&& native("_toc4",(unsigned long (*)()) _toc4)
&& native("toc4",(unsigned long (*)()) toc4)
&& native("copy4",(unsigned long (*)()) copy4)
&& native("textget",(unsigned long (*)()) textget0)
&& native("fortmap",(unsigned long (*)()) fortmap)
&& native("fortput",(unsigned long (*)()) fortput)
&& native("fortrecs",(unsigned long (*)()) fortrecs)

&& native("blockofblanks",(unsigned long (*)()) blockofblanks)
&& native("tpurged",(unsigned long (*)()) tpurged)
&& native("null",(unsigned long (*)()) null)
&& native("empty",(unsigned long (*)()) null)
&& native("scalar",(unsigned long (*)()) scalar)
&& native("spaced",(unsigned long (*)()) spaced)
&& native("tail",(unsigned long (*)()) tail)
&& native("VARIABLE",(unsigned long (*)()) scalar)
&& native("fill",(unsigned long (*)()) fill)
&& native("identity",(unsigned long (*)()) identity)
&& native("eye"     ,(unsigned long (*)()) identity)
&& native("sq",(unsigned long (*)()) sq1)
&& native("diag",(unsigned long (*)()) tovector)
&& native("dg",(unsigned long (*)()) tovector)
&& native("I3x3",(unsigned long (*)()) I3x3)
&& native("Origin",(unsigned long (*)()) origin)
&& native("Xvec",(unsigned long (*)()) Xvec)
&& native("Yvec",(unsigned long (*)()) Yvec)
&& native("Zvec",(unsigned long (*)()) Zvec)
&& native("uniform",(unsigned long (*)()) uniform)
&& native("nullc",(unsigned long (*)()) nullc)
&& native("nullr",(unsigned long (*)()) nullr)
&& native("listn",(unsigned long (*)()) listfin)
&& native("\0",(unsigned long (*)()) token0)
&& native("urn",(unsigned long (*)()) urn)
&& native("rand",(unsigned long (*)()) urn)
&& native("random",(unsigned long (*)()) random1)
&& native("brandom",(unsigned long (*)()) brandom)
&& native("cruddy",(unsigned long (*)()) random1)
&& native("trandom",(unsigned long (*)()) trandom)
&& native("seed0",(unsigned long (*)()) seed0)
&& native("seedget",(unsigned long (*)()) seedget)
&& native("seedset",(unsigned long (*)()) seedset)
&& native("add_idx",(unsigned long (*)()) add_idx)
&& native("get_idx",(unsigned long (*)()) get_idx)

/*--------------------------------------------------------------------*/

/* Control structures */
&& native("DO",(unsigned long (*)()) doloop)
&& native("?DO",(unsigned long (*)()) doloop1)
&& native("LOOP",(unsigned long (*)()) dojmp)
&& native("+LOOP",(unsigned long (*)()) dojmp1)
&& native("I",(unsigned long (*)()) doindex0)
&& native("J",(unsigned long (*)()) doindex1)
/*
&& native("K",(unsigned long (*)()) doindex2)
*/
&& native("EXIT",(unsigned long (*)()) doexit)
&& native("BEGIN",(unsigned long (*)()) begin)
&& native("WHILE",(unsigned long (*)()) while1)
&& native("REPEAT",(unsigned long (*)()) repeat)
&& native("UNTIL",(unsigned long (*)()) until)
&& native("IF",(unsigned long (*)()) ifbranch)
&& native("ELSE",(unsigned long (*)()) ifelse)
&& native("THEN",(unsigned long (*)()) ifthen)
&& native("[",(unsigned long (*)()) brak)
&& native("]",(unsigned long (*)()) brakend)

&& native("indexbase",(unsigned long (*)()) setxbase)
&& native("0based",(unsigned long (*)()) base0)
&& native("1based",(unsigned long (*)()) base1)
&& native("xbase",(unsigned long (*)()) xbase)
&& native("TIMES",(unsigned long (*)()) xbase)
&& native("1st",(unsigned long (*)()) xbase)
&& native("2nd",(unsigned long (*)()) xbase1)
&& native("3rd",(unsigned long (*)()) xbase2)
&& native("4th",(unsigned long (*)()) xbase3)
&& native("ndx",(unsigned long (*)()) ndx)
&& native("qdx",(unsigned long (*)()) qdx)

/* Stack and catalog: */
&& native("props",(unsigned long (*)()) props)
&& native("cprops",(unsigned long (*)()) cprops)
&& native("type",(unsigned long (*)()) type1)
&& native("ctype",(unsigned long (*)()) ctype)
&& native("catbins",(unsigned long (*)()) catbins)
&& native("catnames",(unsigned long (*)()) catnames)
&& native("_catitems",(unsigned long (*)()) catitems)
&& native("catseq",(unsigned long (*)()) catseq)
&& native("catsearch",(unsigned long (*)()) catsearch1)

&& native("beep",(unsigned long (*)()) beep1)
&& native("public",(unsigned long (*)()) public)
&& native("private",(unsigned long (*)()) publicoff)
&& native("time",(unsigned long (*)()) timesys)
&& native("time1",(unsigned long (*)()) timesys1)
&& native("timeprobe",(unsigned long (*)()) timeprobe)
&& native("GMTdelta",(unsigned long (*)()) GMTdelta)
&& native("greg",(unsigned long (*)()) greg)
&& native("ltime",(unsigned long (*)()) mktime1)
&& native("ctime",(unsigned long (*)()) ctime1)
&& native("gmtime",(unsigned long (*)()) gmtime1)
&& native("date",(unsigned long (*)()) datesys)
&& native("date1",(unsigned long (*)()) datesys1)
&& native("date2",(unsigned long (*)()) datesys2)
&& native("trace",(unsigned long (*)()) trace1)
&& native("-trace",(unsigned long (*)()) traceoff1)
&& native("notrace",(unsigned long (*)()) traceoff1)
&& native("TRACE",(unsigned long (*)()) traceflag)
&& native("wtrace",(unsigned long (*)()) wtrace)
&& native("nowtrace",(unsigned long (*)()) wtraceoff)
&& native("hide",(unsigned long (*)()) hideon)
&& native("-hide",(unsigned long (*)()) hideoff)
&& native("nohide",(unsigned long (*)()) hideoff)
&& native("stkbal",(unsigned long (*)()) stkbal)
&& native("-stkbal",(unsigned long (*)()) stkbaloff)
&& native("strict",(unsigned long (*)()) strict)
&& native("-strict",(unsigned long (*)()) strictoff)
&& native("nullshell",(unsigned long (*)()) nullshell)
&& native("shell",(unsigned long (*)()) shell)
&& native("shellget",(unsigned long (*)()) shellget)
&& native("shellset",(unsigned long (*)()) shellset)
&& native("system",(unsigned long (*)()) shell)
&& native("_host",(unsigned long (*)()) hostname)
&& native("os",(unsigned long (*)()) os)
&& native("os_ver",(unsigned long (*)()) os_ver)
&& native("getlogin",(unsigned long (*)()) getlogin1)
&& native("getpid",(unsigned long (*)()) getpid1)
&& native("getuid",(unsigned long (*)()) getuid1)
&& native("pwd",(unsigned long (*)()) getpwd)
&& native("getenv",(unsigned long (*)()) getenv1)
&& native("setenv",(unsigned long (*)()) putenv1)
&& native("setenv1",(unsigned long (*)()) setenv1)
&& native("env",(unsigned long (*)()) env)
&& native("argv",(unsigned long (*)()) argv)
&& native("delete",(unsigned long (*)()) delete)
&& native("catmsg",(unsigned long (*)()) catmsg)
&& native("CATMSG",(unsigned long (*)()) catmsgflag)
&& native("INFIX",(unsigned long (*)()) infixflag)
&& native("infix_set",(unsigned long (*)()) infix_set)
&& native(">>",(unsigned long (*)()) infix)
&& native("<<",(unsigned long (*)()) postfix)

&& native("putch",(unsigned long (*)()) putch1)
&& native("exists?",(unsigned long (*)()) exists)
&& native("local?",(unsigned long (*)()) localq)
&& native("bye",(unsigned long (*)()) bye)
&& native("exit",(unsigned long (*)()) quit)
&& native("quit",(unsigned long (*)()) quit)
&& native("proghello",(unsigned long (*)()) proghello)
&& native("abort",(unsigned long (*)()) abort1)
&& native("HLMAX",(unsigned long (*)()) hlmax)
/*
&& native("END",(unsigned long (*)()) byeflag)
*/

/*--------------------------------------------------------------------*/

&& native("decode",(unsigned long (*)()) tdecode)
&& native("encode",(unsigned long (*)()) tencode)
&& native("tkey",(unsigned long (*)()) tkey)
&& native("bload",(unsigned long (*)()) tload)
&& native("brun",(unsigned long (*)()) tload1)
&& native("bmake",(unsigned long (*)()) tmake)
&& native("disassemble",(unsigned long (*)()) disassemble)

/* Multitasker */
&& native("tasks",(unsigned long (*)()) taskdisp)
&& native("tasks_omit",(unsigned long (*)()) tasks_omit)
&& native("ping",(unsigned long (*)()) ping)
&& native("frate",(unsigned long (*)()) frate)
&& native("ftic",(unsigned long (*)()) ftic)
&& native("timtic",(unsigned long (*)()) timtic1)
&& native("WAKE",(unsigned long (*)()) taskwake)
&& native("OMIT",(unsigned long (*)()) taskomit)
&& native("SLEEP",(unsigned long (*)()) tasksleep)
&& native("TASK",(unsigned long (*)()) taskdef)
&& native("ALARM",(unsigned long (*)()) taskalarm)
&& native("-ALARM",(unsigned long (*)()) taskomit1)
&& native("RATE",(unsigned long (*)()) taskrate)
&& native("X11",(unsigned long (*)()) _X11)

&& native("LOCK",(unsigned long (*)()) LOCK1)
&& native("LOCKED",(unsigned long (*)()) LOCKED1)
&& native("UNLOCK",(unsigned long (*)()) UNLOCK)

/* Keyboard */
&& native("keys?",(unsigned long (*)()) keyq)
#ifdef KEYBOARD
&& native("_LINES",(unsigned long (*)()) curslin)
&& native("_COLS",(unsigned long (*)()) curscol)
&& native("UP",(unsigned long (*)()) main2)
&& native("accept_keys",(unsigned long (*)()) accept_keys)
&& native("accept",(unsigned long (*)()) accept1)
&& native("ESCq",(unsigned long (*)()) ESCq1)
&& native("getch",(unsigned long (*)()) getchk)
&& native("getcht",(unsigned long (*)()) getcht)
&& native("getkeys",(unsigned long (*)()) getkeys)
&& native("history",(unsigned long (*)()) khpush)
&& native("KBtoggle",(unsigned long (*)()) KBtoggle)
&& native("keyboard",(unsigned long (*)()) keyboard)
&& native("keyignore",(unsigned long (*)()) keyignore)
&& native("key_in",(unsigned long (*)()) key_in)
&& native("khit",(unsigned long (*)()) khit)
&& native("koff",(unsigned long (*)()) koff)
&& native("kon",(unsigned long (*)()) kon)
&& native("-kon",(unsigned long (*)()) koff)
&& native("ktime",(unsigned long (*)()) ktime)
&& native("prompter",(unsigned long (*)()) prompter)
&& native("story",(unsigned long (*)()) story)
&& native("tty",(unsigned long (*)()) tty)
&& native("tos",(unsigned long (*)()) tos1)
&& native("typing",(unsigned long (*)()) typing)
#endif

/*--------------------------------------------------------------------*/

#ifdef X11
&& native("wincreate",(unsigned long (*)()) wincreate)
&& native("wincopy",(unsigned long (*)()) wincopy)
&& native("windows",(unsigned long (*)()) windisp)
&& native("winfree",(unsigned long (*)()) winfree)
&& native("winshow",(unsigned long (*)()) winshow)
&& native("winclear",(unsigned long (*)()) winclear)
&& native("winraise",(unsigned long (*)()) winraise)
&& native("winresize",(unsigned long (*)()) winresize)

&& native("Xresource",(unsigned long (*)()) dbget1)
&& native("XAtom",(unsigned long (*)()) atomget)
&& native("XImage",(unsigned long (*)()) Ximageprops)
&& native("winregion",(unsigned long (*)()) XRegionSet)
&& native("winregionfree",(unsigned long (*)()) XRegionFree)

&& native("dprops",(unsigned long (*)()) dprops)
&& native("dheight",(unsigned long (*)()) dheight)
&& native("dheightMM",(unsigned long (*)()) dheightMM)
&& native("dwidth",(unsigned long (*)()) dwidth)
&& native("dwidthMM",(unsigned long (*)()) dwidthMM)

&& native("bitmapf",(unsigned long (*)()) bitmapf)
&& native("fontload",(unsigned long (*)()) fontload)
&& native("colorpix",(unsigned long (*)()) colorpix)
&& native("GCcreate",(unsigned long (*)()) GCcreate)
&& native("GCfore",(unsigned long (*)()) GCfore)
&& native("GCfree",(unsigned long (*)()) GCfree)
&& native("GCline",(unsigned long (*)()) GCline)
&& native("line",(unsigned long (*)()) line)
&& native("linec",(unsigned long (*)()) linec)
&& native("pminmax",(unsigned long (*)()) pminmax)
&& native("wdemo",(unsigned long (*)()) wdemo)
/*
Obsolete pipes to gnuplot
&& native("XPipe",(unsigned long (*)()) XPipe)
&& native("XPipeClose",(unsigned long (*)()) XPipeClose)
&& native("XWindow",(unsigned long (*)()) XWindow)
&& native("XTest",(unsigned long (*)()) XTestw)
&& native("XTestn",(unsigned long (*)()) XTestn)
&& native("X11command",(unsigned long (*)()) X11command)
&& native("Xtos",(unsigned long (*)()) Xtos)
*/
#endif
&& native("winfocus",(unsigned long (*)()) winfocus)
&& native("winkey",(unsigned long (*)()) winkey)

&& native("bit",(unsigned long (*)()) bit)
&& native("bitoff",(unsigned long (*)()) bitoff)
&& native("biton",(unsigned long (*)()) biton)
&& native("sign",(unsigned long (*)()) sign)

&& native("and",(unsigned long (*)()) and)
&& native("and_",(unsigned long (*)()) and_)
&& native("not",(unsigned long (*)()) not)
&& native("nott",(unsigned long (*)()) nottx)
&& native("nottx",(unsigned long (*)()) nott)
&& native("or",(unsigned long (*)()) or)
&& native("or_",(unsigned long (*)()) or_)
&& native("xor",(unsigned long (*)()) xor)
&& native("=",(unsigned long (*)()) eq)
&& native(">=",(unsigned long (*)()) ge)
&& native(">",(unsigned long (*)()) gt)
&& native("<=",(unsigned long (*)()) le)
&& native("<",(unsigned long (*)()) lt)
&& native("<>",(unsigned long (*)()) ne)
&& native("0=",(unsigned long (*)()) zeroeq)
&& native("0>",(unsigned long (*)()) zerogt)
&& native("any",(unsigned long (*)()) zerogt)
&& native("any?",(unsigned long (*)()) anyq)
&& native("0<",(unsigned long (*)()) zerolt)
&& native("0<>",(unsigned long (*)()) zerone)

&& native("integer",(unsigned long (*)()) integer)
&& native("rounded",(unsigned long (*)()) rounded)
&& native("int",(unsigned long (*)()) int4_)
&& native("ints",(unsigned long (*)()) int4_)
&& native("int8",(unsigned long (*)()) int8_)
&& native("uint",(unsigned long (*)()) uint4_)
&& native("uints",(unsigned long (*)()) uint4_)
&& native("long",(unsigned long (*)()) uint4_)
&& native("int2",(unsigned long (*)()) int2)
&& native("uint2",(unsigned long (*)()) int2)
&& native("int4",(unsigned long (*)()) int4)
&& native("uint4",(unsigned long (*)()) int4)
&& native("2real",(unsigned long (*)()) real2)
&& native("4real",(unsigned long (*)()) real4)
&& native("u2real",(unsigned long (*)()) ureal2)
&& native("u4real",(unsigned long (*)()) ureal4)
&& native("longhex",(unsigned long (*)()) longhex)

&& native("true",(unsigned long (*)()) true)
&& native("yes",(unsigned long (*)()) true)
&& native("right",(unsigned long (*)()) true)
&& native("smash",(unsigned long (*)()) true)

&& native("false",(unsigned long (*)()) false)
&& native("no",(unsigned long (*)()) false)
&& native("left",(unsigned long (*)()) false)
&& native("fail",(unsigned long (*)()) false)

&& native("quote",(unsigned long (*)()) quote)
&& native("quite",(unsigned long (*)()) quote)
&& native("said",(unsigned long (*)()) said)
&& native("strput",(unsigned long (*)()) totext)
&& native("word",(unsigned long (*)()) word)
&& native("words",(unsigned long (*)()) words)
&& native("string",(unsigned long (*)()) string)
&& native("strings",(unsigned long (*)()) strings)
&& native("numbers",(unsigned long (*)()) numbers)
&& native("strlen",(unsigned long (*)()) strlenq)
&& native("strmatch0",(unsigned long (*)()) strmatch0)
&& native("strmatch",(unsigned long (*)()) strmatch1)
&& native("strcmp",(unsigned long (*)()) strmatch1)
&& native("alike",(unsigned long (*)()) alike)
&& native("str0",(unsigned long (*)()) str0)
&& native("strarray",(unsigned long (*)()) strarray)
&& native("strarrayx",(unsigned long (*)()) strarrayx)
&& native("lowercase",(unsigned long (*)()) lowercase)
&& native("uppercase",(unsigned long (*)()) uppercase)
&& native("tug",(unsigned long (*)()) tug)
&& native("smap",(unsigned long (*)()) smap)
&& native("grepe",(unsigned long (*)()) grepe)
&& native("grepr",(unsigned long (*)()) grepr)
&& native("chblank",(unsigned long (*)()) chblank)
&& native("chkeep",(unsigned long (*)()) chkeep)
&& native("cheep",(unsigned long (*)()) chkeep)

&& native("rows",(unsigned long (*)()) rows)
&& native("cols",(unsigned long (*)()) cols)
&& native("chars",(unsigned long (*)()) cols)
&& native("bytes",(unsigned long (*)()) cols)
&& native("cobs",(unsigned long (*)()) cols)
&& native("cows",(unsigned long (*)()) cols)
&& native("dims",(unsigned long (*)()) dims)
&& native("sizeof",(unsigned long (*)()) sizeof_item)
&& native("BITS",(unsigned long (*)()) BITS)
&& native("spcols",(unsigned long (*)()) spcols)
&& native("spdims",(unsigned long (*)()) spdims)
&& native("sprows",(unsigned long (*)()) sprows)

&& native("replace",(unsigned long (*)()) replace)
&& native("ontop",(unsigned long (*)()) ontop)
&& native("@",(unsigned long (*)()) ontop)
&& native("bang",(unsigned long (*)()) bang)
&& native("!",(unsigned long (*)()) bang)
&& native("pry",(unsigned long (*)()) pry)
&& native("w@",(unsigned long (*)()) pry)
&& native("poke",(unsigned long (*)()) poke)
&& native("w!",(unsigned long (*)()) poke)
&& native("bump",(unsigned long (*)()) bump)
&& native("incr",(unsigned long (*)()) bump)
&& native("goose",(unsigned long (*)()) goose)
&& native("cram",(unsigned long (*)()) cram)
&& native("inflate",(unsigned long (*)()) inflate)
&& native("shuffle",(unsigned long (*)()) shuffle)
&& native("storec",(unsigned long (*)()) cram)
&& native("ram",(unsigned long (*)()) ram)
&& native("storer",(unsigned long (*)()) ram)
&& native("place",(unsigned long (*)()) place)
&& native("place1",(unsigned long (*)()) place1)
&& native("placevec",(unsigned long (*)()) placevec)
&& native("fetch",(unsigned long (*)()) fetch)
&& native("fetchif",(unsigned long (*)()) fetchif)
&& native("pluck",(unsigned long (*)()) fetch)
&& native("store",(unsigned long (*)()) store)
&& native("stuff",(unsigned long (*)()) store)
&& native("stick",(unsigned long (*)()) store)
&& native("move",(unsigned long (*)()) move1)
&& native("movec",(unsigned long (*)()) movec)
&& native("byte",(unsigned long (*)()) byte)
&& native("byte!",(unsigned long (*)()) bytestore)
&& native("implant1",(unsigned long (*)()) implant1)
&& native("implant",(unsigned long (*)()) implant)

&& native("global",(unsigned long (*)()) global)
&& native("bank",(unsigned long (*)()) implant)
&& native("yank",(unsigned long (*)()) extract)
&& native("extract",(unsigned long (*)()) extract)
&& native("localpry",(unsigned long (*)()) extract)
&& native("localrun",(unsigned long (*)()) extract)
&& native("localref",(unsigned long (*)()) localref)

&& native("totals",(unsigned long (*)()) totals)
&& native("down",(unsigned long (*)()) totals)
&& native("bins",(unsigned long (*)()) bins)
&& native("intervals",(unsigned long (*)()) intervals)

&& native("notrailing",(unsigned long (*)()) notrailing)
&& native("blpad",(unsigned long (*)()) blpad)
&& native("noblanklines",(unsigned long (*)()) noblanklines)
&& native("-blanklines",(unsigned long (*)()) noblanklines)
&& native("chop",(unsigned long (*)()) chop)
&& native("strchop",(unsigned long (*)()) strchop)
&& native("-path",(unsigned long (*)()) rmpath)
&& native("quoted",(unsigned long (*)()) quoted1)
&& native("unquoted",(unsigned long (*)()) unquoted)
&& native("cat",(unsigned long (*)()) cat)
&& native("butt",(unsigned long (*)()) cat)
&& native("catn",(unsigned long (*)()) parkn)
&& native("cats",(unsigned long (*)()) cats)
&& native("catpath",(unsigned long (*)()) catpath)
&& native("pathcat",(unsigned long (*)()) catpath)
&& native("noq_alike",(unsigned long (*)()) noq_alike)
&& native("noq_alike1",(unsigned long (*)()) noq_alike1)
&& native("replace$",(unsigned long (*)()) replace_str)
&& native("strplace",(unsigned long (*)()) strplace)
&& native("strp",(unsigned long (*)()) strp)
&& native("strrpl",(unsigned long (*)()) strp)
&& native("dotpair",(unsigned long (*)()) dotpair)

&& native("park",(unsigned long (*)()) park)
&& native("parkn",(unsigned long (*)()) parkn)
&& native("catch",(unsigned long (*)()) catch)
&& native("character",(unsigned long (*)()) character)
&& native("crop",(unsigned long (*)()) crop)
&& native("claw",(unsigned long (*)()) claw)
&& native("comb",(unsigned long (*)()) claw)
&& native("cull",(unsigned long (*)()) claw)
&& native("mesh",(unsigned long (*)()) mesh)
&& native("clone",(unsigned long (*)()) clone)
&& native("fold",(unsigned long (*)()) fold)
&& native("foldr",(unsigned long (*)()) foldr)
&& native("trilp",(unsigned long (*)()) trilp)
&& native("triup",(unsigned long (*)()) triup)
&& native("sym_unpack",(unsigned long (*)()) sym_unpack)
&& native("gram-schmidt",(unsigned long (*)()) gram_schmidt)

&& native("pile",(unsigned long (*)()) pile)
&& native("pilen",(unsigned long (*)()) pilen)
&& native("reach",(unsigned long (*)()) reach)
&& native("rake",(unsigned long (*)()) rake)
&& native("rip",(unsigned long (*)()) rake)
&& native("tier",(unsigned long (*)()) tier)
&& native("repeat",(unsigned long (*)()) repeat1)
&& native("pileof",(unsigned long (*)()) pileof)
&& native("matrix",(unsigned long (*)()) matrix)

&& native("items",(unsigned long (*)()) items)
&& native(":=",(unsigned long (*)()) items)
&& native("thrulist",(unsigned long (*)()) thrulist)
&& native(":",(unsigned long (*)()) thrulist)
&& native("reversed",(unsigned long (*)()) reversed)
&& native("bend",(unsigned long (*)()) bend)
&& native("twist",(unsigned long (*)()) bend)
&& native("transpose",(unsigned long (*)()) bend)
&& native("chain",(unsigned long (*)()) chain)
&& native("chainr",(unsigned long (*)()) chainr)
&& native("sling",(unsigned long (*)()) sling)
&& native("sling1",(unsigned long (*)()) sling1)

&& native("indent",(unsigned long (*)()) indent)
&& native("justify",(unsigned long (*)()) justify)
&& native("neat",(unsigned long (*)()) neat)
&& native("asciify",(unsigned long (*)()) asciify)
&& native("html2text",(unsigned long (*)()) html2text)

&& native("hand",(unsigned long (*)()) hand)
&& native("hen",(unsigned long (*)()) hand)
&& native("naming",(unsigned long (*)()) naming)
&& native("named",(unsigned long (*)()) named)
&& native("number",(unsigned long (*)()) qnumber)
&& native("hexbytes",(unsigned long (*)()) hexbytes)
&& native("hexuint",(unsigned long (*)()) qhexuint)
&& native("num2mat",(unsigned long (*)()) typnum2mat)
&& native("str2mat",(unsigned long (*)()) typstr2mat)
&& native("str2num",(unsigned long (*)()) typstr2num)
&& native("str2vol",(unsigned long (*)()) typstr2vol)
&& native("num2str",(unsigned long (*)()) typnum2str)
&& native("mat2vol",(unsigned long (*)()) typmat2vol)
&& native("vol2mat",(unsigned long (*)()) typvol2mat)
&& native("vol2str",(unsigned long (*)()) typvol2str)
&& native("textput",(unsigned long (*)()) textput)
&& native("join",(unsigned long (*)()) textput)
&& native("WIDTH",(unsigned long (*)()) textwidth)

&& native(".",(unsigned long (*)()) dot)
&& native("dot",(unsigned long (*)()) dot)
&& native("dotstr",(unsigned long (*)()) dotstr)
&& native(".i",(unsigned long (*)()) dotint)
&& native(".u",(unsigned long (*)()) dotuint)
&& native(".hex",(unsigned long (*)()) dothex)
&& native(".bin",(unsigned long (*)()) dotbin)
&& native("tout",(unsigned long (*)()) tout)
&& native("reprint",(unsigned long (*)()) dotreprint)
&& native("echo",(unsigned long (*)()) echo1)
&& native("emit",(unsigned long (*)()) emit)

&& native("format",(unsigned long (*)()) format)
&& native("printf",(unsigned long (*)()) printf1)
&& native("intstr",(unsigned long (*)()) intstr)
&& native("_int$",(unsigned long (*)()) intstr)

&& native("cr",(unsigned long (*)()) cr)
&& native("lf",(unsigned long (*)()) lf)
&& native("nl",(unsigned long (*)()) nc)
&& native("out",(unsigned long (*)()) out)
&& native("sp",(unsigned long (*)()) sp)

&& native("bsearch",(unsigned long (*)()) bsearch1)
&& native("searching",(unsigned long (*)()) searching)
&& native("lerp",(unsigned long (*)()) lerp2)
&& native("lext",(unsigned long (*)()) lext)
&& native("look",(unsigned long (*)()) look)
&& native("closest",(unsigned long (*)()) closest)
&& native("nrcrv",(unsigned long (*)()) nrcrv)
&& native("looking",(unsigned long (*)()) looking)
&& native("looking1",(unsigned long (*)()) looking1)
&& native("find",(unsigned long (*)()) find)
&& native("sort",(unsigned long (*)()) sort1)
&& native("sorton",(unsigned long (*)()) sorton)
&& native("nodupes",(unsigned long (*)()) nodupes)
&& native("nodupes1",(unsigned long (*)()) nodupes1)
&& native("skyline",(unsigned long (*)()) skyline)

&& native("inclusive",(unsigned long (*)()) inclusive)
&& native("limited",(unsigned long (*)()) limited)
&& native("within",(unsigned long (*)()) within)
&& native("thereat",(unsigned long (*)()) thereat)

&& native("ercnt",(unsigned long (*)()) ercnt)
&& native("funtest",(unsigned long (*)()) funtest)

&& native("flush_sysout",(unsigned long (*)()) flush_sysout)
&& native("set_keyout",(unsigned long (*)()) set_keyout)
&& native("set_stderr",(unsigned long (*)()) set_stderr)
&& native("set_stdout",(unsigned long (*)()) set_stdout)
&& native("set_sysout",(unsigned long (*)()) set_sysout)
&& native("SYSOUT",(unsigned long (*)()) sysout1)
&& native("_syspath",(unsigned long (*)()) _syspath)
&& native("SBIN_set",(unsigned long (*)()) set_sbin)
&& native("SBIN",(unsigned long (*)()) sbin)
&& native("SH_set",(unsigned long (*)()) set_sh)
&& native("SH",(unsigned long (*)()) sh1)

/*--------------------------------------------------------------------*/

/* Heritage */
&& native("-trailing",(unsigned long (*)()) notrailing)
&& native("+trailing",(unsigned long (*)()) blpad)
&& native(">square",(unsigned long (*)()) sq1)
&& native("to_square",(unsigned long (*)()) sq1)
&& native(">vector",(unsigned long (*)()) tovector)
&& native("to_vector",(unsigned long (*)()) tovector)
&& native("stardiag",(unsigned long (*)()) mpydg)

/* Matching words in express: */
&& native("/element",(unsigned long (*)()) slashby)
&& native("*element",(unsigned long (*)()) starby)
&& native("/factor",(unsigned long (*)()) slashf)
&& native("*factor",(unsigned long (*)()) starf)
&& native("+offset",(unsigned long (*)()) plusd)
&& native(">text",(unsigned long (*)()) totext)

/*--------------------------------------------------------------------*/

/* Constants that must match the following enumeration of stack item
   types (word type):
      enum stktyp {DEF=1,NUM,MAT,STR,VOL,PTR};
   defined in stk.h: */
&& constant("NUM","2")
&& constant("MAT","3")
&& constant("STR","4")
&& constant("VOL","5")
&& constant("PTR","6")

/*--------------------------------------------------------------------*/

/* Constants that must match the following enumeration of catalog item
   types (word ctype):
      enum cattyp {UNK=0,NATI,DEFN,CONS,VARI,MATR,STRI,VOLU,INLI}; */
&& constant( "UNK","0")
&& constant("NATI","1")
&& constant("DEFN","2")
&& constant("CONS","3")
&& constant("VARI","4")
&& constant("MATR","5")
&& constant("STRI","6")
&& constant("VOLU","7")
&& constant("INLI","8")

/*--------------------------------------------------------------------*/

/* Begin inline and runtime functions */

&& native("define:,",(unsigned long (*)()) _DEF)
&& native("wexe,",(unsigned long (*)()) wexe)

&& native("extern",(unsigned long (*)()) extern1)
&& native("extern,",(unsigned long (*)(unsigned long *c)) _EXTERN)

&& native("list:,",(unsigned long (*)(unsigned long *c)) _LIST)
&& native("vector:,",(unsigned long (*)(unsigned long *c)) _LIST)
&& native("list:,,",(unsigned long (*)()) _list)

&& native("return,",(unsigned long (*)(unsigned long *c)) _ENDP)
&& native("endp,,",(unsigned long (*)()) _endp)

&& native("end,",(unsigned long (*)(unsigned long *c)) _END1P)
&& native(";,",(unsigned long (*)(unsigned long *c)) _END1P)
&& native("end1p,,",(unsigned long (*)()) _end1p)

&& native("',",(unsigned long (*)(unsigned long *c)) _UQUOTE)
&& native("\",",(unsigned long (*)(unsigned long *c)) _UQUOTE)

&& native("Jz,",(unsigned long (*)()) _Jz)
&& native("Jmp,",(unsigned long (*)()) _Jmp)
&& native("DO,",(unsigned long (*)(unsigned long *c)) _DO)
&& native("DO,,",(unsigned long (*)()) _do)
&& native("?DO,",(unsigned long (*)(unsigned long *c)) _DOq)
&& native("?DO,,",(unsigned long (*)()) _doq)
&& native("LOOP,",(unsigned long (*)(unsigned long *c)) _LOOP)
&& native("LOOP,,",(unsigned long (*)()) _loop)
&& native("+LOOP,",(unsigned long (*)(unsigned long *c)) _LOOPp)
&& native("LOOPP,,",(unsigned long (*)()) _loopp)
&& native("I,",(unsigned long (*)(unsigned long *c)) _I)
&& native("I,,",(unsigned long (*)()) _i)
&& native("J,",(unsigned long (*)(unsigned long *c)) _J)
&& native("J,,",(unsigned long (*)()) _j)
/*
&& native("K,",(unsigned long (*)(unsigned long *c)) _K)
&& native("K,,",(unsigned long (*)()) _k)
*/
&& native("EXIT,",(unsigned long (*)(unsigned long *c)) _EXIT)
&& native("exit1,",(unsigned long (*)()) _exit1)

&& native("IF,",(unsigned long (*)(unsigned long *c)) _IF)
&& native("ELSE,",(unsigned long (*)(unsigned long *c)) _ELSE)
&& native("THEN,",(unsigned long (*)(unsigned long *c)) _THEN)

&& native("BEGIN,",(unsigned long (*)(unsigned long *c)) _BEGIN)
&& native("WHILE,",(unsigned long (*)(unsigned long *c)) _WHILE)
&& native("REPEAT,",(unsigned long (*)(unsigned long *c)) _REPEAT)
&& native("UNTIL,", (unsigned long (*)(unsigned long *c)) _UNTIL)

&& native("book,",(unsigned long (*)(unsigned long *c)) _BOOK)
&& native("book*,",(unsigned long (*)(unsigned long *c)) _BOOK)

&& native("feed,",(unsigned long (*)(unsigned long *c)) _FEED)

&& native("[,",(unsigned long (*)()) _BRAK)

&& native("into,",(unsigned long (*)(unsigned long *c)) _INTO)
&& native("is,",(unsigned long (*)(unsigned long *c)) _INTO)
&& native("makes,",(unsigned long (*)(unsigned long *c)) _INTO)
&& native("onto,",(unsigned long (*)(unsigned long *c)) _INTO)
&& native("says,",(unsigned long (*)(unsigned long *c)) _INTO)
&& native("are,",(unsigned long (*)(unsigned long *c)) _INTO)

&& native("pull,",(unsigned long (*)(unsigned long *c)) _PULL)
&& native("push,",(unsigned long (*)(unsigned long *c)) _PUSH)

/* End inline and runtime functions */

/* Used at start up in boot.v: */
&& native("boot",(unsigned long (*)()) boot)

/* Begin words that are not suitable for inline functions */
&& native("done,",(unsigned long (*)()) _NOINLINE)
/* End words that are not suitable for inline functions */

/*--------------------------------------------------------------------*/

/* Begin synonyms for words used in parser functions PRE__, RET__ and 
   ret__ that avoid conflict with native words that may be used in 
   another context within a function.  With * appended, these are 
   symbols that would not be valid names in the function body: */

&& native("bank*",(unsigned long (*)()) implant2)
&& native("book*",(unsigned long (*)()) book1) /* also book*, above */
&& native("drop*",(unsigned long (*)()) drop)
&& native("dup*",(unsigned long (*)()) dup1s)
&& native("pile*",(unsigned long (*)()) pile)
&& native("pilen*",(unsigned long (*)()) pilen)
&& native("return2*",(unsigned long (*)()) return2)
&& native("tpurged*",(unsigned long (*)()) tpurged)
&& native("type*",(unsigned long (*)()) type1)
&& native("yank*",(unsigned long (*)()) extract)

/*--------------------------------------------------------------------*/

/* end word.p */






















