/* {{{1 GNU General Public License

Program Tops - a stack-based computing environment
Copyright (C) 1999-2005  Dale R. Williamson

Author: Dale R. Williamson <dale.williamson@prodigy.net>

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software Foundation,
Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
1}}} */

/* sys.h  April 1999

Copyright (c) 1999  D. R. Williamson
*/

int DELTA_T; /* "true" GMT minus the machine's GMT (sec) */

enum {cLIN,cCOL}; /* options for cursinfo() */

int abort1(); /* abort (n --- ) */
int accept1(); /* accept ( --- false or qA true) */
int argv(); /* argv (qName --- qVal) */
int ascii(); /* ascii ( --- ) */
int base0(); /* 0based ( --- ) */
int base1(); /* 1based ( --- ) */
int beep1(); /* beep ( --- ) */
int binary(); /* binary ( --- ) */
char *binif(double opt);
int boot(); /* boot (... opt --- ) */
int bye(); /* bye ( --- ) */
int catmsg(); /* catmsg (f --- ) */
int catmsgflag(); /* CATMSG ( --- f) */
int catpath(); /* catpath (qPath qFile --- qPath/File) */
int chdir1(); /* chdir (qS --- ) */
int chmodf(); /* chmod (qFile Mode --- ) */
int chperm(); /* chperm ( --- ) */
int ctime1(); /* ctime (hA --- hT) */
int datesys(); /* date ( --- qS) */
int datesys1(); /* date1 ( --- qS) */
int datesys2(); /* date2 ( --- qS) */
char *datetime();
int delete(); /* delete (qS --- ) */
int env(); /* (qS --- qS1) */
int ercnt(); /* ercnt ( --- k) */
int ertrip(); /* ertrip (n --- ) */
/* 
Function exit() in sys.c uses prototype from /usr/include/stdlib.h
void exit(int code); 
*/
int extract1(char *libname, char *wordname); /* (... --- ...) */
int flush_sysout(); /* flush_sysout ( --- ) */
int getenv1(); /* getenv ( --- qEnv) */
int getlogin1(); /* getlogin ( --- qS) */
int getpid1(); /* getpid ( --- n) */
int getpwd(); /* pwd ( --- qS) */
int getuid1(); /* getuid ( --- n) */
int GMTdelta(); /* GMTdelta (n --- ) */
int gmtime1(); /* gmtime (hA --- hT) */
int hide(int opt);
int hideoff(); /* nohide ( --- ) */
int hideon(); /* hide ( --- ) */
int hlmax(); /* HLMAX (L --- ) */
int hostname(); /* _host ( --- qS) */
int implant1(); /* implant1 (d qW qA --- ) */
int infix(); /* >> ( --- ) */
int infixflag(); /* INFIX ( --- f) or INFIX; ( --- f) */
int infix_set(); /* infix_set (f --- ) */
int keyq(); /* keys? ( --- f) */
int mktime1(); /* ltime (YYYDDMM HHMMSS --- n) */
int ndx(); /* ndx (n --- n1) */
int new(); /* new ( --- ) */
void nl_prompt();
int nullshell(); /* nullshell (hT --- ) */
int old(); /* old ( --- ) */
int os(); /* os ( --- qS) */
int os_ver(); /* os_ver ( --- qS) */
int postfix(); /* << ( --- ) */
int proghello(); /* proghello ( --- ) */
int public(); /* public ( --- ) */
int publicoff(); /* -public ( --- ) */
int putenv1(); /* putenv (qS --- ) */
int qdx(); /* qdx (n --- q) */
int sbin(); /* SBIN ( --- qS) */
int set_keyout(); /* set_keyout ( --- ) */
int set_sbin(); /* SBIN_set (qS --- ) */
int set_sh(); /* SH_set (qS --- ) */
int set_stderr(); /* set_stderr ( --- ) */
int set_stdout(); /* set_stdout ( --- ) */
int set_sysout(); /* set_sysout (qFile --- ) */
int setargs(int argc, char *argv[]);
int setenv1(); /* setenv1 (qName qValue --- ) */
int setxbase(); /* indexbase (0 or 1 --- ) */
int sh1(); /* SH ( --- qS) */
int shell(); /* shell (hT --- ), system (hT --- ) */
int shellget(); /* shellget ( --- hT) */
int shellset(); /* shellset (hT --- ) */
int stkbal(); /* stkbal ( --- ) */
int stkbaloff(); /* -stkbal ( --- ) */
int strict(); /* strict ( --- ) */
int strictoff(); /* -strict ( --- ) */
int stty1();
int sysout1(); /* SYSOUT ( --- qFile) */
int _syspath(); /* _syspath ( --- qS) */
int system_env(char *command, char **environ);
/*
int system_env(const char *command,  char *const environ[]);
*/
double timed();
int timeprobe(); /* timprobe ( --- ) */
void timeprobe1(int k);
int timesys(); /* time ( --- s) */
int timesys1(); /* time1 ( --- s) */
int trace1(); /* trace ( --- ) */
int traceflag(); /* TRACE ( --- f) */
int traceoff1(); /* -trace ( --- ) */
int type1(); /* type (hA --- n) */
void unload(char *clean);
int xbase(); /* xbase ( --- 0 or 1) */
int xbase1(); /* 2nd ( --- 1 or 2) */
int xbase2(); /* 3rd ( --- 2 or 3) */
int xbase3(); /* 4th ( --- 3 or 4) */

/* end sys.h headers */
