/* {{{1 GNU General Public License

Program Tops - a stack-based computing environment
Copyright (C) 1999-2005  Dale R. Williamson

Author: Dale R. Williamson <dale.williamson@prodigy.net>

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software Foundation,
Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
}}}1 */
/* 
   spsolve.h
   Albert Danial
 */
int  spsolve();     /* spsolve     (hB hA_sp  --- hX)        */
int  splu();        /* splu        (hA_sp     --- hP hLU_sp) */
int  spfbs();       /* spfbs       (hB hLU_sp --- hX)        */

#define SUPERLU_MAGIC_0 774112367
#define SUPERLU_MAGIC_1 132083635
#define SUPERLU_MAGIC_2 412104016
#define SUPERLU_MAGIC_3 500299478

typedef struct {
    int     *magic          ;

    int     *U_Head         ; 
    double  *U_N            ; 
    int     *U_rowind       ; 
    int     *U_colptr       ; 

    int     *L_Head         ; 
    double  *L_N            ; 
    int     *L_nzval_colptr ; 
    int     *L_rowind       ; 
    int     *L_rowind_colptr; 
    int     *L_col_to_sup   ; 
    int     *L_sup_to_col   ; 

    char    *data           ;         /* main data block         */
} tops_SuperLU;

int  umfpack_numeric_to_tos   (void *  NumericHandle, SparseMatrix A);
int  umfpack_numeric_from_tos (void ** NumericHandle );
