/* {{{1 GNU General Public License

Program Tops - a stack-based computing environment
Copyright (C) 1999-2005  Dale R. Williamson

Author: Dale R. Williamson <dale.williamson@prodigy.net>

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software Foundation,
Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
1}}} */

/* main.h  March 1999

Copyright (c) 1999  D. R. Williamson

   Where this file appears as #include "main.h", place it highest, 
   above all other, quoted, header files for this program.

   Throughout this program, the returned int from a function is
   generally 1 (true) if ok, and 0 (false) if not.
*/

/* The environment when the program was started: */
extern char **environ;
#define PROGENV environ 
   
/* Other environments: */
char **SHELLENV; /* environment for system shell commands */
char **NULLENV;  /* null environment */

#define ABS(x) ( (x)<0 ? -(x) : (x) )
int BIN;
int BYE; /* Esc-q to exit keyboard input */
int CATMSG; /* msg when word into catalog or is redefined */
#define DEFNC 255 /* maximum characters in each word pattern */
int DONEOFF; 
int errTHRESHOLD; /* errors that will trip runaway error monitor */
int HLMAX; /* max lines in keyboard history buffer */
double INF; /* IEEE Inf */
int INFIX; /* 1 when inputting infix expressions */
int KEYS; /* 1 for keyboard input mode, 0 otherwise */
int kHIT; /* number of keys hit since start up */
int LOCKED;
int LOGKEEP;
#define MAX(a,b) ( ((a) > (b)) ? (a) : (b) )
#define MIN(a,b) ( ((a) < (b)) ? (a) : (b) )    
int NEW;
#define NBUF 128 /* maximum number of run levels */
#define NDBUF NBUF /* maximum loop nesting levels */
int OK_EXIT;
int PUBLIC; /* when xTRUE, local library of words is the main library */
#define RANDOM_MAX 0x7fffffff /* 2,147,483,647 */
char *SAY;
char *SBIN;
char *SH;
int SIGNBIT;
int STKBAL;
int STRICT;
char *SYSCRCH;
char *SYSOUT;
FILE *sysout;
char *SYSPATH;
int TRACE;
int TVSEC;
int TVUSEC;
int USEC;
int WIDTH; /* text width in textget() */
int XBASE; /* index base, 0 or 1 */
#define xFALSE 0 /* value of false flag on stack (all int bits 0) */
#define xTRUE -1 /* value of true flag on stack (all int bits 1) */

/* Headers for functions in main.c: */
int main(int argc, char *argv[]);
void perform();
int quit(); /* exit, quit ( --- ) */
int source(); /* source (qFile --- ) */
int start(int argc, char *argv[]);

/* end main.h headers */
