/* {{{1 GNU General Public License

Program Tops - a stack-based computing environment
Copyright (C) 1999-2005  Dale R. Williamson

Author: Dale R. Williamson <dale.williamson@prodigy.net>

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software Foundation,
Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
1}}} */

/* lapack.h

   D. R. Williamson  November 3, 2001

   Words that run LAPACK subroutines.

*/

#ifdef FORT_UDSC
#define DAXPY  daxpy_
#define DCOPY  dcopy_
#define DDOT   ddot_
#define DGEEV  dgeev_
#define DGEMM  dgemm_
#define DGESV  dgesv_
#define DGETRI dgetri_
#define DGETRF dgetrf_
#define DGETRS dgetrs_
#define DGTTRF dgttrf_
#define DGTTRS dgttrs_
#define DNRM2  dnrm2_
#define DPOTRF dpotrf_
#define DSCAL  dscal_
#define DSYGV  dsygv_
#define ILAENV ilaenv_
#define ZDSCAL zdscal_
#define ZGEMM  zgemm_
#define ZGESV  zgesv_
#define ZGGEV  zggev_
#else
#define DAXPY  daxpy
#define DCOPY  dcopy
#define DDOT   ddot
#define DGEEV  dgeev
#define DGEMM  dgemm
#define DGESV  dgesv
#define DGETRI dgetri
#define DGETRF dgetrf
#define DGETRS dgetrs
#define DGTTRF dgttrf
#define DGTTRS dgttrs
#define DNRM2  dnrm2
#define DPOTRF dpotrf 
#define DSCAL  dscal
#define DSYGV  dsygv
#define ILAENV ilaenv
#define ZDSCAL zdscal
#define ZGEMM  zgemm
#define ZGESV  zgesv
#define ZGGEV  zggev
#endif

void   DGTTRF ();
void   DGTTRS ();
void   DAXPY  ();
void   DSCAL  ();
double DNRM2  ();
 
#define dcmplx double

void DCOPY(int *rows, double *A, int *ra, double *B,  int *rb);
void DGEEV(char *chr_N, char *chr_V, int *rows, double *C, int *Crows, 
      double *Lr, double *Li, double *dummy, int *int_1,
      double *lapack_eigvec, int *Arows, double *Aux, int *Aux_size, 
      int *info);
int dgeev1(); /* dgeev (hC --- hLr hLi hAr hAi) */
int dgeev2(); /* dgeev2 (hC --- hWr hWi hLr hLi hRr hRi) */

void DGEMM(char *transa, char *transb, int *m, int *n, int *k,
   double *alpha, double *A, int *lda, double *B, int *ldb, 
   double *beta, double *C, int *ldc);
int dgemm1(); /* dgemm (hA hB hC qA' qB' alpha beta --- hC) */

void DGESV(int *n, int *nrhs, double *A, int *lda, int *IPIV, 
   double *B, int *ldb, int *info);
int dgesv1(); /* dgesv (hb hA --- hx) */

void DGETRI(int *N, double *A, int *LDA, int *IPIV, double *WORK, 
            int *LWORK, int *INFO );
int dgetri1(); /* dgetri (hA --- hinvA ) */

void DGETRF(int *M, int *N, double *A, int *LDA, int *IPIV, int *INFO);
int dgetrf1(); /* dgetrf (hA --- hLU hP ) */

void DGETRS(char *TRANS, int *N, int *NRHS, double *A, int *LDA, 
            int *IPIV, double *B, int *LDB, int *INFO );
int dgetrs1(); /* dgetrs (hLU hP hB --- hX ) */

void DPOTRF(char *UPLO, int *N, double *A, int*LDA , int *INFO);
int dpotrf1(); /* dpotrf (A --- L) */

void DSCAL(int *rows, double *S, double *A, int *i);

void DSYGV(int *itype, char *jobz, char *uplo, int *n, double *A,
   int *lda, double *B, int *ldb, double *w, double *work, int *lwork, 
   int *info);
int dsygv1(); /* dsygv (hM hK --- hZ hw) */

void ZDSCAL(int *len, double *x, dcmplx *C, int *inc);
int zdscal1(); /* zdscal (hVr hVi x --- hWr hWi) */

void ZGEMM(char *transa, char *transb, int *m, int *n, int *k,
   double *alpha, double *A, int *lda, double *B, int *ldb, 
   double *beta, double *C, int *ldc);
int zgemm1(); /* zgemm (hA trnA alpha hB trnB hC beta --- hD) */

void ZGESV(int *n, int *nrhs, dcmplx *A, int *lda,
           int *IPIV, dcmplx *B, int *ldb, int *info);
int zgesv1(); /* zgesv (hBr hBi hAr hAi --- hXr hXi) */

void ZGGEV(char *JOBVL, char *JOBVR, int *N, dcmplx *A, int *LDA, 
           dcmplx *B, int *LDB, dcmplx *ALPHA, dcmplx *BETA,
           dcmplx *VL, int *LDVL, dcmplx *VR, int *LDVR, dcmplx *WORK, 
           int *LWORK, dcmplx *RWORK, int *info );
int zggev1(); /* zggev (hA hB --- hAlpha hBeta hVL hVR ) */

/* end lapack.h headers */
