/* {{{1 GNU General Public License

Program Tops - a stack-based computing environment
Copyright (C) 1999-2005  Dale R. Williamson

Author: Dale R. Williamson <dale.williamson@prodigy.net>

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software Foundation,
Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
1}}} */

/* key.h  June 1999

Copyright (c) 1999  D. R. Williamson


   Command line editing at the ready prompt.

   Key entry and line editing implemented in function keys() includes
   this subset of Unix vi-style command line editing commands for the
   following keys:

       A - begins appending after the end of the line
       a - begins appending after the cursor
       Backspace - in text and insert modes, moves left and deletes
       Backspace - in command mode, moves cursor left, no deletion
       D - deletes the cursor character and all to its right
       Enter - stops editing the line and exits command or insert mode
       Esc - from text mode, begins command line cursor mode
       Esc - from insert mode, jumps back to command line cursor mode
       h - moves cursor to the left
       i - begins inserting in front (left) of the cursor
       j - scrolls to later lines in history of keyed input
       k - scrolls to earlier lines in history of keyed input
       l - moves cursor to the right
       p - puts last deleted character after the cursor
       q - quits current run level (not in Unix; this program only)
       r - replaces the character at the cursor with the next keyed
       s - deletes character at cursor and begins inserting
       Space - in command mode, moves cursor right
       x - deletes the character at the cursor

--------------------------------------------------------------------- */

/* Key codes for editing: */
#define AFT 0x41  /* letter A key */
#define AFT1 301  /* key map id (used in amap()) */
#define APP 0x61  /* kmode 2 and letter a key */
#define BKS 0x8   /* backspace key */
#define BKS1 0x7F /* DEL */
#define CR 0xD    /* carriage return */
#define DEL 0x78  /* letter x key */
#define DIN 0x73  /* letter s key */
#define DN 0x6A   /* letter j key */
#define DN1 0x2B  /* char + key */
#define DC 0x44   /* letter D key */
#define ESC 0x1B  /* kmode 1 and esc key */
#define FF 0xC    /* form feed */
#define INS 0x69  /* kmode 2 and letter i key */
#define LF 0xA    /* line feed */
#define LT 0x48   /* letter h key */
#define LT1 0x68  /* letter H key */
#define NL 0xA    /* Enter key */
#define PUT 0x70  /* letter p key */
#define QT  0x71  /* letter q key */
#define REP 0x72  /* letter r key */
#define RT 0x6C   /* letter l key */
#define RT1 0x4C  /* letter L key */
#define SB 0x20   /* space bar */
#define TEX 0     /* kmode 0 */
#define UP 0x6B   /* letter k key */
#define UP1 0x2D  /* char - key */
#define TAB 0x9   /* tab key */

/* Name of the character file in the /dev directory, used by shell(): */
char *TTY1; 

/* Cases of setup in hset() and keywin(): */
enum {kBEG,kEND,kZRO}; 

int ESCq; /* flag from function accept_keys */
int INDENT; /* leftmost cursor location */
int KEY_IN; /* key from key_in() */

int accept_keys(); /* accept_keys (qPrompt --- false or qS true) */
int amap(int ch);
int curscol(); /* COLS ( --- n) */
int cursinfo(int opt);
int curslin(); /* LINES ( --- n) */
int ESCq1(); /* ESCq ( --- f) */
int getchk(); /* getch ( --- n) */
int getcht(); /* getcht ( --- n t) */
int getkeys(); /* getkeys ( --- qS) */
void hset(int opt, int level);
void kback();
int KBtoggle(); /* KBtoggle ( --- ) */
void kdel();
int key();
int keyboard(); /* keyboard ( --- ) */
int keyignore(); /* keyignore (n --- ) */
char *keying();
int keys(int c);
int key_in(); /* key_in (qS --- ) */
int keysoff();
int keywin(int opt);
char *khis(int opt, char *newlin, int linlen, int *lin, int *width);
int khit(); /* khit ( --- n) */
void khscrol(int opt);
int khpush(); /* history ( --- hT) */
void kins(int c);
int koff(); /* koff ( --- ) */
int kon(); /* kon ( --- ) */
void krep(int c);
void kset(int opt);
int ktime(); /* ktime ( --- s) */
int newch(int c);
int RLKEY;  /* run level (onbuf) of keyed input (info from kset()) */
int story(); /* story (n --- hT) or (0 --- ) */
void tabfill(char *keyed);
int tty(); /* tty ( --- qS) */
int typing(); /* typing ( --- qS) */

/* end key.h headers */
