#!../../../src/tops -i
#
#   ./sol103.n -f x2y2.db

mformatset("%22.16e");

model_db = argv("-f");
(Mg, Kg) = fea_assemble(model_db, 0, 0);
Kgg      = spflip_sym(Kg);

    /* find first eigensolution on unconstrained (g-set) matrix */
    shift  = 10000.0;
    nModes = 10;
    (eVal, eVec, nBelow) = speig_near_shift(Kgg, Mg, shift, nModes);
    (max_err,col,row)    = maxfetch(abs(Kgg*eVec - diagpost(Mg*eVec, eVal) ) );
    dot("G-Set eigensolution:"); nl
    dot("ERROR                       = ")
    max_err .  nl ;
    dot("SHIFT                       = ")
    shift   .  nl ;
    dot("NUMBER OF MODES BELOW SHIFT = ")
    nBelow  .i nl ;
    dot("EIGENVALUES                 = "); nl
    eVal .m nl ;


/* apply SPC's */
Ind_x_set  = apply_spc(model_db, 0, 0);
Kxx        = spflip_sym(submat(Kg, Ind_x_set, Ind_x_set));
Mxx        = spflip_sym(submat(Mg, Ind_x_set, Ind_x_set));

    /* find second eigensolution on constrained matrix */
    shift  = 100.0;
    nModes = 10;
    (eVal, eVec, nBelow) = speig_near_shift(Kxx, Mxx, shift, nModes);
    (max_err,col,row)    = maxfetch(abs(Kxx*eVec - diagpost(Mxx*eVec, eVal) ) );
    dot("X-Set eigensolution:"); nl
    dot("ERROR                       = ")
    max_err .  nl ;
    dot("SHIFT                       = ")
    shift   .  nl ;
    dot("NUMBER OF MODES BELOW SHIFT = ")
    nBelow  .i nl ;
    dot("EIGENVALUES                 = "); nl
    eVal .m nl ;

