/* {{{1 GNU General Public License

sofea - the Stack Operated Finite Element Analysis program
Copyright (C) 2004  Al Danial <al.danial@gmail.com>

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software Foundation,
Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
}}}1 */
#include <stdio.h>
#include <stk.h>
#include <main.h>
#include <sql.h>
#include "fea_assemble.h"

int se_global_dof()      /* ( qParnDB part_id --- hIdx ) {{{1 */
/*
 * man entry:  se_global_dof {{{2
 * ( qParnDB part_id --- hIdx ) Return an integer array containing the global degrees of freedom corresponding to the given superelement (or partition) in the sequence used to its Kgg, Mgg.
 * category: FEA
 * related: fea_assemble, element_matrix 
 * 2}}}
 */
{
int DEBUG = 0;  /* takes values of 1, 2 (print each element's ID) */
    int  partition_number, offset, n_found, n_remain, n_nodes, rc, i, j, dof;
    callback_data sql_data;
    sqlite3 *dbh;
    char query[QUERY_STR_SIZE+1], list_name[SQL_MAX_ID_LEN]; 
    double *dof_list;

if (DEBUG)
gprintf("at top of se_global_dof\n");
    query[0] = '\0';

    if (!popint(&partition_number)) return 0;
    if (partition_number) {  /* requested only a portion of the total model */
        if (!db_open()) {    /* open partition db */
            stkerr(" se_global_dof: ", "failed to open model and partn dbs");
            return 0;
        }
    } else {
        stkerr(" se_global_dof: ", "specify nonzero partition number");
        return 0;
    }
    dbh = (sqlite3 *) tos->tex;

    snprintf(query, QUERY_STR_SIZE, 
             "select count(id) from P%02d_canonical_nid ",
             partition_number);
    n_nodes = sql_scalar_i(dbh, query, "fea_assemble");

    sql_data.row_index = 0;

    snprintf(list_name, SQL_MAX_ID_LEN, "dof_partn_%02d", partition_number);
    if (!matstk(1, DOF_PER_NODE*n_nodes, list_name)) return 0;
    dof_list = tos->mat;

    /* Second query to get the node list.  Gets a list of global renumbered 
     * node ID's which need to be expanded to degrees of freedom.
     */
    n_remain           = 1;
    dof                = 0;
    offset             = 0;
    sql_data.row_index = 0;
    while (n_remain) {
        sql_data.nRows = 0;
        snprintf(query, QUERY_STR_SIZE, 
                 "select nid from P%02d_canonical_nid  CN, "
                                 "P%02d_renumbered_nid RN  "
                 "where CN.id = RN.orig_id order by RN.new_id "
                 "limit %d offset %d;" ,
                 partition_number      ,
                 partition_number      ,
                 SQL_BLOCK_SIZE, offset);

        rc = sql_do_query(dbh, query, &sql_data);
        if ((rc != SQLITE_DONE) && (rc != SQLITE_OK)) {
            fprintf(stderr,"SQL partn_global_dof error: rc=%d %s\n", 
                    rc, sql_data.err_msg);
            stkerr(" partn_global_dof ",STRSNOT);
                                       /* need to define new error type */
            return 0;
        }
        offset  += SQL_BLOCK_SIZE;
        n_found  =  sql_data.nRows;
        n_remain = (n_found == SQL_BLOCK_SIZE ? 1 : 0);
        for (i = 0; i < n_found; i++) {
            for (j = 1; j <= DOF_PER_NODE; j++) {
            /* eg:  node list 1 5 6
             * gives dof list 1 2 3 4 5 6 25 26 27 28 29 30 31 32 33 34 35 36
             */
                dof_list[dof++] = (double) 
                                  (DOF_PER_NODE*(sql_data.i[i][0] - 1) + j);
            }
        }
    }

    pushstr("swap db_close"); xmain(0);  /* close the database */

    return 1;
} /* 1}}} */
