/* {{{1 GNU General Public License

sofea - the Stack Operated Finite Element Analysis program
Copyright (C) 2004  Al Danial <al.danial@gmail.com>

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software Foundation,
Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
}}}1 */
#include <stdio.h>
#include <stk.h>
#include <sqlite3.h>
#include <malloc.h>   /* malloc, free    */
#include <string.h>   /* strncpy */
#include "fea_assemble.h"
#include "sql.h"
#include <tag.h>      /* MAT_ROW_IDX, MAT_COL_IDX */
#include <main.h>     /* XBASE */
#define Tx 0
#define Ty 1
#define Tz 2
#define Rx 3
#define Ry 4
#define Rz 5
#define NUM_LENGTH 20
int print_results() /* ( qModelDB qParnDB part_id type hX --- ) {{{1 */
/*
 * man entry:  print_results {{{2
 * ( qModelDB qParnDB part_id type hX --- ) Prints to STDOUT formatted results for the data in the matrix [X].  'type' is a scalar that identifies the contents of [X]:  1=displacements, 2=strains, 3=stress, 4=velocity, 5=acceleration, 6=grid point forces.  Only type=1 is currently implemented.
 * category: FEA
 * related: fea_assemble, apply_spc
 * 2}}}
 */
{
int DEBUG = 0;
    int     i, j, rc, partition_number, results_type, prev_node, dof_type, 
            index, node_id, X_rows, X_cols, err_cod,
           *X_idx, *unused, *results_seq, *dof_list;
    double *X;
    callback_data sql_data;
    sqlite3 *dbh;
    char query[QUERY_STR_SIZE+1];
    char out_col[6][NUM_LENGTH+1], value[NUM_LENGTH+1];

if (DEBUG) gprintf("at top of print_results\n");
    query[0] = '\0';

    /* open the database, prepare for queries {{{2 */
    pushint(4); roll(); /* ( qModelDB qParnDB part_id type hX --- 
                             qParnDB part_id type hX qModelDB ) */
    pushint(4); roll(); /* ( qModelDB qParnDB part_id type hX --- 
                             part_id type hX qModelDB qParnDB ) */
    pushint(4); roll(); /* ( qModelDB qParnDB part_id type hX --- 
                             type hX qModelDB qParnDB part_id ) */

    if (!popint(&partition_number)) return 0; /* (type hX qModelDB qParnDB) */
    if (partition_number) {  /* requested only a portion of the total model */
        pushstr("DB_PARTN"); /* add to stack alias for partition db */
        if (!db_open2()) {   /* open model db & attach partition db */
            stkerr(" print_results: ", "failed to open model and partn dbs");
            return 0;
        }
    } else {
        drop();             /* ignore whatever is in position of partn DB */
        if (!db_open()) {   /* open model db */
            stkerr(" print_results: ", "failed to open model db");
            return 0;
        }
    }
    dbh = (sqlite3 *) tos->tex;           /* ( type hX dbh ) */
    rot();
    if (!popint(&results_type)) return 0; /* (hX dbh) */
    swap();                               /* (dbh hX) */
    if (!is_indexed(tos)) {
        stkerr(" print_results: ", "X is not internally indexed");
        return 0;
    }
    /* 2}}} */

    X      = tos->mat;
    X_rows = tos->row;
    X_cols = tos->col;
    X_idx  = MAT_ROW_IDX(tos);

    if (partition_number) {
        stkerr(" print_results: ", "not ready for multiple partitions");
        return 0;
    } else {  /* do the whole model */
        snprintf(query, QUERY_STR_SIZE, 
                 "select N.id,D.nid,D.type,D.dof from node N, dof D "
                 "    where D.nid=N.seq_no order by N.id, D.type;");
    }
if (DEBUG) gprintf("print_results query= %s",query);
    sql_data.nRows     = 0;
    sql_data.row_index = 0;
    rc = sql_do_query(dbh, query, &sql_data);  

if (DEBUG) gprintf("print_results rc=%d\n", rc);
    if (rc != SQLITE_OK) {
        stkerr(" print_results: ","failure querying dof");
        stkerr(" query is: ",query);
        return 0;
    }

    gprintf("%35sD I S P L A C E M E N T   V E C T O R", " "); nc(); nc();
    gprintf("%-12s       %-15s%-15s%-15s%-15s%-15s%-15s", 
            "Node ID", "T1", "T2", "T3", "R1", "R2", "R3"); nc();

    if ((unused      = (int *) 
                       malloc(X_rows         * sizeof(int))) == NULL) {
        stkerr(" print_results: ",MEMNOT);
        return 0;
    }
    if ((results_seq = (int *) 
                       malloc(sql_data.nRows * sizeof(int))) == NULL) {
        stkerr(" print_results: ",MEMNOT);
        return 0;
    }
    if ((dof_list    = (int *) 
                       malloc(sql_data.nRows * sizeof(int))) == NULL) {
        stkerr(" print_results: ",MEMNOT);
        return 0;
    }
    for (i = 0; i < sql_data.nRows; i++) {
        /* .i[i][1]=nid, .i[i][2]=type, .i[i][3]=index */
        dof_list[i] = sql_data.i[i][3] + XBASE;
    }
    f_index_align(X_rows        ,  /* in  {X} size */
                  X_idx         ,  /* in  {X}      */
                  sql_data.nRows,  /* in  {Y} size */
                  dof_list      ,  /* in  {Y}      */
                  unused        ,  /* out {x_Map}  */
                  results_seq   ,  /* out {y_Map}  */
                 &err_cod);
    if (err_cod) {
        stkerr(" print_results: "," failed in f_index_align");
        return 0;
    }
if (DEBUG) gprintf("print_results nRows of data=%d\n", sql_data.nRows);
    prev_node = -1;
if (DEBUG) gprintf("print_results a\n");
    for (i = 0; i < sql_data.nRows; i++) {
        node_id  = sql_data.i[i][1];
        dof_type = sql_data.i[i][2];
        index    = sql_data.i[i][3];
if (DEBUG) gprintf("%-12s/%3d dof_type=%d index=%2d ", 
sql_data.a[i][0], node_id, dof_type, index);
if (DEBUG) gprintf("print_results b node_id=%d  prev_node=%d\n", 
node_id,prev_node);
        if (node_id != prev_node) {
if (DEBUG) gprintf("print_results c\n");
            if (prev_node != -1) {
if (DEBUG) gprintf("print_results d\n");
                gprintf("%-12s", sql_data.a[i][0]);
                gprintf(" %-13s  %-13s  %-13s  %-13s  %-13s  %-13s",
                        out_col[Tx],
                        out_col[Ty],
                        out_col[Tz],
                        out_col[Rx],
                        out_col[Ry],
                        out_col[Rz]);
                nc();
            }
            strncpy(out_col[Tx], " 0.0", NUM_LENGTH);
            strncpy(out_col[Ty], " 0.0", NUM_LENGTH);
            strncpy(out_col[Tz], " 0.0", NUM_LENGTH);
            strncpy(out_col[Rx], " 0.0", NUM_LENGTH);
            strncpy(out_col[Ry], " 0.0", NUM_LENGTH);
            strncpy(out_col[Rz], " 0.0", NUM_LENGTH);
            prev_node = node_id;
        }
if (DEBUG) gprintf("print_results e\n");
if (DEBUG) gprintf("  results_seq[%d]=%d\n", i, results_seq[i]);

        if (results_seq[i] < 0) { 
            /* then this dof doesn't appear in the solution */
            strncpy(value, " 0.0", NUM_LENGTH);
        } else {
            if (!X[results_seq[i]]) {  /* computed result is numeric zero */
                strncpy(value, " 0.0", NUM_LENGTH);
            } else {
                snprintf(value, NUM_LENGTH, "% 12.6e", X[ results_seq[i] ]);
            }
        }
if (DEBUG) gprintf("print_results f i=%d\n",i);
if (DEBUG) gprintf("  % 14.6e  (nid=%d, dof=%d  idx=%d)\n", 
value, node_id, dof_type, index);

        if (dof_type < 1 || dof_type > 6) {
            stkerr("print_results: ", "bad dof_type");
            return 0;
        }
        strncpy(out_col[dof_type-1], value, NUM_LENGTH);
    }
    free(unused);
    free(results_seq);
    free(dof_list);

    drop();
    db_close();
    return 1;

} /* 1}}} */
