/* {{{1 GNU General Public License

sofea - the Stack Operated Finite Element Analysis program
Copyright (C) 2005  Al Danial <al.danial@gmail.com>

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software Foundation,
Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
}}}1 */
#include <stdio.h>
#include <stk.h>
#include <main.h>
#include <sql.h>
#include "fea_assemble.h"

int int_ext_dof() /* ( qModelDB qParnDB part_id --- hInt_local hExt_local hExt_global ) {{{1 */
/*
 * man entry:  int_ext_dof {{{2
 * ( qModelDB qParnDB part_id --- hInt_local hExt_local hExt_global ) Return three integer arrays:  the locally renumbered degree of freedom list of interior nodes in the given partition, the locally renumbered DOF list of boundary nodes in the given partition, and the same boundary DOF's except mapped to the global DOF list.
 * category: FEA
 * related: fea_assemble, se_global_dof 
 * 2}}}
 */
{
int DEBUG = 0;
    int     partition_number, i, j, dof, n_found, rc;
    double *Int_local, *Ext_local, *Ext_global ;
    callback_data sql_data;
    sqlite3 *dbh;
    char query[QUERY_STR_SIZE+1],
         EL_name[SQL_MAX_ID_LEN],   /* external dofs, local canonical  */
         EG_name[SQL_MAX_ID_LEN],   /* external dofs, global canonical */
         IL_name[SQL_MAX_ID_LEN];   /* internal dofs, local canonical  */

if (DEBUG) gprintf("int_ext_dof:  top\n");
    query[0] = '\0';

    if (!popint(&partition_number)) return 0;
    pushstr("DB_PARTN"); /* add to stack alias for partition db */
    if (!db_open2()) {   /* open model db & attach partition db */
        stkerr(" int_ext_dof: ", "failed to open model and partn dbs");
        return 0;
    }
    dbh = (sqlite3 *) tos->tex;

    /* create a temporary table containing boundary nodes (global  {{{2
     * canonical and locally renumbered canonical) of this partition 
     */

    rc = sql_cmd(dbh, "int_ext_dof 1 ",
                  "create table DB_PARTN.temp_boundary_node( "
                  "global_nid integer, -- FK to node.seq_no\n "
                  "local_nid  integer);");
    if (!rc) return 0;

    snprintf(query, QUERY_STR_SIZE, 
             "insert into DB_PARTN.temp_boundary_node "
             "select distinct(MN.seq_no), RN.new_id from "
             "DB_PARTN.P%02d_renumbered_nid RN, "
             "DB_PARTN.P%02d_canonical_nid  CN, "
             "node                          MN, "
             "DB_PARTN.boundary_node        BN "
             "where MN.seq_no in "
             "    (select nid from DB_PARTN.boundary_node) and "
             "MN.seq_no = CN.nid and "
             "CN.id     = RN.orig_id "
             "order by RN.new_id; ",
             partition_number,
             partition_number);

    rc = sql_cmd(dbh, "int_ext_dof 2 ", query);
    if (!rc) return 0;
    /* 2}}} */

    /* now get the interior nodes -- easy since interior nodes are {{{2
     * just the renumbered canonical nodes which aren't on the boundary
     */
    rc = sql_cmd(dbh, "int_ext_dof 3 ", 
                 "create table DB_PARTN.temp_interior_node(nid integer)");
    if (!rc) return 0;

    snprintf(query, QUERY_STR_SIZE, 
             "insert into DB_PARTN.temp_interior_node "
             "select new_id from "
             "DB_PARTN.P%02d_renumbered_nid "
             "where new_id not in  "
             "    (select local_nid from DB_PARTN.temp_boundary_node) " 
             "order by new_id; ",
             partition_number);
    rc = sql_cmd(dbh, "int_ext_dof 4 ", query);
    if (!rc) return 0;
    /* 2}}} */

    /* pull results from the temp tables and put them on the stack */

    snprintf(EL_name, SQL_MAX_ID_LEN, "Ext_local_%02d" , partition_number);
    snprintf(EG_name, SQL_MAX_ID_LEN, "Ext_global_%02d", partition_number);
    snprintf(IL_name, SQL_MAX_ID_LEN, "Int_local_%02d" , partition_number);

    sql_data.nRows = 0;
    rc = sql_do_query(dbh, 
                      "select global_nid,local_nid from "
                      "    DB_PARTN.temp_boundary_node;", 
                     &sql_data);
if (DEBUG) gprintf("int_ext_dof after query on temp boundary node rc=%d\n",rc);
    if ((rc != SQLITE_OK) && (rc != SQLITE_DONE)) {
        stkerr(" int_ext_dof A: ", sql_data.err_msg);
        return 0;
    }
if (DEBUG) gprintf("int_ext_dof A nRows=%d\n", sql_data.nRows);
    n_found = sql_data.nRows;
    if (!matstk(DOF_PER_NODE*n_found, 1, EG_name))     return 0;
    Ext_global = tos->mat;
    if (!matstk(DOF_PER_NODE*n_found, 1, EL_name ))     return 0;
    Ext_local  = tos->mat;

    dof = 0;
    for (i = 0; i < n_found; i++) {
        for (j = 0; j < DOF_PER_NODE; j++) {
            Ext_global[dof] = (sql_data.i[i][0] - 1)*DOF_PER_NODE + j + XBASE;
            Ext_local[ dof] = (sql_data.i[i][1] - 1)*DOF_PER_NODE + j + XBASE;
            ++dof;
        }
    }

    sql_data.nRows = 0;
    rc = sql_do_query(dbh, 
                     "select nid from DB_PARTN.temp_interior_node;", 
                     &sql_data);
if (DEBUG) gprintf("int_ext_dof after query on temp interior node rc=%d\n",rc);
    if ((rc != SQLITE_OK) && (rc != SQLITE_DONE)) {
        stkerr(" int_ext_dof B: ", sql_data.err_msg);
        return 0;
    }
if (DEBUG) gprintf("int_ext_dof B nRows=%d\n", sql_data.nRows);
    n_found = sql_data.nRows;
    if (!matstk(DOF_PER_NODE*n_found, 1, IL_name ))     return 0;
    Int_local  = tos->mat;
    dof = 0;
    for (i = 0; i < n_found; i++) {
        for (j = 0; j < DOF_PER_NODE; j++) {
            Int_local[dof] = (sql_data.i[i][0] - 1)*DOF_PER_NODE + j + XBASE;
            ++dof;
        }
    }

    /* drop the two temporary tables {{{2 */
    rc = sql_cmd(dbh, "int_ext_dof 5 ", 
                 "drop table DB_PARTN.temp_boundary_node;");
    if (!rc) return 0;
    rc = sql_cmd(dbh, "int_ext_dof 6 ", 
                 "drop table DB_PARTN.temp_interior_node;");
    if (!rc) return 0;

    /* 2}}} */

    pushstr("4 revn db_close"); xmain(0);  /* close the database */

    return 1;
} /* 1}}} */
