      program driver
      implicit none

      real*8  e0, g0, t0, xb1, xb2, xb3, yb1, yb2, yb3,
     .        alpha, beta, area, zip0
      integer pl0, i, j
      real*8  ekb(18,18), ek9(9,9)

c     t0   thickness?
c     pl0  >0 is plane stress        <0 is plane strain

      e0   =  10000000.
      g0   =  4000000.
      t0   =  1.
      pl0  =  1
      alpha=  1.5
      beta =  0.5
      area =  0.00017119963
      xb1  =  0.221399993
      xb2  =  0.200000003
      xb3  =  0.200000003
      yb1  = -0.792400002
      yb2  = -0.77640003
      yb3  = -0.792400002

      zip0 =  1.
      area =  0.00017119963

      do i = 1,18
        do j = 1,18
          ekb(i,j) = 0.0
        enddo
      enddo


      call elmstfMRT(e0, g0, t0, pl0, alpha, beta, area,
     .               xb1, xb2, xb3, yb1, yb2, yb3, ekb, ek9)

      write(6,*) 'after elmstfMRT:'
      call dump_matrix('ek9',  9,  9, ek9)
      call dump_matrix('ekb', 18, 18, ekb)

      call elmstfDKT(e0, g0, t0, zip0, area, 
     .               xb1, xb2, xb3, yb1, yb2, yb3, ekb, ek9 )

      write(6,*) 'after elmstfDKT:'
      call dump_matrix('ek9',  9,  9, ek9)
      call dump_matrix('ekb', 18, 18, ekb)

      end ! program test
      subroutine dump_matrix(mat_name, nRows, nCols, M) ! {{{1
      character*(*) mat_name
      integer nRows, nCols, i, j
      real*8  M(nRows, nCols)
      write(6,*) 'dump_matrix for ',mat_name
      do i = 1,nCols
        do j = 1,nRows
          write(6,'(2(i10,x),1pe15.8)') j,i,M(j,i)
        end do
      end do
      return
      end
c     1}}}
      subroutine prt_mat(mat_name, nRows, nCols, M) ! {{{1
      character*(*) mat_name
      integer i, j
      real*8  M(*)
      write(6,*) 'prt_mat for ',mat_name
      do i=1,nCols
          do j = 1,nRows
              write(6,'(i10,x,i10,x,1pe15.8)') j, i, M(j+(i-1)*nRows)
          end do
      end do
      return
      end
c     1}}}
