\ {{{1 GNU General Public License
{
Program Tops - a stack-based computing environment
Copyright (C) 1999-2005  Dale R. Williamson

Author: Dale R. Williamson <dale.williamson@prodigy.net>

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software Foundation,
Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
1}}} 
}

{  File pppcon.v  January 2001

   Copyright (c) 2001   D. R. Williamson

   Telecommunication: making point-to-point protocol (ppp) work and 
   setting the configuration for ppp scripts.
 
\  -   -   -   -   -   -   -   -   -   -   -   -   -   -   -   -   -   -

   The copy of this file configured for your machine should be in sub-
   directory usr/, where the program will find it first.  The original
   can stay in sys/. 

   This file is sourced by file web.v.  File web.v contains words used 
   to write other ones for connections to the web, and some are men-
   tioned in the discussion below. 
 
   The portion of this file that actually runs is far below, after:
      WORDS RUN BY THE PROGRAM BEGIN HERE.
 
\  -   -   -   -   -   -   -   -   -   -   -   -   -   -   -   -   -   -
 
   One of the goals of the program is to allow the machine to run
   unattended.  An unattended machine is even more useful if it can 
   fetch or send information outside of its domain.  Implementing ppp 
   (point-to-point protocol) within the program allows this.

   With ppp capability--and words from the multitasker such as TASK,
   ALARM, WAKE, and SLEEP: timer words that give other words a sense
   of time, a heartbeat--words can be written to dial out and fetch 
   information from web sites and to send email regarding information 
   fetched, or results computed.  And all this can be done in real 
   time--either at regular intervals, or at established times, or from 
   time-to-time as conditions determined by running words demand. 

   Being able to run ppp from the program lets one build words with as 
   much control as it takes to run unattended and yet communicate and
   adapt to changes required by external events unfolding.  

   Other ways to periodically run ppp outside of the program, such as
   utilizing the system cron, probably do not easily provide this much
   real-time adaptability.

\  -   -   -   -   -   -   -   -   -   -   -   -   -   -   -   -   -   -

   Step 1.  Making ppp work.

   Before the program can be used for ppp, you must develop separately
   a script that runs the pppd (point-to-point protocol daemon) program
   for your modem, phone numbers and ISP.  As a starting point, a sam-
   ple script, ppp.scr, is provided.

   This step is by far the most difficult one; it might take some time
   and cause some frustration.  Persevering pays off with the knowledge
   gained about pppd, the chat program it uses, and configuration of 
   serial ports--invaluable knowledge when problems occur that require 
   troubleshooting.  

   And when you have that hard-earned, working pppd script--heck, its 
   only one command line to the machine; what was the problem?--the 
   remaining steps, and running ppp from the program, are a snap.

   The following references may be helpful (actually, the first one is
   essential: many thanks to W. G. Unruh, unruh@physics.ubc.ca):

      Getting ppp working in linux--important information on setting
      up hostname, serial ports, ppp options, and figuring out what 
      your ISP wants:

         http://axion.physics.ucb.ca/ppp-linux.html

      Configuring your machine for sendmail and pop3--making your
      system configuration files:

         http://cork.linux.ie/projects/install-sendmail 

      Tips and scripts for compuserve (only for "classic" accounts;
      compuserve 2000 accounts do not work):

         http://forums.compuserve.com/scripts/flisapi.dll/RHCISPPP.TXT
         http://forums.compuserve.com/scripts/flisapi.dll/DIALUP.TXT

   Watching pppd and chat work:

      It takes a little effort to make pppd produce a log file, but it
      is worth it.  These are the steps (performed by root) taken from 
      Unruh's valuable reference:

         1. # cp /etc/syslog.conf /etc/syslog.conf.orig

         2. Edit /etc/syslog.conf to include these two lines:
              local2.*[tab]    /var/log/ppp
              daemon.*[tab]    /var/log/ppp
            where [tab] denotes hitting the tab key.

         3. Restart logging:
            # killall -1 syslogd 

         4. In the command for pppd (developing this is shown below), 
            add the debug switch to the list of commands:
               /usr/sbin/pppd /dev/ttyS1 debug 57600 connect \

      The interchange between the computer and modem and the modem and 
      ISP will now be continuously recorded on log file /var/log/ppp.  

      Using the debug switch in pppd under Red Hat Linux 5.2 will cause
      your name and password to appear in the log file.

      The log file can be viewed as pppd runs using the tail command: 

         [root@gutter] /home/user # tail -f /var/log/ppp

   Serial port information:

      Serial ports incorrectly set will not allow pppd to connect, or 
      cause a long delay between the computer sending the AT command to
      the modem and the receipt of its OK response (due to wrong IRQ
      line specified).  As root, running this setserial command 

         [root@gutter] /home/user # setserial /dev/ttyS1
         /dev/ttyS1, UART: 16550A, Port: 0x02f8, IRQ: 3

      shows the current settings for serial port /dev/ttyS1.  If you 
      have not used the port, settings shown might be wrong.  Or, if 
      you have two serial ports and running setserial on the other one

         [root@gutter] /home/user # setserial /dev/ttyS3
         /dev/ttyS3, UART: 16550A, Port: 0x02e8, IRQ: 3

      shows the same IRQ line, there is a conflict to be resolved.

      The modem can appear to connect properly (as tracked on the ppp
      log file) even with the wrong IRQ line.  But when dialog with the
      ISP is going on, it will hang and chat will eventually time out.

      Setting just the irq for a port, such as ttyS2, is done by:

         # setserial /dev/ttyS2 irq 5

      Here are example settings for serial ports using the setserial 
      command.  Such commands can be placed in file /etc/rc.d/rc.serial 
      (this is under Redhat Linux--find your rc.sysinit file--probably 
      in a subdirectory like /etc/rc.d--to see everything that is done 
      at boot up, including the setting of serial ports; there is pro-
      bably an entry in rc.sysinit that initializes serial ports, and 
      it might point to a file like /etc/rc.serial).

         [root@clacker] /etc/rc.d # more /etc/rc.serial
         #!/bin/sh
         setserial /dev/ttyS0 uart 16550A port 0x03f8 irq 4
         setserial /dev/ttyS1 uart 16550A port 0x02f8 irq 3
         setserial /dev/ttyS2 uart none port 0x03e8 irq 2
         setserial /dev/ttyS3 uart 16550A port 0x02e8 irq 5
   
   When your pppd script works, you should be able to connect and run 
   Netscape even if email is not working yet.  Here are some final 
   cleanup items before Step 2:

      To run pppd without being a root user, the following permission
      changes are required:

         Make the pppd program file rx premission for users:
            # chmod a+rx /usr/sbin/pppd

         Make the pppd program setuid for root:
            # chmod +s /usr/sbin/pppd

         Make the pppd serial port accessible to users.  Assuming ttyS1
         (COM2), here is the chmod command:
            # chmod a+rw /dev/ttyS1

   Making a program to terminate the running pppd program:

      While getting pppd working, the command

         [root@gutter] /home/user # killall pppd

      was a pretty good way to terminate pppd.  Now it is time to make 
      a program that will let you or an unattended program--running as 
      ordinary users--terminate a pppd session.

      Program pppoff.c, obtained from

         http://axion.physics.ubc.ca/ppp-kill-wrapper.html

      is the source for a so-called wrapper program that will allow a 
      non-root user to kill the running pppd program.  A copy of this
      program is contained in the Appendix below.

      Here are steps to compile program pppoff, set permissions, and 
      move it to directory /etc/ppp.  Note that root is required.

         # gcc -o pppoff pppoff.c
         # chmod a+x pppoff
         # chmod +s pppoff
         # mv pppoff /etc/ppp/.
         # ln -s /etc/ppp/pppoff /usr/local/bin/pppoff

      Now to terminate a pppd connection from anywhere, run:

         [user@gutter] /home/user > pppoff

      Word pppclose expects to run pppoff to terminate a connection 
      from within the program (shown in Step 4).

\  -   -   -   -   -   -   -   -   -   -   -   -   -   -   -   -   -   -

   Step 2.  Making ppp template file ppp.scr and secrets file pppsec.v.

   When your ppp script is working, place a copy of it called ppp.scr 
   in your usr/ directory for this program, for the program to use as a
   template.

   It should be arranged with separate lines more or less in the follow-
   ing form (backslash is a continuation to the next line; take care not
   to allow any spaces after the backslash or Unix and Linux will pro-
   bably fail to interpret the continuation properly): 

    modem:    /usr/sbin/pppd /dev/ttyS1 57600 connect \
              "/usr/sbin/chat -v \
              '' '\dATS0=0Q0V1&C1&D2' OK \
    phone:    ATD82-XXX-YYY-ZZZZ CONNECT--ECT \
              CLIENT 'Host Name:--:' \
              CIS 'User ID:--:' \
    user:     'Your user id string' \
    password: '\c' 'Password:' ****** \
              '' PPP"

   Note that the strings "modem:" "phone:" "user:" and "password:" are 
   just for reference in this discussion, and are not part of ppp.scr;
   and all lines in template ppp.scr begin in the leftmost column. 

   The string in the template that word pppset will key upon for modem:
   is '/dev/tty,' and the string to be matched for the phone: number 
   text line is 'ATD.'  Just these strings in the template are suf-
   ficient, but the complete lines from the working pppd script can be 
   used.

   The user: and password: lines will be replaced by information placed 
   into secrets file pppsec.v.  For protection, file pppsec.v should 
   be made read-only by you-only as shown next.  

   A sample secrets file pppsec.v is provided, to be copied into your 
   usr/ directory and modified.  After your true user and password 
   lines are safely in secrets file pppsec.v perform these steps: 

      i. Make pppsec.v read-only by you-only, with chmod 400: 

            [user@gutter] /home/user/mytops/usr > chmod 400 pppsec.v

     ii. Replace your true user: and password: lines still in template 
         ppp.scr with these:

            'Your user id string' \
            '\c' 'Password:' ****** \

         Depending upon your script, these lines might appear on dif-
         ferent numbered lines than they did in the sample.  That is 
         ok as long as they each contain the following minimum strings,
         as the ones above do (other characters are not required): 

            Your user id 
            Password 

         These strings in the template will be matched when the word
         PPPtemplate runs and inserts your true user and password lines
         from pppsec.v into the temporary script created in memory to 
         make the actual connection.

\  -   -   -   -   -   -   -   -   -   -   -   -   -   -   -   -   -   -

   Step 3. Configuring file pppcon.v for your modems and phone numbers.

   Copy this file, sys/pppcon.v, to your usr/pppcon.v and modify it
   to hold your modem ports and phone numbers.  Later, they will be 
   inserted into the scripts that the program will build to run pppd.  
   A number of ports and phone numbers can be defined and the program
   will cycle through them when trying to connect.

   Configuring usr/pppcon.v requires these two steps:

      1. Beneath the string "Modem serial ports:" define the serial 
         ports for your modems.  Lines preceded by # are ignored.

         Example: the serial port is /dev/ttyS1 and the modem speed 
         is 115,200 bps:

               /usr/sbin/pppd /dev/ttyS1 115200 connect \

      2. Beneath the string "Numbers each modem can call:" list the
         phone numbers that connect to your ISP.  Lines preceded by # 
         are ignored, and dashes in the number are ok.  

         Example: the number is 310-823-3101 and 91 is needed for an 
         outside line:

              ATD-91-310-823-3101 CONNECT--ECT \

         List phone numbers in order from most-preferred to least-
         preferred.  Some numbers may be toll calls or some may be 
         less reliable in making connections, or may be so full of 
         traffic that bits move slowly.  Word pppconnect will try 
         preferred numbers first, several times, before moving to 
         less-preferred ones (see ppptest in Step 4). 

      3. In word PORT_LIB defined below, replace "my.name@isp.net"
         with your quoted email IP address that will be used by word 
         pppsend in file web.v

\  -   -   -   -   -   -   -   -   -   -   -   -   -   -   -   -   -   -

   Step 4. Testing your scripts and connections.

   Created in Steps 2 and 3, these files are now in subdirectory usr/:

      ppp.scr - your working pppd script with template patterns in the 
         lines for phone number and password (Step 2)

      pppsec.v - a protected secrets file with your login name and 
         password (Step 2)

      pppcon.v - this file modified to contain modem definitions and
         phone numbers to be placed into template ppp.scr (Step 3)

   Scripts of the same form as ppp.scr already work from the command
   prompt for your modems and phone numbers.  That was the hard part 
   done in Step 1.  

   Now it is time to make these same connections from the program.  And
   if there are any problems, the experience gained by making the Step 
   1 scripts work will be valuable here: by now, the first reflex is 
   probably to look at what is said in the log files ppp and messages 
   in subdirectory /var/log.

   Sourcing file web.v in subdirectory sys/ will bring the words into
   play that make ppp connections: 

      [tops@gutter] ready > web.v source

   Refer to file web.v for the stack diagrams and phrases that form the 
   words mentioned below.

   For example, word modem uses template ppp.scr and your port and phone
   numbers in file pppcon.v to make a script for running pppd on the pth
   port with the nth number.  Given p and n on the stack, saying modem 
   results in a handle to the script text--for p and n--on the stack: 

      (p n) modem (hT)

   Word pppscript uses word modem to cycle through all phone numbers 
   and all modems.  Verify that correct scripts are created by running
   pppscript a number of times and displaying the scripts it places on 
   the stack.  Saying pppscript the first time will place on the stack
   a script containing the first phone number (word . displays it):

      [tops@gutter] ready > pppscript (hT) . 
      #!/bin/sh
      /usr/sbin/pppd /dev/ttyS1 57600 connect \
      "/usr/sbin/chat -v \
      '' '\dATS0=0Q0V1&C1&D2' OK \
      ATD-82-310-xxx-xxxx CONNECT--ECT \
      CLIENT 'Host Name:--:' \
      CIS 'User ID:--:' \
      'xxxxxx,xxxx/NOINT/GO:PPPCONNECT' PPP \
      '\c' 'Password:' ************ \
      '' PPP"
      [tops@gutter] ready > 

   Saying pppscript again will produce the script containing the next
   phone number, and so on.

   After verifying that pppscript cycles through a valid set of pppd 
   scripts, word ppptest can be run to test every connection by run-
   ning all modems and all phone numbers.  For example, here is a test 
   for one modem and three phone numbers, so there is a 3 on the stack
   before saying ppptest: 

      [tops@gutter] ready > 3 (1 modem times 3 numbers) ppptest
       Modem connection test
       Sun Jan 21 12:15:03 PST 2001
       Maximum attempts: 3 [attempts before trying next number]
        Connecting modem 1 to line 1... ok
        Connecting modem 1 to line 2... ok (2)
        Connecting modem 1 to line 3... ok (2)
       Elapsed time: 6.1 minutes

   The (2) that appeared when connecting to phone lines 2 and 3 indi-
   cates their connections were made on the second attempt.  In prac-
   tice, connection to a satisfactory line 1 should routinely succeed 
   in one or two tries, making lines 2 and 3 infrequently used.

   Word pppconnect works like ppptest except that it remains connected
   when it succeeds.  Use word pppconnect to make a connection from the
   program ready prompt as follows.  The true flag (-1) on the stack 
   means the connection has been made:

      [tops@gutter] ready > pppconnect

       stack elements:
             0 number: -1
      [tops@gutter] ready > 

   A program like Netscape can be started from the system prompt in 
   another window and when it comes up it will be connected to the web:

      [user@gutter] /home/user > netscape &

   Finally, word pppclose closes the connection from the ready prompt 
   by running program pppoff created in Step 1. 

      [tops@gutter] ready > pppclose

       stack elements:
             0 number: -1
      [tops@gutter] ready > 

   That's it.  This shows you can make the program connect to the web.
   The real work of building words that connect, collect, and send in 
   your absence can begin.
}
\-----------------------------------------------------------------------
   
\  WORDS RUN BY THE PROGRAM BEGIN HERE.

\  Checking for files that will be needed:

   "ppp.scr" filefound \ ppp script template
   IF drop true ELSE " Missing file ppp.scr" . nl false THEN (f1)

   "pppsec.v" filefound \ user name and password
   IF drop true ELSE " Missing file pppsec.v" . nl false THEN (f2)

   (f1 f2) and not IF halt THEN

   "ISP_config" missing IF "web.v" source THEN

\-----------------------------------------------------------------------

{  My modem ports and phone numbers.

   Regions of text below contain versions of PORT_LIB for specific ISPs.

   In a version of this file (pppcon.v) at your usrpath, you will create
   one or more specific versions of word PORT_LIB regions similar to the
   way it is done below.

   In scripts made in the library of PORT_LIB, lines appear exactly as 
   they do in your working ppp script, which file ppp.scr is a template
   for.

   In text for scripts below, blank lines and lines with # (anywhere) 
   are ignored.

   How a specific PORT_LIB is sourced.

   A region of text in a file can be sourced using word msource, which 
   targets a region beginning with a unique line of text and ending with
   word halt or word end.

   Word ISP_config (file web.v) uses msource to redefine PORT_LIB for a 
   specific ISP, allowing the program to reconfigure on-the-fly.  

   Regions below defined by "ISP prodigy" and "ISP earthlink" offer ex-
   amples of regions that contain definitions of word PORT_LIB that word
   ISP_config might target using msource.
}
\-----------------------------------------------------------------------

\  Replace the following with your ISP that is referenced in your file
\  pppcon.v at usrpath:
   "prodigy" ISP_config 

   halt \ end of sourcing this file

\-----------------------------------------------------------------------

   ISP prodigy

{  ISP prodigy.net uses pap and chap for authentication, so the pppd 
   line below contains a user name phrase "user rounder@prodigy.net" 
   and the pap and chap secrets files in /etc/ppp/ contain the line:
      rounder@prodigy.net            *       password  *
}
   inline: PORT_LIB ( --- ) \ library for prodigy.net

      [ \ My address for email on prodigy.net:
         "rounder@prodigy.net" "email_from" book

      {" Modem serial ports
         
         # Two lines for each port define:
         #    1) the pppd string
         #    2) modem string
         # Lines with # anywhere are stripped out.

         # Use internal modem for prodigy.net

         # 1. Internal modem:
          /usr/sbin/pppd user rounder@prodigy.net /dev/ttyS3 57600 \
          '' '\dATQ0V1&C1&D2M0' OK \

         # 2. External modem:
         #/usr/sbin/pppd user rounder@prodigy.net /dev/ttyS1 38400 \
         #'' '\dATZ4M0' OK \

      "} (hT) left justify "#" "" qreplace (hT)
      asciify noblanklines notrailing (hT)
      these rows 2 spikes rake
      "Ports" book
      "ModemInit" book

      host "sigma" alike
      IF
         {" Numbers each modem can call for prodigy.net:

            # Place these with preferred connections first

            # Remember, this region is a Unix script, not program text.

            # San Fernando:
             ATD-XXX-YYY-ZZZZ CONNECT--ECT \
             ATD-XXX-YYY-ZZZZ CONNECT--ECT \
             ATD-XXX-YYY-ZZZZ CONNECT--ECT \
            # Sun Valley:
            #ATD-XXX-YYY-ZZZZ CONNECT--ECT \
         "} 
      ELSE \ not from host sigma:

         {" Numbers each modem can call for prodigy.net:

            # Torrance:
             ATD-82-XXX-YYY-ZZZZ CONNECT--ECT \
             ATD-82-XXX-YYY-ZZZZ CONNECT--ECT \
            # Redondo Beach:
             ATD-82-XXX-YYY-ZZZZ CONNECT--ECT \

            # Torrance:
             ATD-81-XXX-YYY-ZZZZ CONNECT--ECT \
             ATD-81-XXX-YYY-ZZZZ CONNECT--ECT \
            # Redondo Beach:
             ATD-81-XXX-YYY-ZZZZ CONNECT--ECT \
         "} 
      THEN
      (hT) left justify "#" "" qreplace (hT)
      asciify noblanklines notrailing (hT)
      (hT) "PhoneNumbers" book
      ]
\     Saying PORT_LIB puts email address on the stack
      email_from (qS)
   end

   halt \ prodigy

\-----------------------------------------------------------------------

   ISP earthlink

{  ISP earthlink.net uses pap and chap for authentication, so the pppd 
   line below contains a user name phrase "user mudder@earthlink.net" 
   and the pap and chap secrets files in /etc/ppp/ contain the line:
      mudder@earthlink.net            *       password  *
}
   inline: PORT_LIB ( --- ) \ library for earthlink.net

      [ \ My address for email on earthlink.net:
         "mudder@earthlink.net" "email_from" book

      {" Modem serial ports

         # Two lines for each port define:
         #    1) the pppd string
         #    2) modem string
         # Lines with # anywhere are stripped out.

         # Use extermal modem for earthlink.net:

         # 1. Internal modem:
         # /usr/sbin/pppd user mudder@earthlink.net /dev/ttyS3 57600 \
         # '' '\dATQ0V1&C1&D2M0' OK \

         # 2. External modem:
         /usr/sbin/pppd user mudder@earthlink.net /dev/ttyS1 38400 \
         '' '\dATZ4M0' OK \

      "} (hT) left justify "#" "" qreplace (hT)
      asciify noblanklines notrailing (hT)
      these rows 2 spikes rake
      "Ports" book
      "ModemInit" book

      host "sigma" alike
      IF
\     For access numbers: http://support.earthlink.net/support/ACCESS/

         {" Numbers each modem can call for earthlink.net:

            # Place these with preferred connections first

            # Remember, this region is a Unix script, not program text.

            # San Fernando:
             ATD-XXX-YYY-ZZZZ CONNECT--ECT \
             ATD-XXX-YYY-ZZZZ CONNECT--ECT \
             ATD-XXX-YYY-ZZZZ CONNECT--ECT \
            # Sun Valley:
            #ATD-XXX-YYY-ZZZZ CONNECT--ECT \
         "}
      ELSE \ not from host sigma:

         {" Numbers each modem can call for earthlink.net:

            # Redondo Beach:
             ATD-82-XXX-YYY-ZZZZ CONNECT--ECT \
             ATD-82-XXX-YYY-ZZZZ CONNECT--ECT \
            # Torrance:
             ATD-82-XXX-YYY-ZZZZ CONNECT--ECT \
             ATD-82-XXX-YYY-ZZZZ CONNECT--ECT \

            # Redondo Beach:
             ATD-81-XXX-YYY-ZZZZ CONNECT--ECT \
             ATD-81-XXX-YYY-ZZZZ CONNECT--ECT \
            # Torrance:
             ATD-81-XXX-YYY-ZZZZ CONNECT--ECT \
             ATD-81-XXX-YYY-ZZZZ CONNECT--ECT \
         "}
      THEN
      (hT) left justify "#" "" qreplace (hT)
      asciify noblanklines notrailing (hT)
      (hT) "PhoneNumbers" book
      ]
\     Saying PORT_LIB puts email address on the stack
      email_from (qS)
   end

   halt \ earthlink

\-----------------------------------------------------------------------
;
   Appendix

   Here is the pppoff.c program, that allows non-root to kill running
   pppd.

/* pppoff.c

From http://axion.physics.ubc.ca/ppp-kill-wrapper.html

PPP Kill SUID Wrapper

The problem this file solves is how to allow users to run a command
as root (killall pppd) without giving them root priviledges. The
simplest way is to write what is called a C wrapper for the program,
which allows the program to be run suid root, but without introducing
any extra security holes into your system.  This is a C wrapper for
the killall command.

While logged in as root do

# gcc -o pppoff pppoff.c
# chmod a+x pppoff
# chmod +s pppoff
# mv pppoff /etc/ppp/.
# ln -s /etc/ppp/pppoff /usr/local/bin/pppoff

When you want to terminate a connection, just run

pppoff

Note that this file will allow any user to kill a running pppd, even if
they did not start it. If you have users who would abuse this, you have
deeper problems than this note is liable to solve, and you probably
already have the expertise to solve the problem yourself.

*/
#include <signal.h>
#include <sys/param.h>
#include <pwd.h>
static char *trusted_env[]={"PATH=/usr/bin:/usr/sbin:/sbin:/bin",0};
main()
{
struct passwd *pwd;
        int i;
        uid_t uid;
for (i=0;i < NSIG;i++){ if(i!= SIGKILL && i!=SIGCHLD)
                                {(void) signal(i,SIG_IGN);}
                    }
uid=getuid();

if ( (pwd = getpwuid(uid))== (struct passwd *)0 )
    exit(1);
setuid((uid_t)0);

execle("/usr/bin/killall","/usr/bin/killall","pppd",(char *)0,trusted_env);

setuid(uid);
exit(1);
}
