/* File exp.n
   May 2005

   C and C-like expressions for testing the parser.

----------------------------------------------------------------------*/

   EXP_ERRORS=0;

   u=1;v=2;A=u+-4.0e-4*-1-v./(5^3).*77.3/-3.1415-1; /*ans:A=0.394097*/
/*                         ||     ||                               
        using term-by-term /      and term-by-term *       

   u=1;v=2;A=u+-4.0e-4*-1-v/5^3*77.3/-3.1415-1;
*/

<< u 4.0e-4 negate 1 negate * + v
   5 3 ^ /by 77.3 *by 3.1415 negate / - 1 - "A1" book
>>

if(A1-A != 0) (nl(dot(" ERROR A file exp.n")), EXP_ERRORS++);
else nl(dot(" OK A file exp.n"));

/* C code:
      double u=1,v=2,A;
      A=u+-4.0e-4*-1-v/pow(5,3)*77.3/-3.1415-1;
      fprintf(stdout," u: %f v: %f A: %f\n",u,v,A);
   C Result:
       u: 1.000000 v: 2.000000 A: 0.394097

----------------------------------------------------------------------*/

/* Trapezoidal integration of f(x)=4/(1 + x^2) (word piece, clu.v): */

x1=5;
x2=20;
Y = (x2 - x1)*(4/(1 + x1^2) + 4/(1 + x2^2))/2;

<< x2 x1 - 4 1 x1 2 ^ + / 4 1 x2 2 ^ + / + * 2 / "Y1" book >>

if(Y1-Y != 0) (nl(dot(" ERROR Y file exp.n")), EXP_ERRORS++);
else nl(dot(" OK Y file exp.n"));

/*--------------------------------------------------------------------*/

// Each term in X should equal -16:

X=[
0 - -4*-4;
-1*-4^2;
-1*(-4)^2;
-1*-4*-4;
-1*(-4)*-4;
ontop(-1*[4]^2)
];

if(ontop(totals(X))/rows(X)!=-16)
   (nl(dot(" ERROR X file exp.n")), EXP_ERRORS++);
else nl(dot(" OK X file exp.n"));



