\ {{{1 GNU General Public License
{
Program Tops - a stack-based computing environment
Copyright (C) 1999-2005  Dale R. Williamson

Author: Dale R. Williamson <dale.williamson@prodigy.net>

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software Foundation,
Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
1}}} 
}

{ File cal.v  July 1999

   Copyright (c) 1999   D. R. Williamson

   Words for calendars
}
   "gdate" exists? IF halt THEN

\-----------------------------------------------------------------------

   private 1based

\-----------------------------------------------------------------------

{  Calendar.  Date search utility:

   This answers questions like: 

      What was the date 421 days after Jan 21, 1952?:

         [tops@gutter] ready > 520121 greg 421 + gdate .i
          530317
         [tops@gutter] ready >

      It was 530317 or 53 03 17 or Mar 17, 1953.

   This search utility--specifically word gdate--is used below in an
   interactive date prompter, word datespinner.

   The heart of gdate is word searching, which is a general purpose
   search routine for monotonic functions (functions that can be im-
   plemented as words, like day-g, month-g and year-g below).  It 
   uses a binary search approach to quickly divide and conquer (see 
   function searching() in math.c).
}
   inline: _yyymmdd [ scalar "Y" book ] Y ;

   inline: gdate (g --- yyymmdd) \ converts Gregorian day, g, into date
\     Year yyy is 0-based at 1900, so 100 is year 2000; 200 used below
\     in searching means this function is valid from 1900 to 2100.
      this type push, hand push
      list: peek rows 1st
         DO peek I pry
            dup "year-g" 200 (years from 1900) searching (yyy)
            10000 star 0101 + _yyymmdd !
            dup "month-g" 11 (months 0 to 11) searching (mm-1)
            100 star _yyymmdd @ + _yyymmdd !
            "day-g" 30 (days 0 to 30) searching (dd-1) 
            _yyymmdd @ +
         LOOP pull drop
      end pull NUM = IF 1st pry THEN
   end

   inline: day-g (d --- g) \ function used by word searching
\     d is 0-based; returns g(yyymm[dd+d])
      _yyymmdd @ + greg ;

   inline: month-g (m --- g) \ function used by word searching
\     m is 0-based; returns g(yyy[mm+m]dd)
      100 star, _yyymmdd @ + greg ;

   inline: year-g (yyy --- g) \ function used by word searching
\     yyy is 0-based at 1900; returns g(yyy0101)
      10000 star 0101 plus greg ;

\-----------------------------------------------------------------------

{  Calendar.  Utilities for working with dates.

   General: 

      Years are 1900-based; for example, yyy=101 is 2001

      Some words assume no dates before 1900

      Other words use word yearfix to add 100 to years less than 70,
      assuming no dates before 1970

      Word ydays currently builds database for years 1977 to 2010

      Dates are usually of the form yyymmdd where yyy is a 2- or 
      3-digit year that is 1900-based, and mm and dd are month and
      day, 1-based; for example, Feb 1, 2001 is 1010201
}
   inline: date1$ (hyyymmdd --- qS) \ form: 02 Aug 11 for 1110802
      [ "%02.0f" is form ]
      hand push peek rows 1st
      DO peek I pry
         YDM (M) month$ swap 
         (D) form format spaced swap cat spaced swap 
         (Y) dup 99 > IF 100 less THEN form format cat
       LOOP pull rows pilen ;

   inline: date2$ (hyyymmdd -- qS) \ form: Wed 03 Aug 05 for 1050803
      hand push peek rows 1st
      DO peek I pry
         this weekday day$ spaced, back date1$ cat 
      LOOP pull rows pilen ;

   inline: date3$ (hYYYMMDD --- hT) \ form: 04-01-00, 12-02-99
      [ "%02.0f-%02.0f-%02.0f" is form ]
      hand YDM (yr day mo) swap rot (mo day yr)
      dup 99 those rows one fill > 100 *f plus
      three parkn form format
   end

   inline: date4$ (hyyymmdd -- qS) \ form: Wed Feb 6, 2008 for 1080206
      hand push peek rows 1st
      DO peek I pry push
         peek weekday day$ spaced
         peek 10000 mod 100 /mod lop month$ spaced +
         peek 100 mod intstr ", " + +
         pull 10000 /mod lop 1900 + intstr +
      LOOP pull rows pilen 
   end

   inline: datename ( --- qS) \ today's date in form jul17-99
      date words push
      peek 2 ndx quote strchop
      peek 3 ndx quote strchop
      "-" pull 6 ndx quote strchop -2 indent cat
      cat cat lowercase
   end
      
   define: datevalid (yyymmdd --- f) \ verifies number is a date
\     f is false (0) if no such date; otherwise, f is true (-1)
      dup greg, gdate = ;

   inline: day$ (d --- qS) \ string for day d, where d=0 is Sat, etc.
      [ "Sat Sun Mon Tue Wed Thu Fri" words "Days" book ] 
      Days back xbase plus quote ;

   inline: daylast (sec nD --- nYYYMMDD) \ last date of day D
{     For machine time sec, look back to find the previous date of
      weekday D.  Values of D corresponding to weekdays are in the 
      following list:
         Sat=0, Sun=1, Mon=2, Tue=3, Wed=4, Thu=5, Fri=6
 
      Example: Sunday last
         Sunday last from January 2, 2008 is December 30, 2007:
            1080102 0 ltime 1 daylast date2$ .
}
      push (sec) 86400 + 7 1st
      DO (sec) 86400 - dup mdate (nYYYMMDD) dup peek daysof          
         IF (nYYYMMDD) EXIT 
         ELSE (nYYYMMDD) drop
         THEN
      LOOP swap pull 2drop
   end

   inline: daynext (sec nD --- nYYYMMDD) \ next date of day D
{     For machine time sec, look ahead to find the next date of
      weekday D.  Values of D corresponding to weekdays are in the
      following list:
         Sat=0, Sun=1, Mon=2, Tue=3, Wed=4, Thu=5, Fri=6

      Example: Sunday next
         Sunday next following December 31, 2007 is January 6, 2008:
            1071231 0 ltime 1 daynext date2$ .
}
      push (sec) 86400 - 7 1st
      DO (sec) 86400 + dup mdate (nYYYMMDD) dup peek daysof
         IF (nYYYMMDD) EXIT
         ELSE (nYYYMMDD) drop
         THEN
      LOOP swap pull 2drop
   end

   inline: dayofweek (i --- n) \ for index i, gives index of day of week
\     Regardless of index base for i, gives 2=Mon, 3=Tue, ... for i that
\     starts at 1st for Mon.
      two + xbase - ;

   inline: daysApart (Y2m2d2 Y1m1d1 --- n) 
      greg back greg less negate ;
{     Example: Is 3000 a leap year?  Most millennia are not:

         2000 1900 - 10000 * 0301 + 2000 1900 - 10000 * 0229 +
         daysApart .i nl \ gives 1; says (1 + Feb 29, 2000)=Mar 1, 2000 
                         \ so 2000 is a leap year

         3000 1900 - 10000 * 0301 +, 3000 1900 - 10000 * 0229 +
         daysApart .i nl \ gives zero: (0 + Feb 29, 3000)=Mar 1, 3000 
                         \ so 3000 is not a leap year

      Great news: calendar function is Y3K compliant too!!
}
   inline: daysof (hYYYMMDD d --- hR) \ rake true at days of week d
{     d: Sat=0, Sun=1, Mon=2, Tue=3, Wed=4, Thu=5, Fri=6
      Example: dates in January 2000 that are Wednesdays:
         1000101 31 items, dup 4 daysof rake lop these rows 1st 
         DO dup I pry date2$ sp . nl LOOP drop
}     push hand greg, 
      7 those rows one fill mod, pull those rows 1 fill = ;

   inline: mdate (sec --- nYYYMMDD) \ machine date
{     If incoming sec is machine time, as from word time, then
      number YYYMMDD holds the current year (1900 based), month
      and day in Greenwich, England.

      See use in word daylast.

      Note:
         time mdate
      is the same as
         time ctime sysdate drop

}     (sec) 86400 / integer \ days from 700101 (Jan 1, 1970)
      700101 greg + (g)     \ add days from Gregorian zero to 700101
      (g) gdate (nYYYMMDD)  \ current YYYMMDD
   end

   inline: monend (hYYY --- hD) \ month-end dates for list of years
{     Returned month-end dates fall on weekdays, M-F; example:

         list: 99 100 ; monend date2$ 5 indent .

}     [ list: 131 231 331 431 531 631 731
              831 931 1031 1131 1231 ; "B" book \ last day each month
      ] xbase push 1based
      hand yearfix yes sort "YYY" book

      \ list of M-F dates from word ydays for years YYY:
      1 1 null YYY rows 1st
      DO YYY I pry dup ydays swap 10000 * +d pile
      LOOP INF pile "D" book

      \ lists of new month dates to look for, each month a column:
      YYY 10000 *f push, YYY rows 0 null, B rows (12) 1st
      DO peek B I pry +d park LOOP pull drop (hx, 12 cols)

      \ adding a row for beginning of new month after last YYY
      YYY its rows pry 1+ 10000 * 0131 +
      12 clone pile (hx, 12 cols)

      \ looking for new month dates:
      D (hX)
      dup 12 clone (hY) \ 12 cols of Y match 12 cols of x for look
      (hX hY) park (hXY)
      swap (hXY hx) look (hY)

      \ make into vector, sort, eliminate duplicates and 0 days:
      (hY) chain yes sort 0 pile \ 0 pile ensures ending dup from sling
      again sling rake lop, again rake lop (hD)

      "_monend" naming pull indexbase
   end

   inline: month$ (m --- qS) \ month m string, where m=1 is Jan, etc.
      [ "Jan Feb Mar Apr May Jun Jul Aug Sep Oct Nov Dec" 
         words "Months" book
      ] Months back nit xbase plus quote ;

   inline: qend (hYYY --- hD) \ quarter-end dates for list of years
{     Returned quarter-end dates fall on weekdays, M-F; example: 

         list: 79 80 81 82 ; qend date2$ 5 indent .

}     [ list: 101 401 701 1001 ; "B" book \ 1st day of new quarter
      ] xbase push, 1based
      hand yearfix yes sort (hYYY)

\     Only the first two quarters are obtained for the last year, so 
\     tack on another year then strip off the extra two quarters:
      (hYYY) dup these rows pry tic pile "YYY" book

      \ list of M-F dates from word ydays for years YYY: 
      1 1 null YYY rows 1st
      DO YYY I pry dup ydays swap 10000 * +d pile
      LOOP INF pile "D" book

      \ lists of new quarter dates to look for, each quarter a column:
      YYY 10000 *f push, YYY rows 0 null, B rows (4) 1st
      DO peek B I pry +d park LOOP pull drop (hx, 4 cols)

      \ looking for new quarter dates:
      D (hX) 
      D dup park dup park (hY) \ 4 cols of Y match 4 cols of x for look
      (hX hY) park (hXY) 
      swap (hXY hx) look (hY)

      \ deducting one from new quarter dates to give quarter-end dates:
      these cols 1st 
      DO these rows 1st
         DO (hY) this I J fetch dup 10000 mod B J pry =
            IF D this rot bsearch drop 1- pry over I J store
            ELSE drop      
            THEN
         LOOP
      LOOP

      \ make into vector, sort, eliminate duplicates and 0 days:
      (hY) chain yes sort
      again sling rake lop, again rake lop (hD)

\     Remove the two quarters for the extra year tacked onto YYY:
      (hD) 1st those rows two less items reach 

      "_qend" naming pull indexbase
   end

   define: qfilename (yyymmdd -- qS) \ qtrly name for 1900-based yyymmdd
      [ "jan-mar. apr-jun. jul-sep. oct-dec." words are quarters ]
      YDM lop nit 3 slash integer 1st plus quarters
      swap quote swap this 99 > IF 100 less THEN this 10 <
      IF "0%0.0f" ELSE "%0.0f" THEN format cat 1st quote
   end
{
   define: qfilenameCheck ( --- )
      list: 1000101 1000201 1000301 1000401 1000501 1000601
            1000701 1000801 1000901 1001001 1001101 1001201
      end is D
      D rows 1st DO D I pry dup nl .i qfilename sp dot LOOP ;
}

   inline: revdate (hA --- hA1) \ reverses date mmddyy to form yyymmdd
{     Elements of incoming A have the form mmddyy, where yy = 98, 99, 
      00, 01, ..., and elements of outgoing A1 have form yyymmdd where
      yyy = 98, 99, 100, 101, ...; assumes no dates before 1970.  Word
      unrevdate reverses this process.
      Example:
         list: 41278 62383 120399 102800 ; revdate dup dup unrevdate 
         .i nl dup .i rows 1st DO this I pry date2$ nl . LOOP drop nl
}     
      this type push
      hand push peek again 100 /f integer, 100 *f integer less
      its 70 (1970) greater 100 *f plus 10000 *f (year)
      peek 100 /f integer, dup 100 /f integer 100 *f integer less (day)
      pull 10000 /f integer 100 *f (mo) swap plus plus
      pull NUM = IF ontop THEN
   end

   inline: unrevdate (hA --- hA1) \ reverses date yyymmdd to form mmddyy
{     Elements of incoming A have form yyymmdd, where yyy = 98, 99, 100,
      101, ..., and elements of outgoing A1 have form mmddyy where
      yy = 98, 99, 00, 01, ....  Word revdate reverses this process.
}     
      this type push
      hand this 10000 /f integer (yyy) this rev 10000 *f less (mmdd)
      100 *f (mmdd00) swap (yyy) this 99 beneath 100 *f less (yy) plus
      pull NUM = IF ontop THEN
   end

   inline: wednesdays (hYYYMMDD --- hR) \ rake true at Wednesdays
      four daysof ;

   define: weekday (YYYmmdd --- n) \ day of week, where Sat=0
      [ "greg 7 mod" "wday" inline ] wday run ;

   inline: weekdays (YYY --- n) \ number of Mondays thru Fridays in YYY
\     This version uses no loop; former slow one is in the appendix.
\     Takes advantage of /mod and > that also operate term-by-term.

      again 10000 star 0101 plus greg \ Jan 1, YYY
      once rot tic 10000 star 0101 plus greg \ Jan 1, 1+YYY
      other less uniform back +d
      7 those rows one fill /mod drop
      one (Sun) those rows one fill > totals ontop abs
   end

   inline: workdates (YYY --- hD) \ Mon thru Fri workdates in year YYY
{     Returned D holds dates in form yyymmdd.
      The loop over gdate, with its search approach, makes this word 
      slow (about 38 sec per year on 486).  But it needs to be used 
      only once to make a file of dates for many years (as word ydays 
      does below when it is first sourced).
}  
      "ydays" "wfile" yank file? IF ydays return THEN

      yearfix
      again 10000 star 0101 plus greg
      once rot tic 10000 star 0101 plus greg
      other less uniform back +d 
      these 7 those rows one fill /mod drop
      one (Sun) those rows one fill > rake lop push
      list: peek rows 1st DO peek I pry gdate LOOP ;
      pull drop
   end

   inline: workday (YYYMMDD --- yyymmdd) \ next workday after YYYMMDD
{     When work days are Mon through Fri, these are days off that
      follow each day (for example, 2 days off follow Fri):
              Sat Sun Mon Tue Wed Thu Fri
}     [ list:  1   0   0   0   0   0   2 ; are daysoff ]
      again greg tic  
      daysoff rot weekday  
      1st plus, pry plus, gdate
   end

   inline: ydays (YYY --- hD) \ array of mmdd weekdays for year YYY
{     This word will make a date file if it is missing.  Then it links
      to the file and returns weekday dates for YYY whenever it is run.

      This word demonstrates several words for writing and reading bi-
      nary files (see file.v), for working with 2- and 4-byte integers,
      and use of export, import, and endian tag so the file created,
      cal.bin of PDP_ENDIAN type, works on any machine.
}
      [  "fwrite" missing 
         IF " file utilities, file.v, required" . nl halt THEN

         syspath "cal.bin" cat says wfile

         PDP_ENDIAN is wtype \ just for the heck of it

         scalar "wdate" book \ wdate file handle-to-be

         wfile file? not
         IF wfile "wdate" new binary file

            " Initializing date file, 1977 to 2010: " . wfile . nl
            "   Please standby (38 sec per year on 486)..." . nl
            (on 486, this takes about 38 sec per year)

            list:

               list: 110 77 \ 1977 to 2010
                  DO I these workdates
                     its 1st pry 10000 /mod 10000 star lop
                     (yyy) those rows one fill /mod drop (hMMDD)
                     hand wtype export2 wdate fwrite
                  LOOP
                  (YYY ptr len) \ these 3 rows of data per year
               end (hKey)

               \ writing the key:
               (hKey) wtype export4 wdate fwrite (toptr tolen)

            end (hList) \ ptr to key

            (hList) wtype export4
            wdate (hList) fput  \ writing ptr to key
            wtype wdate fendtag \ tag for endian used here
            wdate fclose        \ file closed

         THEN

         \ Open file and get endian type:

         wdate filetrue IF wdate fclose THEN

         wfile "wdate" old binary file, wdate fendget its 0=

         IF " file " wfile ": undefined endian" cat cat . drop halt
         THEN "wtype" book

         \ Fetching the ptr to key and key len in last 8 bytes, less
         \ the length of endian tag:
         wdate again this file.size pry fendlen less, 8 less fseek
         8 fget wtype import4 (hKey)

         wdate that 1st pry (ptr) fseek \ seek to key ptr
         wdate swap 2nd pry (len) fget wtype import4 \ get key bytes

         chain 3 (key rows) fold bend into date.key \ key matrix:
{          1st column holds year to bsearch (YYY=... 98, 99, 100, ...)
           2nd column holds ptr to fseek
           3rd column holds len to fget
}     ]
      yearfix, date.key 1st catch, that (year) bsearch
      IF lop date.key that 2nd fetch (ptr) wdate swap fseek
         date.key swap 3rd fetch (len) wdate swap fget
         wtype import2 chain
      ELSE drop " No year " . .u " in file" . nl
      THEN
   end

   inline: YDM (yyymmdd --- yr day mo) \ split date number into parts  
      this type NUM =
      IF 10000 /mod swap 100 /mod
      ELSE 10000 those rows one fill /mod swap 
         100 those rows one fill /mod
      THEN
   end

\-----------------------------------------------------------------------

\  Time words related to calendar dates.

   inline: CHdiff ( --- nsec) \ sec to add to UTC to get Chicago local
\     Valid only in real time.
      time CHdiff1 ; 

   inline: CHdiff1 (hUTC --- hSEC) \ sec to add to UTC to get Chicago
{     Incoming UTC is machine time in seconds, and returned SEC is
      the number of seconds to add to UTC to obtain local time in
      Chicago, reflecting the time difference between UTC (Greenwich,
      England) and Chicago which varies with standard and daylight
      saving time in Chicago.  Since local clocks in Greenwich are 
      always ahead of the ones in Chicago, returned SEC is always 
      negative.

      The UTC column below is the machine time in Greenwich, England,
      computed from YYYMMDD HHMMSS (using word ltime()); and column
      DT is the number of seconds difference with Chicago.  The two
      columns make lookup table XY used by interpolator lerp().

      In setting up table XY, it is assumed that clocks in Chicago are 
      changed at 2 AM, when it is either five hours (daylight saving 
      time) or six hours (standard time) later in Greenwich.

      Table XY is valid for 2008 and later, but only as future dates 
      are added.  A warning is issued when the date gets within 90 days
      of the latest entry in table XY.

      Before 2008 this word is not valid during daylight saving time
      (about half of the time) and the difference is always -6 hours
      (standard time).

      Example: This shows standard time difference and daylight saving
      time difference for several dates in 2008:

             \ January          June             December
         list: 1080101 0 ltime, 1080601 0 ltime, 1081201 0 ltime end
         CHdiff1 3600 / .i

          Column 1:
              -6     -5     -6
            \ Jan    Jun    Dec
}
      [
        list:
           0                     -6  3600 *
         \       UTC             DT
         \ 2008:
           1080309 075959 ltime  -6  3600 * \ end CST
           1080309 080000 ltime  -5  3600 * \ begin CDT, 2 AM in Chicago
           1081102 065959 ltime  -5  3600 * \ end CDT 
           1081102 070000 ltime  -6  3600 * \ begin CST, 2 AM in Chicago

         \ These need correct March and November days:
         \ 2009:
           1090309 075959 ltime  -6  3600 * \ end CST
           1090309 080000 ltime  -5  3600 * \ begin CDT, 2 AM in Chicago
           1091102 065959 ltime  -5  3600 * \ end CDT 
           1091102 070000 ltime  -6  3600 * \ begin CST, 2 AM in Chicago

         end 2 foldr bend "XY" book
      ]
      dup type push
      XY swap (nX) lerp
      pull NUM = IF @ THEN

    \ Check the last table entry against the time right now:
      XY 1 endmost 1st pry time - 86400 / 0.5 + integer dup 90 <
      IF dup 0>
         IF " CHdiff1: XY table will be invalid in " swap intstr +
            " days" + . nl
         ELSE drop " CHdiff1: XY table is out of date" . nl
         THEN
      ELSE drop
      THEN
   end

   inline: LAdiff ( --- nsec) \ sec to add to UTC to get LA local
\     Valid only in real time.
      time CHdiff1 7200 - ;

\-----------------------------------------------------------------------

\  More calendar.  Interactive date prompter using words defined above.
( 
   Here are some notes on how the program assembles the text for date-
   spinner, showing how brackets [ ... ] and inlines work:

   As soon as creation of datespinner begins with word define:, a be-
   ginning bracket, [, is encountered (following, in this case, certain
   phrases in parentheses ( ) and braces { }, phrases that are ignored).
   This causes processing to jump to a run level above the one that de-
   fine: is running on.  

   This new level in word [ is a clean slate--an empty stage--where 
   once-only tasks for creating the definition are performed.  It is 
   here that text strings and numbers are created and given library
   names that can be referenced later; and fast inline words of phrases
   for the word being defined can be built and tagged to names in the 
   library.   

   In fact, operations at this level are really outside of the defini-
   tion being worked on below it, and involve ordinary phrases that 
   probably have been tried and tested interactively before they were
   placed here.  The only difference is that when an item is placed into
   the library by a phrase running inside word [, it goes into the local
   library of the definition being created in the run level below it,
   not into the main library.

   This word datespinner has two inline words.  The first inline word,
   called "showdate," is a one-line quoted phrase that computes the 
   date, makes its string, and displays it.  Word showdate is used like 
   a function or subroutine in compiled languages, and is run by the
   phrase "showdate run" at three places inside the second inline word,
   called "ds."  

   Within inline word ds--which is all the operational code for date-
   spinner, and is contained in the multi-line text shown between brace-
   quotes, the paired words {" and "}--word showdate is placed after
   tic and nit to update the screen only if a meaningful key has been
   hit to make a new date to show.  This gives the screen a better ap-
   pearance than it has if the line is updated on every key press (which
   one can judge by placing "showdate run" between adjacent words BEGIN
   and getch in the innermost loop and holding down an unused key, like
   the Tab key; little may be noticed on a fast machine).

   When phrases in word [ are have all been read, everything is in date-
   spinner's local library.  This includes inline word showdate, inline
   word ds, and various quote strings like prompt, Need, ok?, and num-
   bers like key character values u, d, k, j, n, and dent, the length to
   indent that reaches the end of the prompt string.
 
   These once-only tasks are complete at the closing bracket, word ],
   where processing drops back to the level of define:, which can fi-
   nally begin its task of assembling the only text it will see--the
   phrase "ds run end."
)
   define: datespinner (YYYMMDD --- yyymmdd) \ interactive date prompter
{     Keys u or k increment (tic); keys d or j decrement (nit); 
      keys Enter or Esc quit.

      This word could be made more useful by adding more keys to quickly
      zero in on any date, for example using keys on either side of j
      and k to bump by weeks or months, and key i--just above k--to jump
      to the date today.  The key layout would look as follows:

                                      [I(today)]           

         [G(-mo)]  [H(-wk)]  [J(-day)]  [K(+day)]  [L(+wk)]  [;(+mo)]

      
}     [ " Spin date (u d Enter): " "prompt" book, prompt strlen is dent

        "ud" its 1st byte into u, 2nd byte into d
        "kj" its 1st byte into k, 2nd byte into j, "n" 1st byte is n

        " Need starting date on stack: YYYMMDD" says Need
        " ok? (n y Enter): " says ok?

        "(g) prompt that (g) gdate, date2$ spaced cat dent reprint (g)" 
        "showdate" inline

        {" Here is the main text of this word: 
          (YYYMMDD) 0 NUM stkok not IF, Need dot return THEN 
          BEGIN out cr spaces dot cr, (YYYMMDD) greg (g) showdate run 
             BEGIN (g) getch, NL that <> over, ESC <> and (g ch f)
             WHILE (g ch)
                u that = over k = or (f)
                IF (ch) drop tic (g++) showdate run 
                ELSE d that = over j = or (f)
                   IF (ch) drop nit (g--) showdate run 
                   ELSE (ch) drop 
                   THEN 
                THEN
             REPEAT (g ch) drop, (g) gdate (yyymmdd) ok? dot 
             getch (ch) n <> (f)
          UNTIL (yyymmdd)
        "} "ds" inline 

      ] ds run (yyymmdd)
   end

   halt

\-----------------------------------------------------------------------

;  Appendix.
 
\  Older version that uses a DO loop; new one is loopless.
  _define: weekdays (YYY --- n) \ number of Mondays thru Fridays in YYY
      [ {"
      its 10000 star 0101 plus greg "d" book, 0 is n
      tic 10000 star 0101 plus greg, d less 1st 
      DO d 7 /mod drop (0,1=Sat,Sun) 1 >
         IF n tic into n THEN d tic into d
      LOOP n 
      "} "weekdays" inlinex ] weekdays
   end

   In this program, these words from Express are compiled native words
   written in C:

  _define: /int (x y --- int[x/y]) \ integer result of x divided by y
      / integer ;

  _define: greg (YYYmmdd --- d) \ days since Gregorian day 0
{     Given YYYmmdd where YYY = yy - 1900, compute Gregorian days
         Equation from an old TI calculator user's manual:
            greg = 365*yy + dd + 31*(mm - 1) + (yy + f)/4
                   - 3*[(yy + f)/100 + 1]/4 - L
         where f = -1 (Jan, Feb), f = 0 (Mar - Dec)
               L =  0 (Jan, Feb), L = (4*mm + 23)/10 (Mar - Dec)
}     19000000 + (yy) 10000 /mod \ assumes YYY is years since 1900
      swap 100 /mod swap (yy mm dd)
      push dup push 3  < over + (yy yy+f) \ f = -1 Jan, Feb, 0 others
      dup 4 /int swap (yy [yy+f]/4 yy)
      100 /int 1+ 3 * 4 /int - swap       \ minus 3*[(yy+f)/100 + 1]/4
      365 * +                             \ plus 365*yy
      31 peek 1- * pull dup 2 >           \ plus 31*(mm-1); mm > Feb?
      IF 4 * 23 + 10 /int -               \ plus leap term
      ELSE drop                           \ no leap term
      THEN pull + +
   end

  _define: searching (u qU kmax --- k) \ k of U(k) with value closest
                                       \ below u
{     For executable function U(k), find k such that U(k) < u < U(k+1)
      U(k) must be a monotonically increasing and non-negative function
      Stack behavior of function U(k) is like a table look-up:
         (k --- u[k])
      Example: 51 "10 *" 300 searching \ U(k) = 10*k; finds U(5)
                                       \ to be closest to 51
}     push into U(k), (u) dup peek (kmax) U(k) execute drop
      (u U[kmax]) < not \ equal or above max?
      IF drop pull return THEN 0 pull 2 /int \ Run binary search loop:
      BEGIN 2dup + U(k) main, 3 pick 2dup =
         IF 2drop + lop true
         ELSE > IF 2 /int
                ELSE dup rot + swap 2 /int 1 max
                THEN dup 0= IF + lop true ELSE false THEN
         THEN
      UNTIL
   end
