/* File telnetd_wrap.c

Dale R. Williamson
August 2005

Adapted from pppoff.c shown in sys/pppcon.v.

This file makes a wrapper program that allows a regular user to start 
the telnetd daemon without having root priviledges.

The telnetd daemon being run is the one installed from file
   usr/telnetd/netkit-telnet-0.17.tgz

See usr/telnet/README for installation and testing of this special 
version of telnetd.

To create the wrapper program, first edit prog below to define the
path/filename of the special telnetd program.  

Then as root, perform the following in this directory:
   # gcc -o telnetd_init telnetd_wrap.c
   # chmod a+x telnetd_init
   # chmod +s telnetd_init
   # mv telnetd_init ../../sys

To start telnetd listening on port 9923, a non-root user can perform:
   % telnetd_init 9923 &
*/

#include <signal.h>
#include <sys/param.h>
#include <pwd.h>
static char *trusted_env[]={"PATH=",0};

int main(int argc, char *argv[])
{
   struct passwd *pwd;
      int i;
      uid_t uid;
   char *port;
   char *prog="/usr/local/netkit-telnet-0.17/telnetd/telnetd";

   for(i=0;i < NSIG;i++) { 
      if(i!= SIGKILL && i!=SIGCHLD) (void) signal(i,SIG_IGN);
   }
   uid=getuid();
   if((pwd = getpwuid(uid))== (struct passwd *)0) exit(1);
   setuid((uid_t)0);
   port=*(argv+1);

   execle(prog,"telnetd","-debug",port,(char *)0,trusted_env);

   setuid(uid);
   exit(1);
}
