\  File myclu.v
\  October 2003

   This file is run by clu.v when creating words for cluster nodes.

\-----------------------------------------------------------------------

   This portion is run when clu.v sets up a real cluster.  Below are
   setups for two clusters.

   My cluster.

   "mach1" host = 
   IF 
    \ Banking data into words loaded when clu.v was sourced.  These
    \ directories must exist on the cluster.
      "msca"              "$node" "NodePrefix"   bank
      "/scratch/s000266/" "$NODE" "UserNodeHome" bank \ dir on node
      "/home/s000266/"    "$HOME" "UserHeadHome" bank \ dir on head

    \ These lines become the #! line for script tserv that will be
    \ run on every node:
      "#!/scratch/s000266/tops/src/tops " \ the program to run
      " -s /scratch/s000266/tops/sys "    \ syspath
      cat "sh_bang" book
   THEN

   "mach2" host = 
   IF 
    \ Banking data into words loaded when clu.v was sourced.  These
    \ directories must exist on the cluster.
      "g"                 "$node" "NodePrefix"   bank
      "/scratch/s000266/" "$NODE" "UserNodeHome" bank \ dir on node
      "/home/s000266/"    "$HOME" "UserHeadHome" bank \ dir on head

    \ These lines become the #! line for script tserv that will be
    \ run on every node:
      "#!/scratch/s000266/tops/src/tops " \ the program to run
      " -s /scratch/s000266/tops/sys "    \ syspath
      cat "sh_bang" book
   THEN

 \ Making a custom version of usr/tserv:

   "sh_bang" exists? 
   IF usrpath "tserv" catpath "Fname" book
      Fname filefound
      IF (qFile) asciiload sh_bang chars +trailing "T" book

         sh_bang T 1st said \ into 1st line

         T Fname save
         "chmod a+x " Fname cat shell

      ELSE " Require file tserv at " . usrpath . nl
           "  with valid #! line for cluster nodes" . nl
      THEN
   THEN
   private halt \ done with setup for cluster

\-----------------------------------------------------------------------

   This portion is run by clu.v Appendix D, Demo network.

   My network.

\  Specializing words $NODE, $HOME, node_name, and $RUN for a particu-
\  lar network and user by banking names into their libraries:

    \ User's home directory on each machine in the network:
         "HOME" env (qS) "$NODE" "UserNodeHome" bank

    \ User's home directory on the head machine:
         "HOME" env (qS) "$HOME" "UserHeadHome" bank

    \ Machines on the network being used for cluster nodes (this list
    \ can include the head node if it is also acting as a node):
         {" 
            clacker
            gutter
#           plunger
            rugger
         "} "#" "" qreplace noblanklines (hT)
         (hT) "node_name" "Names" bank

    \ The script on each machine that runs this program as a server 
    \ (see example file usr/tserv):
         usrpath "tserv" catpath "$RUN" "NodeRun" bank

      private halt

\-----------------------------------------------------------------------

/* Here is a special version of cluster_start for some networked
   machines being run like node servers in a cluster. */

   if(missing("cluster_initialize")) source("clu.v"); # cluster words


/* The version of cluster_start sourced below will override the one 
   just sourced from clu.v.  

   Once these node servers are started, other cluster words work as-is,
   including cluster_connect to connect the servers to the machine that
   is acting as the head node.  

   The head node machine may be one of those named in list MACHINES and
   running as a node server too. */


   function cluster_start(M) { /* special version for dale's machines */
   /* Start M cluster node servers running as daemons.

      Use cluster_connect to tie the head node to the servers.
      Use cluster_close to shut the servers down. */
      {
         debug = no;
         DSERV = usrpath + "dserv1";
         PORT = 9891;
         cmd_tail = " -n " + DSERV + " -port " + intstr(PORT) + " &";
         MACHINES = tpurged(VOL);

         MACHINES = [
            "clacker" ;
            "diego"   ;
            "plunger" ;
            "riggo"   ;
            "rugger"  ;
            "sigma"   ;
         MACHINES];
      }
      cluster_initialize();
      JOBS = tpurged(VOL);

/*    Start your engines. */

      DO((N = min(M, rows(MACHINES))), ndx(1)) 

/*       Append an entry to list JOBS.  Word cluster_connect will
         look at JOBS for MACHINES and PORTs when the network is 
         being connected: */
         JOBS = [JOBS ; spaced(MACHINES[I]) + intstr(PORT)];

         CMD = "rsh " + MACHINES[I] + cmd_tail;
         shell(CMD);

         if(debug) nl(dot(CMD));
      LOOP;

      nl(nl, dot(" cluster_start: " + intstr(N) + " nodes started:"));
      nl(dot(indent(JOBS, 3)));
   }

/*
   This shows running cluster_start with debug=yes, which displays the 
   Unix rsh commands that are run on each machine to start the dserv1 
   daemons listening on port 9891:

      >> cluster_start(INF);    
      rsh clacker -n /opt/mytops/usr/dserv1 -port 9891 &
      rsh diego   -n /opt/mytops/usr/dserv1 -port 9891 &
      rsh plunger -n /opt/mytops/usr/dserv1 -port 9891 &
      rsh riggo   -n /opt/mytops/usr/dserv1 -port 9891 &
      rsh rugger  -n /opt/mytops/usr/dserv1 -port 9891 &
      rsh sigma   -n /opt/mytops/usr/dserv1 -port 9891 &

       cluster_start: 6 nodes started:
         clacker 9891
         diego   9891
         plunger 9891
         riggo   9891
         rugger  9891
         sigma   9891

      >> 
*/
