/* GNU General Public License

Program Tops - a stack-based computing environment
Copyright (C) 1999-2006  Dale R. Williamson

Author: Dale R. Williamson <dale.williamson@prodigy.net>

http://cvs.savannah.nongnu.org/viewcvs/tops/?root=tops
Tops is not affiliated with the GNU Project.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANT-
ABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General
Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software Founda-
tion, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

File: Xclient.js  October 2005
Copyright (C) 2006  D. R. Williamson

------------------------------------------------------------------------

Note from: 
   http://developer.apple.com/internet/webcontent/xmlhttpreq.html

   Table 1 shows the methods supported by Safari 1.2, Mozilla, and 
   Windows IE 5 or later.  

         Table 1. Common XMLHttpRequest Object Methods
      Method                              Description
   abort()                             Stops the current request
   getAllResponseHeaders()             Returns complete set of headers 
                                       (labels and values) as a string 
   getResponseHeader("headerLabel")    Returns the string value of a 
                                       single header label
   open("method", "URL"[, asyncFlag[,  Assigns destination URL, method, 
      "userName"[, "password"]]])      and other optional attributes of 
                                       a pending request
   send(content)                       Transmits the request, optionally
                                       with postable string or DOM 
                                       object data
   setRequestHeader("label", "value")  Assigns a label/value pair to the
                                       header to be sent with a request

------------------------------------------------------------------------

Note from:
   http://www.w3schools.com/dom/dom_http.asp

      Property             Description
   onreadystatechange 	An event handler for an event that fires at 
                        every state change
   readyState           Returns the state of the object:
                           0 = uninitialized
                           1 = loading
                           2 = loaded
                           3 = interactive
                           4 = complete (socket is closed)
   responseText         Returns the response as a string
   responseXML          Returns the response as XML.  This property 
                        returns an XML document object, which can be 
                        examined and parsed using W3C DOM node tree 
                        methods and properties
   status               Returns the status as a number (e.g. 404 for 
                        "Not Found" or 200 for "OK")
   statusText           Returns the status as a string (e.g. "Not 
                        Found" or "OK")

------------------------------------------------------------------------

Colors from: tops/tops/doc/color.txt. 

Conversion of RGB to hex value:

   RGB from color.txt       Value
     0   0   0 Black        #000000
   255   0   0 Red          #FF0000
     0 255 127 SpringGreen  #00FF7F
   255 255   0 Yellow       #FFFF00
     0   0 205 MediumBlue   #0000CD
   255   0 255 Magenta      #FF00FF
     0 255 255 Cyan         #00FFFF
   255 255 255 White        #FFFFFF

Esc code bytes for color:

   Attributes
      00      Reset all attributes
      01      Bright
      02      Dim
      04      Underscore
      05      Blink
      07      Reverse
      08      Hidden
      1B      Reset all attributes
      FF      Reset all attributes

   Colors
      FG  BG  Color
      30  40  Black
      31  41  Red
      32  42  Green
      33  43  Yellow
      34  44  Blue
      35  45  Magenta
      36  46  Cyan
      37  47  White

Some incoming escape codes for m:

   Color codes         Description
   03 6D 32 01 1F      0x1F=31=Red, 01=Bright
   03 6D 32 01 20      0x20=32=Green
   03 6D 32 01 24      0x24=36=Cyan
   03 6D 32 01 22      0x22=34=Blue

   Reset codes         Description
   03 6D 31 FF         0xFF reset 
   03 6D 31 1B         0x1B reset    
   03 6D 30            30='0'=reset    
   
   Example: 03 6D 32 01 1F means:
      03=CSI dispatch, 6D=m, 32=two codes coming, 
      01=attribute bright, 1F=color red

------------------------------------------------------------------------

Functions not used.

function pixabs(e,f) { /* Mouse pointer location in file */
   if(f) {
      if(B==0) return(e.pageY);
      else return(e.clientY+document.body.scrollTop
         - document.body.clientTop);
   }
   else {
      if(B==0) return(e.pageX);
      else return(e.clientX+document.body.scrollLeft
         - document.body.clientLeft);
   }
}

function pixrel(e,f) { /* Mouse pointer location in visible window */
   if(f) return(e.clientY);
   else return(e.clientX);
}

CLIP HERE-------------------------------------------------------------*/
var H="ID"; /* node name on server host */

var B=-1;                  /* browser type (0 moz, 1 ie) */
var BG="#000000;";         /* background color */
var c=0;                   /* cursor column; c==0 is \n or \r */
var CG0="#FA8072;";        /* cursor color (focus on) */
var CG1="#8B4C39;";        /* cursor color (focus off) */
var CHARS=Array();         /* character bytes, 1-255 */
var CLV=0;                 /* CSV level */
var COLS=-1;               /* total cols for scrolling */
var cols=80;               /* display columns */
var CR="";                 /* carriage return byte */
var CSR=null;              /* cursor */
var CSVc=Array(0,0);       /* cursor save c */
var CSVr=Array(0,0);       /* cursor save r */
var FS=1;                  /* focus state */
var FG="#FFFFFF;";         /* foreground color */
var K=0;                   /* XML frame count */
var KBUF=Array();          /* key buffer */
var KMODE=1;               /* key state (0 cooked, 1 raw) */
var Kprv=-1;               /* XML frame count previous */
var LKS=0;                 /* local keyboard state (0 or 1) */
var logged=0;              /* logged state (0, 1 or 2) */
var MDN=0;                 /* mouse button down */
var N=0;                   /* XML text bytes length */
var NL="";                 /* new line byte */
var OK=*ok;                /* XML flag */
var P=0;                   /* XML text pointer */
var R=null;                /* XML receive */
var r=0;                   /* cursor row (browser takes r=0) */
var RATE=5;                /* keyboard chars per second */
var RGN=Array(0,0);        /* range of rows in display region */
var Rmax=100000;             /* XML bytes trigger reconnection */
var ROWS=-1;               /* total rows for scrolling */
var rows=24;               /* display rows */
var S=null;                /* XML send */
var SCR=Array();           /* screen current */
var SCR1=Array();          /* screen 1, scrolling */
var SCR2=Array();          /* screen 2, full */
var STTS=null;             /* text in browser status bar */

function abort() { /* Abort connection */
   if(CSR) CSR.style.visibility="hidden";
   window.onblur=window.onfocus=null;
   window.onkeypress=null;

   if(logged==0) window.status="Host "+H+" login failed";

   if(R.readyState==4) {
      logged=2;
      return;
   }
   if(SCR.childNodes)
      emit("Invalid server response, connection will close\n",0);
   R=0;
   send("R","A");
   logged=2;
}     
   
function bks() { /* Keyboard backspace and erase */
   c--; 
   emit(" ",0);
   c--; 
   emit("",0); 
}

function chr(k) { /* Return a character byte, 0x01-0xFF */
   if(k<1 || k>0xFF) return(k);
   return(CHARS.slice(k-1,k));
}

/*          Black       Red         Green       Yellow */
var COLORS=["#000000;", "#FF0000;", "#00FF7F;", "#FFFF00;",
/*          Blue        Magenta     Cyan        White */
            "#0000CD;", "#FF00FF;", "#00FFFF;", "#FFFFFF;"];

function color(A,C) { /* Set color */
   switch(A) {

      default:
      case 0xFF:
      case 0: /* reset all attributes */
      //   SCR.style.backgroundColor=BG;
      //   SCR.style.color=FG;
      //   SCR.style.visibility="visible";
      return;      
                    
      case 1: /* bright */
      case 2: /* dim */
      case 4: /* underscore */
      case 5: /* blink */
      break;

      case 7: /* reverse */
      return;      

      case 8: /* hidden */
         SCR.style.visibility="hidden";
      break;
   }
   if(!C) return;

   var c=C%10;
   if((C-c)/10==3) ; //SCR.style.color=COLORS[c];
   else ; //SCR.style.backgroundColor=COLORS[c];
}

function connect() { /* Connect to server */
   document.body.setAttribute("style","background-color:"+BG);
   window.open();

   if(window.XMLHttpRequest) B=0;
   if(window.ActiveXObject ) B=1;
   if(B==-1) {
      alert("This browser needs a function to connect to the server");
      return(false);
   }
   window.onblur=focus0;
   window.onclick=mouseclk;
   window.onerror=erp;
   window.onfocus=focus1;
   window.onkeypress=keydn;
   window.onmousedown=mousedn;
   window.onmousemove=mousemv;
   window.onmouseup=mouseup;

   size(0);

   STTS="Connecting to host "+H;
   window.defaultStatus=STTS;

   if(B==0) return(send("R","CM")); else return(send("R","CI"));
}

function cp() { /* Copy highlighted selection */
   if(window.getSelection) var s=window.getSelection();
   else {
      if(document.selection && document.selection.createRange) {
         var r=document.selection.createRange();
         var s=r.text;
      }
      else s="";
   }
   return(String(s));
}

var CF=0;    /* cursor-fixed state (0, 1 or 2)*/
var CV=1;    /* cursor visible */
var lfcnt=0; /* new line count */

function csr() { /* Show cursor */
   if(c==0 || CF==1 || CV==0) return;

   if(!SCR.childNodes) return;

   var C=null;
   if(!(C=SCR.childNodes[r])) var ch="";
   else var ch=C.data.slice(c,1+c);

   if(FS) var CG=CG0;
   else var CG=CG1;

   CSR.style.backgroundColor=CG;

   if(!ch.length || (ch.length==1 && ch<=chr(0x20))) {
      ch="_";
      CSR.style.color=CG;
   }
   else {
      if(FS) CSR.style.color=BG;
      else CSR.style.color=FG;
   }
   CSR.style.top=PY*(r-1)+"px";
   CSR.style.left=PX*c+"px";
   C=CSR.childNodes[0];
   CSR.replaceChild(document.createTextNode(ch),C);
   CV=1;
}

function csrclr() { /* Clear cursor */
   if(CF==1 || CV==0) return;

   var C=null;
   if(!(C=SCR.childNodes[r])) return;

   var ch=C.data.slice(c,1+c);
   if(ch>chr(0x20)) return;

   CSR.style.backgroundColor=BG;
   CSR.style.color=BG;

   CSR.style.top=PY*(r-1)+"px";
   CSR.style.left=PX*c+"px";
   C=CSR.childNodes[0];
   CSR.replaceChild(document.createTextNode(ch),C);
}

function csrinv() { /* Cursor invisible */
   if(CV && logged) {
      csr();
      CSR.style.backgroundColor=BG;
      CSR.style.color=BG;
      CSR.style.top=PY*(r-1)+"px";
      CSR.style.left=PX*c+"px";
      var C=CSR.childNodes[0];
      CSR.replaceChild(document.createTextNode("_"),C);
      CV=0;
   }
}

function csrlf(d) { /* Cursor while scrolling */
   if(lfcnt%(rows*2)==0) {
      window.scrollTo(0,PY*(r+d));
      if(SCR && d) {
         var L=NL;
         SCR.appendChild(document.createTextNode(L));
         if(LKS) {
            var rsav=r;
            var csav=c;
            r++;
            c=1;
            csr();
            r=rsav;
            c=csav;
         }
      }
      lfcnt=0;
   }
   lfcnt++;
}

function emit(Ch,f) { /* Characters to screen */
   if(CF==1) return;

   if(r>1) var L=NL;
   else var L=CR;

   var C=SCR.childNodes[r];

   if(C) {
      L+=C.data.slice(1,c)+Ch;

      if(f && C.length>c+Ch.length) {
         L+=C.data.slice(c+Ch.length,C.length);
         c+=Ch.length;
      }
      else c=L.length;

      SCR.replaceChild(document.createTextNode(L),C);
   }
   else {
      L+=Ch;
      c=L.length;
      SCR.appendChild(document.createTextNode(L));
   }
   if(LKS) csr();
   setsb(0);
}

function erase(arg,val) { /* Erase regions of screen */
   var C=null;
   var L=null;

   switch(arg) {

      case 'J': /* ED: erase in display */
         KMODE=1;

         var csav=c;
         var rsav=r;

         switch(val) {

            default:
            case 0: /* erase cursor to end of display */
               emit(" ",0);
               c=csav;

               C=null;
               for(r=rsav+1;r<RGN[1]+1;r++) {
                  if((C=SCR.childNodes[r])) SCR.removeChild(C);
               }
               r=rsav;
            break;

            case 1: /* erase beginning of display to cursor */
               /* TBD */
               emit("J case 1: need to erase top to cursor ",0);
            break;

            case 2: /* erase entire region */
               C=null;
               for(r=RGN[0];r<RGN[1]+1;r++) {
                  if((C=SCR.childNodes[r])) SCR.removeChild(C);
               }
               r=RGN[0];
               c=0;
            return;
         }
         c=csav;
         r=rsav;
      break;

      case 'K': /* EL: erase in line */

         C=SCR.childNodes[r];

         switch(val) {

            default:
            case 0: /* erase cursor to end of line */
               var csav=c;
               emit(" ",0);
               c=csav;
            break;

            case 1: /* erase cursor to start of line */
               var csav=c;
               L="";
               for(var i=0;i<c;i++) L+=" ";
               emit(L,1);
               c=csav;
            break;

            case 2: /* erase entire line */
               c=1;
               emit(" ",0);
               c=1;
            break;

         }
      break;
   }
}

var nerp=0;
var maxerr=3;

function erp(msg,url,line) { /* Error report */
   if(nerp>maxerr) return(true);

   alert(" error report: " + msg + "\n" + url + "\nline: " + line);
   nerp++;
   return(true);
}

function focus0(e) { /* Cursor out of focus */
   if(FS==1) {
      FS=0;
      var cf=CF;
      CF=0;
      csr();
      CF=cf;
   }
   return(true);
}

function focus1(e) { /* Cursor in focus */
   if(FS==0) {
      FS=1;
      var cf=CF;
      CF=0;
      csr();
      CF=cf;
   }
   return(true);
}

function frame(X) { /* Return frame from server */
   if(K==Kprv) {
      emit("frame error.  K: "+K+", last known key code: "+k+" ",0);
      reconnect();
      K=1;
      Kprv=0;
      return(0);
   }
   var E=X.lastIndexOf("</f"+K+">");

   if(E<0) {
      if(R.readyState==4) abort();
      return(0);
   }
   var F="<f"+K+">";
   Kprv=K;
   return(X.slice((X.indexOf(F)+F.length),E));
}

function init() { /* Initialize screens */
   CSR=document.createElement("pre"); /* cursor */
   CSR.setAttribute("style",
      "font-family:Fixed;"+
      "font-size:"+PY+"px;"+
      "background-color:"+CG0+
      "color:"+BG+
      "position:absolute;");
   document.body.appendChild(CSR);
   CSR.appendChild(document.createTextNode(""));

   SCR1=document.createElement("pre"); /* screen 1 */
   SCR1.setAttribute("style",
      "font-family:Fixed;"+
      "font-size:"+PY+"px;"+
      "background-color:"+BG+
      "color:"+FG);
   document.body.appendChild(SCR1);
   SCR1.appendChild(document.createTextNode(""));

   SCR2=document.createElement("pre"); /* screen 2 */
   SCR2.setAttribute("style",
      "font-family:Fixed;"+
      "font-size:"+PY+"px;"+
      "background-color:"+BG+
      "color:"+FG);
   document.body.appendChild(SCR2);

   screen(1);

   r=1; /* browser takes row r=0 */
   RGN[0]=r;
   RGN[1]=(r+rows-1);

   CLV=0;
   CSVc[CLV]=c;
   CSVr[CLV]=r;

   if(B==0) { /* browser-specific data */
      dSBX=1;
      dSBY=2;
   }
   else {
      dSBX=1;
      dSBY=2;
   }
   window.setInterval("tasker()",1000/(10*RATE));
}

var BUF=Array(); /* keyboard text buffer */
var nBUF=0;
var TBUF=Array(); /* send text buffer */

function keyboard(k) { /* Key from keyboard */
   TBUF=0;

   if(logged && KMODE) return(0);

   if(k>0x1F) var cse=-1;
   else var cse=k;

   switch(cse) {

      case -1: /* ascii char */
         var ch=chr(k);
         emit(ch,1);
         BUF+=ch;
         nBUF++;
         if(c<cols-1) return(1);

         TBUF=str(BUF,nBUF);
         c-=nBUF;
         BUF="";
         nBUF=0;
         KMODE=1;
         return(0);
      break;

      case 0x07: /* bell */
         return(1);
      break;

      case 0x08: /* backspace and erase endmost char */
         if(nBUF) {
            bks();
            nBUF--;
            var tmp=BUF;
            BUF=""; 
            for(var i=0;i<nBUF;i++) BUF+=tmp[i];
            return(1);
         }
         return(keyboard(0x07));
      break;

      case 0x09: /* tab */
         KMODE=1;
         if(nBUF==0) return(0);

         BUF+=chr(k);
         TBUF=str(BUF,(nBUF+1));
         c-=nBUF;
         BUF="";
         nBUF=0;

         return(0);
      break;

      case 0x0D: /* linefeed */
         if(nBUF==0) return(lfempty());

         BUF+=chr(k);
         TBUF=str(BUF,(nBUF+1));
         c-=nBUF;
         BUF="";
         nBUF=0;

         lfcnt=0;
         csrlf(1);
         region(r+1);

         if(!logged && CF==0) CF=1;
         return(0);
      break;

      case 0x1B: /* Esc */
         KMODE=1;
         BUF+=chr(k);
         TBUF=str(BUF,nBUF+1);
         c-=nBUF;
         BUF="";
         nBUF=0;

         return(0);
      break;

      default:
      break;
   }
   return(0);
}

function keydn(ev) { /* Queue a pressed key */
   var e=ev || window.event;

   if(e.stopPropagation) {
      e.preventDefault();
      e.stopPropagation();
   }
   if(logged==2) return(false);
   if(CF==2) return(true);

   if(B==0) {
      var key=e.keyCode;
      if(!key) key=e.which;
   }
   else var key=e.keyCode;

   return(queue(key));
}

function lfempty() { /* Keyboard linefeed on empty line */
   if(!logged) return(0);
   if(!(SCR==SCR1)) return(0);

   var C=0;
   if(!(C=SCR.childNodes[r])) return(0);

   csrclr(); /* blank csr */

   var L=C.data.slice(0,c); 
   var lks=LKS;
   LKS=0;

/* Scroll up with blank line: */
   linefeed();
   emit(" ",0); /* lets scrollBy() work */
   window.scrollBy(0,PY);

/* Replace blank line with prompt and cursor of line above: */
   C=SCR.childNodes[r];
   SCR.replaceChild(document.createTextNode(L),C);
   c=L.length;

   scrollend();

   LKS=lks;
   return(1);
}

function linefeed() { /* Linefeed display */
   if(SCR==2 && r==RGN[1]) { 
      var C=null;
      var L=null;
      if(RGN[0]==0) {
         C=SCR.childNodes[1];
         L=CR+C.data.slice(1,C.length);
         C=SCR.childNodes[0];
         SCR.replaceChild(document.createTextNode(L),C);
         r=1;
      }
      else r=RGN[0];

      for(;r<RGN[1];r++) {
         C=SCR.childNodes[r+1];
         L=NL+C.data.slice(1,C.length);
         C=SCR.childNodes[r];
         SCR.replaceChild(document.createTextNode(L),C);
      }
      r=RGN[1];
      L=NL;
      C=SCR.childNodes[r];
      SCR.replaceChild(document.createTextNode(L),C);
   }
   else {
      r++;
      setsb(1); /* r changed */
      region(r);
      emit("",1); /* 0x0A needs this */
   }
}

var CBUF=Array(); /* mouse copy buffer */

function mouseclk(ev) { /* Mouse click */
   if(!(logged==1)) return(true);

   var e=ev || window.event;
   if(e.stopPropagation) {
      e.preventDefault();
      e.stopPropagation();
   }
   MDN=0;
   return(true);
}

function mousedn(ev) { /* Mouse button down */
   MDN=0;
   if(!(logged==1)) return(true);

   var e=ev || window.event;

   if(B==0) var b=e.which-1;
   else var b=e.button;

   var ret=0;

   switch(b) {

      case 0: /* left button */
         MDN=1;
         CBUF=new Array();
      break

      case 1: /* middle button */
         if(CBUF && CBUF.length) { 
            ON=0;
            TASK=1;

            var ksav=KMODE;
            KMODE=0;

            for(var i=0;i<CBUF.length;i++) {
               var ch=CBUF.charCodeAt(i);
               queue(ch);
               select();
            }
            csr();

            KMODE=ksav;
            if(KMODE) {
               TBUF=str(BUF,nBUF);
               c-=nBUF;
               BUF="";
               nBUF=0;
               if(TBUF) send("S",TBUF);
            }
            if(CBUF.charCodeAt(CBUF.length-1)==0x20) {
               queue(0x0D);
               select();
            }
            ON=1;
            TASK=0;
         }
         MDN=0;
         ret=1;
      break;

      default:
      case 2: /* right button */
      break;
   }
   if(ret) {
      if(e.stopPropagation) {
         e.preventDefault();
         e.stopPropagation();
      }
   }
   return(ret);
}

function mousemv(ev) { /* Mouse button moving */
   if(!(logged==1)) return(true);
   return(false);
}

function mouseup(ev) { /* Mouse button up */
   if(!(logged==1)) return(true);

   var e=ev || window.event;
   if(e.stopPropagation) {
      e.preventDefault();
      e.stopPropagation();
   }
   if(MDN) { 
      CBUF=cp();
      MDN=0;
   }
   return(true);
}

var delta=2;
var eps=0.01;
var maxloops=10;

function newton(f,y) { /* Newton's method */
   var loops=0;
   var Y=y; /* goal */

   if(f) var x=rsize; else var x=csize; /* initial value */

   var y1=resize(f,x)-Y;

   while(Math.abs(y1)>eps && loops<maxloops) {
      var y2=resize(f,x+delta)-Y;
      var s=(y2-y1)/delta;
      x-=y1/s; /* next value */
      y1=resize(f,x)-Y;
      loops++;
   }
   return(x);
}

var dSBX=0;
var dSBY=0;

function onX() { /* Flag for mouse pointer down on horiz scroll bar */
   return(SBX && (yd>(rscr-SBR*PY-dSBY)));
}

function onY() { /* Flag for mouse pointer down on vert scroll bar */
   return(SBY && (xd>(cscr-SBC*PX-dSBX)));
}

var c0=-1;
var cprev=2*c0;
var kprev=-1;
var onrow=-2;

function queue(key) { /* Queue a key */

   if(!(r==onrow)) {
      onrow=r; /* new row */
      c0=c;    /* empty line (c0=size of prompt) */
   }
   var ret=0;

   switch(key) {

      case 0x08: 
         if(c==c0) ret=1; /* bks on empty line */
      break;

      case 0x0D: 
         if(!logged) break;

         if(kprev==0x0D && cprev==c0 && /* prev LF on empty line */
            c==c0 &&                    /* LF on empty line */
            r==(ROWS-1)) {              /* LF on last line */
            if(lfempty()) {

               KMODE=0;
               ret=1;
            }
         }
      break;

      case 0x1B: 
         if(kprev==0x1B) ret=1; /* ignore duplicate Esc */
      break;

      default:
         if(kprev==0x0D && cprev==c0 && /* prev LF on empty line */
            r==(ROWS-1)) KMODE=0;       /* this key is on last line */
      break;
   }
   kprev=key;
   cprev=c;
   if(ret) return(true);

   KBUF.push(key);

   while(KBUF.length>1) {
      key=KBUF.shift();
   }
   return(true);
}

function reconnect() { /* Make new permanent connection with server */
   if(!(logged==1)) return;

   K=0;
   Kprv=-1;
   send("R","R");
}

function region(row) { /* Region of rows showing in window */
   RGN[1]=Math.max(RGN[1],row);
   RGN[0]=(RGN[1]-rows+1);
}

var busy=0;

function resize(f,N) { /* Resize X or Y to N, return window size */
   if(f) window.resizeTo(csize,N); /* Y to N */
   else window.resizeTo(N,rsize);  /* X to N */
   busy++;
   return(winsize(f));
}

function screen(n) { /* Set up screen n */
   switch(n) {

      case 1: /* scrolling screen */
         if(SCR==SCR1) return;

         KMODE=0;

         document.body.removeChild(SCR2);
         SCR2.style.visibility="hidden";

         SCR1.style.visibility="visible";
         document.body.appendChild(SCR1);
         SCR=SCR1;
      return;

      case 2: /* full screen */
         if(SCR==SCR2) return;

         KMODE=1;

         document.body.removeChild(SCR1);
         SCR1.style.visibility="hidden";

         document.body.appendChild(SCR2);
         SCR2.style.visibility="visible";
         SCR=SCR2;
      return;
   }
}

function scrollend() { /* Scroll to endmost row */
   csrclr(); /* blank csr */

   var C=null;
   var i=1;
   while(C=SCR.childNodes[ROWS+i]) {
      SCR.removeChild(C);
      i++;
   }
   if(i>1) {
      if(SBX) window.scrollTo(0,PY*(ROWS-(rows+rpad-SBR)+1));
      else window.scrollTo(0,PY*(ROWS-(rows+rpad)+1));
   }
   else window.scrollTo(0,PY*ROWS);

   csr();
}

function select() { /* Select input */
   switch(TASK) {

      case 0: /* server */
         if(R.status!=OK) {
            abort();
            return;
         }
         if(R.readyState<3) return;

         var T=null;

         if((T=frame(String(R.responseText)))) {

            N=T.length;
            P=0;

            while(P<N) terminal(T);

            scrollend();

            K++;
            select();
         }
         return;
      break;

      case 1: /* keyboard */
         if(!KBUF.length) return;

         key=KBUF.shift();

         LKS=1;
         if(keyboard(key)) return;
         LKS=0;

         if(key==0x0D && R.responseText && R.responseText.length>Rmax)
            reconnect();

         if(TBUF) send("S",TBUF);
         else {
            if(key==0x0D) {
               lfcnt=0;
               csrlf(1);
               region(r+1);
            }
            send("S","K"+key);
         }
         return;
      break;
   }
}

function send(s,D) { /* Send D to server */
   if(s=="R") {
      if(B==0) R=new XMLHttpRequest();
      else R=new ActiveXObject("Microsoft.XMLHTTP");

      R.onreadystatechange=select;
      R.open(D,H,true);
      R.send(0);

      return(true);
   }
   else {
      if(B==0) S=new XMLHttpRequest();
      else S=new ActiveXObject("Microsoft.XMLHTTP");

      S.onreadystatechange=select;
      S.open(D,H,true);
      S.send(0);

      return(true);
   }
}

var cmax_prev=-1;  /* previous max COLS */
var rcmax=-1;      /* row of max COLS */
var rcmax_prev=-1; /* row of previous max COLS */
var SBX=0;         /* true if horizontal scroll bar is present */
var SBY=0;         /* true if vertical scroll bar is present */

function setsb(f) { /* Set scroll bar flag */
   if(f) { /* r changed */
      cmax_prev=COLS;
      rcmax_prev=rcmax;

      ROWS=Math.max(r+1,ROWS);
      if(SBY) return;

      var T=SBY;
      setY();
      if(!(SBY==T)) setX();
   }
   else { /* c changed */
      var T=SBX;
      setX();
      if(SBY) return;
      if(!(SBX==T)) setY();
   }
}

function setX() { /* Set horizontal scroll bar flag */
   if(r==rcmax && (c+1)<COLS) {
      var Ctest=cmax_prev;
      rcmax=rcmax_prev;
   }
   else var Ctest=COLS;

   COLS=Math.max(c+1,Ctest);
   if(COLS>Ctest) rcmax=r;

   if(SBY && (COLS>(cols+cpad-SBC))) SBX=1;
   else {
      if(COLS>(cols+cpad)) SBX=1;
   }
}

function setY() { /* Set vertical scroll bar flag */
   if(SBX && (ROWS>(rows-1))) SBY=1;
   else {
      if(ROWS>(rows+rpad-1)) SBY=1;
   }
}

var PX=7;       /* column pixels per character */
var PY=14;      /* font and row pixels per character */

/* Window is defined by character rows and cols */

var CMIN=40;    /* cols minimum in window */
var SBC=2;      /* cols taken by vertical scroll bar */
var SBR=1;      /* rows taken by horizontal scroll bar */

var cpad=2+SBC; /* cols pad */
var cscr=0;     /* col pixels in resized screen */
var csize=0;    /* col pixels resize initial */
var hpix=0;     /* horizontal pixels browser fixed pad (guess) */
var rpad=2+SBR; /* rows pad */
var rscr=0;     /* row pixels in resized screen */
var rsize=0;    /* row pixels resize initial */
var vpix=110;   /* vertical pixels browser fixed pad (guess) */

function size(f) { /* Change window size to rows by cols */
   if(f==0) {
      busy=0;

      rscr=(rows+rpad)*PY; /* new screen row pixels */
      cscr=(cols+cpad)*PX; /* new screen col pixels */

      rsize=rscr+vpix; /* initial window row resize pixels */
      csize=cscr+hpix; /* initial window col resize pixels */

      var rwin=newton(1,rscr); /* final window row resize pixels */
      var cwin=newton(0,cscr); /* final window col resize pixels */

      window.resizeTo(cwin,rwin); /* resize window */

      send("S","S"+rows+":"+cols); /* inform server */

      vpix=rwin-rscr;
      hpix=cwin-cscr;

      SBX=0; 
      SBY=0; 
      setsb(0);
      setsb(1);

      return(true);
   }
   else {
      if(busy) {
         busy--;
         if(busy) return(true);
      }
      var d=(winsize(1)-rscr)/PY;
      if(d<0) rows-=Math.round(Math.abs(d)); 
      else rows+=Math.round(Math.abs(d)); 

      var d=(winsize(0)-cscr)/PX;
      if(d<0) cols-=Math.round(Math.abs(d)); 
      else cols+=Math.round(Math.abs(d)); 

      cols=Math.max(cols,CMIN);

      return(size(0));
   }
}

function str(bytes,n) { /* Make byte string for server */
   if(n<0x10) return("T000"+n.toString(16)+bytes);
   else {
      if(n<0x100) return("T00"+n.toString(16)+bytes);
      else {
         if(n<0x1000) return("T0"+n.toString(16)+bytes);
         else return("T"+n.toString(16)+bytes);
      }
   }
}

var ON=1;
var TASK=0; /* 0=server, 1=keyboard */

function tasker() { /* Run keyboard select on timeout */
   if(ON) {
      TASK=1;
      select();
      TASK=0;
   }
}

function terminal(T) { /* Run the terminal for input T */
   if(!N) {
      P=N;
      return;
   }
   var arg=0;
   var C=null;
   var i=0;
   var L=null;
   var len=0;
   var n=0;
   var val=0;

   switch(T.charCodeAt(P)) {

      case 0x03: /* CSI dispatch */
         arg=T.charAt(P+1);

         switch(arg) {

            default:
            break;

            case '@': /* ICH: insert characters */
               n=T.charCodeAt(P+2);
               L="";
               for(i=0;i<n;i++) L+="X";
               C=SCR.childNodes[r];
               L+=C.data.slice(c,C.length);
               n=c;
               emit(L,1);
               c=n;
            break;

            case 'C': /* CUF: cursor forward */
               C=SCR.childNodes[r];
               n=c+T.charCodeAt(P+2);
               while(c<n) {
                  L=C.length-1; /* C[0]=\n and does not count */
                  if(c<L) c++;
                  else emit(" ",0);
               }
            break;

            case 'H': /* CUP: cursor position (1-based) */
               KMODE=1;
               len=parseInt(T.charAt(P+2));
               if(len) {
                  r=RGN[0]+T.charCodeAt(P+3)-1; /* r is 1-based */
                  n=T.charCodeAt(P+4);
                  C=SCR.childNodes[r];
                  c=1;
                  while(c<n) {
                     L=C.length-1; /* C[0]=\n and does not count */
                     if(c<L) c++;
                     else {
                        emit(" ",0);
                        C=SCR.childNodes[r];
                     }
                  }
               }
               else {
                  r=RGN[0];
                  c=1;
               }
            break;

            case 'h': /* cursor normal */
               val=T.charCodeAt(P+2);
               if(val==25) CSR.style.visibility="visible";
            break;

            case 'J': /* ED: erase in display */
            case 'K': /* EL: erase in line */
               erase(arg,parseInt(T.charAt(P+2)));
            break;

            case 'l': /* cursor invisible */
               val=T.charCodeAt(P+2);
            break;

            case 'm': /* SGR: select graphic rendition */
               len=parseInt(T.charAt(P+2));

               switch(len) {

                  default:
                  case 0:
                     color(0,0);
                  break;

                  case 1:
                     color(parseInt(T.charCodeAt(P+3)),0);
                  break;
                  
                  case 2:
                     color(parseInt(T.charCodeAt(P+3)),
                        parseInt(T.charCodeAt(P+4)));
                  break;
               }
            break;

            case 'P': /* DCH: delete characters */
               val=T.charCodeAt(P+2);
               C=SCR.childNodes[r];
               L=C.data.slice(1,c)+C.data.slice(c+val,C.length);

               var csav=c;
               c=1;
               emit(L,0);
               c=csav;
            break;

            case 'r': /* cs: region is RGN[0] to RGN[1] */
               len=parseInt(T.charAt(P+2));
               if(len) {
                  //screen(2);
                  RGN[0]=(T.charCodeAt(P+3));
                  RGN[1]=(T.charCodeAt(P+4));
                  erase('J',2);
               }
            break;
         } 
         P+=(len+3);
      break;

      case 0x04: /* Esc dispatch */

         switch(T.charAt(P+1)) {

            default:
            break;

            case '=': /* numeric keypad responds with ESC seq */
            break;

            case '>': /* numeric keypad responds with digits */
            break;

            case '7': /* sc: save cursor; switch to full screen */
               CLV++;
               CSVr[CLV]=r;
               CSVc[CLV]=c;

               KMODE=1;
               screen(2);
            break;

            case '8': /* rc: restore cursor; switch to scroll screen */
               r=CSVr[CLV];
               c=CSVc[CLV];
               CLV--;

               KMODE=0;
               screen(1);
            break;

            case 'M': /* RI: reverse index (reversed linefeed) */
               var csav=c;
               var rsav=r;
               for(r=RGN[1];r>rsav;r--) {
                  C=SCR.childNodes[r-1];
                  L=NL+C.data.slice(1,C.length);
                  emit(L,1);
                 // SCR.replaceChild(document.createTextNode(L),C);
               }
               c=csav;
               r=rsav;
            break;
         }
         P+=2;
      break;

      case 0x05: /* Execute */

         switch(T.charCodeAt(P+1)) {

            default:
            break;

            case 0x07: /* bell */
            break;

            case 0x08: /* backspace */
               c--; 
               setsb();
            break;

            case 0x09: /* tab */
               emit(chr(0x09),1);
            break;

            case 0x0A: /* linefeed */
               if(CF) {
                  if(logged==0 && CF==1) CF=2;
                  if(CF==1) CF=0;
                  lfcnt=0;
               }
               linefeed();
               csrlf(0);
               csr();
            break;

            case 0x0D: /* carriage return */
               c=1;
            break;

            case 0x14: /* server got 00 from tty */
/*
               linefeed();
               csrlf(0);
               csr();
*/
               KMODE=1;
            break;
         }
         P+=2;
      break;

      case 0x0C: /* display counted string */
         len=T.charCodeAt(P+1);
         emit(T.slice(P+2,P+2+len),1);
         P+=(2+len);
      break;

      case 0x0F: /* incoming from server */

         switch(T.charCodeAt(P+1)) {

            case 0x01: /* receive user prompt */
               logged=1;
               CF=0;
               KMODE=0;

               busy=0;
               window.onresize=size;

               len=T.charCodeAt(P+2);
               STTS="Host "+T.slice(P+3,P+3+len);
               window.defaultStatus=STTS;

               window.setInterval("tasker()",1000/RATE);

               P+=(1+len);
            break;

            case 0x02: /* initialize */
               len=T.charCodeAt(P+2);
               CHARS=T.slice(P+3,P+3+len); /* receive constants */

               CR=chr(0x0D);
               NL=chr(0x0A);
               init();

               P+=(1+len);
            break;

            case 0x03: /* receive password prompt */
               csr();
               CF=1;
            break;

            case 0x04: /* receive login prompt */
               STTS="Host "+H+" login";
               window.defaultStatus=STTS;

               logged=0;
               CF=0;
            break;

            default:
            case 0x86: /* logged out */
               RGN[0]=0;
               RGN[1]=r;
               erase('J',2);

               screen(2);
               RGN[0]=0;
               RGN[1]=rows;
               erase('J',2);

               csrinv();
               window.status="Connection closed";
               window.scrollTo(0,0);
               logged=2;
            break;
         }
         P+=2;
      break;

      default:
         P=N;
      break;
   }
   return;
}

function winsize(f) { /* Return window height or width */
   if(f) {
      if(B==0) return(window.innerHeight);
      else return(document.body.scrollHeight);
   }
   else {
      if(B==0) return(window.innerWidth);
      else return(document.body.scrollWidth);
   }
}
