\ {{{1 GNU General Public License
{
Program Tops - a stack-based computing environment
Copyright (C) 1999-2005  Dale R. Williamson

Author: Dale R. Williamson <dale.williamson@prodigy.net>

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software Foundation,
Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
1}}} 
}

\ File sam.v  June 2001


\  A work in progress.  Samples of words and structures.


      list: 
         {" \ Narrative, any size:
            This is a description of
            Model XY blah blah
            blah blah ...
         "} left justify 3 indent notrailing into desc1, "desc1" ptr

      end "xwidgets" book


list:
     10
         {" \ Narrative, any size:
            This is a description of
            Model XY blah blah
            blah blah ...
         "} left justify 3 indent notrailing into desc, "desc" ptr
   20
end

  private halt

\-----------------------------------------------------------------------

   Using words to provide handles to submatrices as needed. 

   Load this sample by running:

      "sam.v" "Submatrices from words, I." msource

   and then copy and drop the phrases given below following word halt.

   And feel free to edit the words, perhaps by putting word return in
   various places to have them stop at an intermediate point.  Just run
   again the phrase above to remake them the way you want.

   Submatrices from words, I.

\  Saying K11, M11, K22 or M22 results in a submatrix handle on the
\  stack.  But K11 and the others are not names of matrices stored in 
\  the catalog.

\  Instead they are words that fetch submatrices from very large ma-
\  trices stored in a binary file.

\  Here is a useful new word that should be added to the get4X family 
\  of words:

   inline: get4sub (hFile qS hCols hRows --- hA) \ get submatrix A
\     From op4 File, from matrix named S, getting submatrix A.
      push other rewind
      get4c pull reach 
      "_Asub" naming ;

\  Next word submodels is defined to list the dofs that comprise models
\  1 and 2, and the handle to the file where they reside.

\  Note that word submodels is run only once to store the file handle.

\  After that, other words like K11 simply use its library as a well, 
\  to extract information they need.

   inline: submodels (hFile --- )
      [ \ Model 1: 
             list: 1 6 thru, 101 130 thru, 24 36 thru ; are Model1_dofs
             "KGG" is K_Model1_parent
             "MGG" is M_Model1_parent
        \ Model 2: 
             list: 201 339 thru, 7 12 thru ; makes Model2_dofs
             "KGG" is K_Model2_parent
             "MGG" is M_Model2_parent
      ] "mfile" book
   end

   inline: K11 ( --- K11) \ stiffness matrix of model 1
      "submodels" "mfile"           extract (hFile)
      "submodels" "K_Model1_parent" extract (qS)
      "submodels" "Model1_dofs"     extract dup (hCols hRows)
      get4sub "_K11" naming
   end 

   inline: M11 ( --- M11) \ mass matrix of model 1
      "submodels" "mfile" yank (hFile)
      "submodels" "M_Model1_parent" yank (qS)
      "submodels" "Model1_dofs" yank again (hCols hRows)
      get4sub "_M11" naming
   end

   inline: K22 ( --- K22) \ stiffness matrix of model 2
      "submodels" "mfile" yank (hFile)
      "submodels" "K_Model2_parent" yank (qS)
      "submodels" "Model2_dofs" yank these (hCols hRows)
      get4sub "_K22" naming
   end

   inline: M22 ( --- M22) \ mass matrix of model 2
      "submodels" "mfile" yank (hFile)
      "submodels" "M_Model2_parent" yank (qS)
      "submodels" "Model2_dofs" yank dup (hCols hRows)
      get4sub "_M22" naming
   end

\  Making a file for testing these words:

   "BIG.op4" missing
   IF " Making big output4 file..." . nl

      "" "BIG.op4" op4file \ runs word file and makes handle called op4
      1000 1000 random "KGG" naming op4 put4
      1000 1000 random "MGG" naming op4 put4
      op4 fclose

   THEN
   "big" closeif

   " See sam.v to step through the rest of this example." . nl

   private halt

\  -   -   -   -   -   -   -   -   -   -   -   -   -   -   -   -   -   -

Copy and drop phrases below that follow the ready prompt shown.

Making a handle called big that uses the file made above, and giving it
to word submodels:

[tops@gutter] ready > "BIG.op4" old binary "big" file, big submodels

Now submatrices can be fetched for any purpose; here they are:

[tops@gutter] ready > K11 M11, M22 K22

 stack elements:
       0 matrix: _K22  145 by 145
       1 matrix: _M22  145 by 145
       2 matrix: _M11  49 by 49
       3 matrix: _K11  49 by 49
 [4] ok!
[tops@gutter] ready > 

We can look at the dofs for model 1 by extracting them from word sub-
models, just like word K11 does:

[tops@gutter] ready > "submodels" "Model1_dofs" extract .i
 Column 1:
      1      2      3      4      5      6    101    102    103    104
    105    106    107    108    109    110    111    112    113    114
    115    116    117    118    119    120    121    122    123    124
    125    126    127    128    129    130     24     25     26     27
     28     29     30     31     32     33     34     35     36
[tops@gutter] ready > 

End of Submatrices from words, I.

\-----------------------------------------------------------------------

   Using words to provide handles to submatrices as needed, and showing
   use of bank and yank.

   Load this sample by running:

      "sam.v" "Submatrices from words, II." msource

   and then copy and drop the phrases given below following word halt.

   And feel free to edit the words, perhaps by putting word return in
   various places to have them stop at an intermediate point.  Just run
   again the phrase above to remake them the way you want. 

   Submatrices from words, II.

   inline: Kaa ( --- hKaa) \ stiffness matrix from KGG for set called a
      [ no is MAT, no is BIGFILE, no are DOFs ]
      BIGFILE any? not 
      IF " Kaa: need handle to BIGFILE" ersys return THEN (BIGFILE) drop
      MAT any? not
      IF " Kaa: need name of MAT defined" ersys return THEN (MAT) drop
      DOFs any? not
      IF " Kaa: need list of DOFs defined" ersys return THEN (DOFs) drop

      BIGFILE dup rewind
      MAT DOFs get4c
      DOFs reach "_Kaa" naming
   end

\  In Kaa, as is usually the case, making sure things are valid takes 
\  more code (talking) than doing the actual work, which is done in the
\  last three lines.  

\  Word Maa written next cheats by using all of Kaa's code just by bank-
\  ing the name of the matrix it wants to draw from, MGG.  But it is 
\  careful to put everything back the way it was.

\  In Maa, the name of current MAT in Kaa (whatever it may be) is yanked
\  and sits on the stack, then MAT is overridden in Kaa by MGG.  After 
\  Maa is obtained, the name saved on the stack is banked back into MAT.

   inline: Maa ( --- hMaa) \ mass matrix from MGG for set called a
      "Kaa" "MAT" yank (oldMAT)
      "MGG" "Kaa" "MAT" bank

      Kaa (hMaa) "_Maa" naming

      swap (oldMAT) "Kaa" "MAT" bank
   end

\  Making a file for testing these words:

   "BIG.op4" missing
   IF " Making big output4 file..." . nl

      "" "BIG.op4" op4file \ runs word file and makes handle called op4
      1000 1000 random "KGG" naming op4 put4
      1000 1000 random "MGG" naming op4 put4
      op4 fclose

   THEN
   "big" closeif

   " See sam.v to step through the rest of this example." . nl

   private halt

\  -   -   -   -   -   -   -   -   -   -   -   -   -   -   -   -   -   -

Copy and drop phrases below that follow the ready prompt shown.

Saying Kaa will provide submatrix Kaa.  

[tops@gutter] ready > Kaa
 Kaa: need handle to BIGFILE

But first a handle to BIGFILE needs to be defined, and it needs to be
banked into the local library of Kaa.

Make a handle called big that uses the file made above, and bank it:

[tops@gutter] ready > "BIG.op4" old binary "big" file 
[tops@gutter] ready > big "Kaa" "BIGFILE" bank
[tops@gutter] ready > Kaa
 Kaa: need name of MAT defined

Need the name of MAT that Kaa is partitioned from.  It is KGG created 
above, and it needs to be banked as MAT in Kaa:

[tops@gutter] ready > "KGG" "Kaa" "MAT" bank
[tops@gutter] ready > Kaa
 Kaa: need list of DOFs defined

Need the list of the DOFs that are Kaa's; assume 101 thru 255 and bank
the list in word Kaa's local library:

[tops@gutter] ready > list: 101 255 thru ; (hList) "Kaa" "DOFs" bank

Now things are ready.

[tops@gutter] ready > Kaa Maa

 stack elements:
       0 matrix: _Maa  155 by 155
       1 matrix: _Kaa  155 by 155
 [2] ok!
[tops@gutter] ready > 

Here are matrices Maa and Kaa, ready to use, perhaps to send to a word
for eigenanalysis.  There may never be a need to store them in the cat-
alog.

It is instructive to run the last three lines in Kaa to see what they
do, step by step (comments can help a lot, but do not equal actually
doing it).  The lines are:
      BIGFILE dup rewind
      MAT DOFs get4c
      DOFs reach "_Kaa" naming

But if you say BIGFILE at the ready prompt, it is undefined, because 
from main (where you are working) the local library of Kaa cannot be 
seen:

[tops@gutter] ready > BIGFILE
 undefined word in source
 fault at word: BIGFILE
 faulty phrase: BIGFILE [Enter]

Word yank (or extract) can be used to get at them.  Here is running the
ast three lines of Kaa from outside, at the ready prompt, substituting 
phrase
   "Kaa" "XXX" yank
where needed to get item XXX from Kaa's local library:

[tops@gutter] ready > "Kaa" "BIGFILE" yank

 stack elements:
       0 matrix: BIGFILE  9 by 1
 [1] ok!

Taking a moment to look at properties of BIGFILE:

[tops@gutter] ready > dup fprops
 Properties of file handle BIGFILE
    Handle: 84B90D8
    Type: binary
    Status: old
    Mode: read/write
    Size: 16040112 bytes
    Random access head: none
    Random access size: none
    Current byte position: 16040112

 stack elements:
       0 matrix: BIGFILE  9 by 1
 [1] ok!

Now rewinding it (per the phrase in Kaa) and checking properties again:

[tops@gutter] ready > dup rewind, dup fprops
 Properties of file handle BIGFILE
    Handle: 84B90D8
    Type: binary
    Status: old
    Mode: read/write
    Size: 16040112 bytes
    Random access head: none
    Random access size: none
    Current byte position: 0

 stack elements:
       0 matrix: BIGFILE  9 by 1
 [1] ok!

Current byte position 0 shows it is rewound.  Run phrase MAT DOFs next:

[tops@gutter] ready > "Kaa" "MAT" yank, "Kaa" "DOFs" yank

 stack elements:
       0 matrix: DOFs  155 by 1
       1 string: KGG  3 characters
       2 matrix: BIGFILE  9 by 1
 [3] ok!

Now the stack is ready to run word get4c:

[tops@gutter] ready > get4c  

 stack elements:
       0 matrix: _KGG  1000 by 155
 [1] ok!
[tops@gutter] ready > "Kaa" "DOFs" yank 

 stack elements:
       0 matrix: DOFs  155 by 1
       1 matrix: _KGG  1000 by 155
 [2] ok!
[tops@gutter] ready > reach

 stack elements:
       0 matrix: _reach  155 by 155
 [1] ok!
[tops@gutter] ready > "_Kaa" naming

 stack elements:
       0 matrix: _Kaa  155 by 155
 [1] ok!
[tops@gutter] ready > 

Running step by step shows that get4c gets just the 155 columns that
contain Kaa from the matrix on the file, and then reach reaches the 
155 rows needed to complete submatrix Kaa.

Word public could have been used to make the local library of Kaa be
the main library.  Then BIGFILE, MAT and DOFs would have been visible 
and yank used above would have been unnecessary.  

It is handy to use public for testing a word and getting it to work, 
so all the variables are easy to see in the main library.  But once it 
works the benefits of keeping a word's library local are great.

Word private ensures that words created have their own local, hidden
libraries. 

And being private allows a word to use local names for things that may 
conflict with words that are seen in main.

Words public and private are said outside words before they are defined.


End of Submatrices from words, II.

\-----------------------------------------------------------------------

   Using struct, ptr and exe to define arrays of handles to matrices.

   Load this sample by running:

      "sam.v" "Using struct, ptr and exe." msource

   and then copy and drop the phrases given below following word halt.

   And feel free to edit the words, perhaps by putting word return in
   various places to have them stop at an intermediate point.  Just run
   again the phrase above to remake them the way you want.

   Using struct, ptr and exe.

   "K11" missing \ using some elements from this example:
   IF "sam.v" "Submatrices from words, I." msource 
      "BIG.op4" old binary "big" file, big submodels
   THEN

   define: eigSSL (hK hM --- hFreq hPhi) \ dummy eigenanalysis word
      drop rows dup 1 (r 1) random "_Freq" naming
      swap dup (r r) random "_Phi" naming
   end
 
   define: transform1 (hM hPhi --- h[Phi'*M*Phi]) \ dummy transform word
      lop cols dup random \ square mat the size of Phi cols
   end

\  Widget bodies, stiffness and mass.

      "part" "name desc K_hitch M_hitch K_door M_door" struct 

      list: \ items in "part" struct:

         "Model XY" str2num (num)           \ 8 char name in num

         {" \ Narrative, any size:
            This is a description of
            Model XY blah blah
            blah blah ...
         "} chop 3 indent noblanklines into desc, "desc" ptr


         "K11" ptr (ptrK11)                 \ ptr to f(mat K_hitch)
         "M11" ptr (ptrM11)                 \ ptr to f(mat M_hitch)

         K22 1st 20 items dup submat matptr \ mat K_door
         M22 1st 20 items dup submat matptr \ mat M_door

         (name K_hitch M_hitch K_door M_door)

      end "widgets" book


\  Widget bodies eigenanalysis.

      "modes" "F_hitch Phi_hitch F_door Phi_door" struct 

      list: 
         widgets part.K_hitch pryexe   
         widgets part.M_hitch pryexe (hK hM) eigSSL (hFreq hPhi) 
  
         widgets part.K_door pryexe   
         widgets part.M_door pryexe (hK hM) eigSSL (hFreq hPhi) 

         (F_hitch Phi_hitch F_door Phi_door)

      end "modal" book

\  Widget modal kinetic energy.

   define: energy (hStruct_widgets hStruct_eig --- hKE1 hKE2 ... )
      "struct_modal" book
      "struct_widgets" book
      " Analysis of " struct_widgets part.name pry num2str cat . nl
      struct_widgets part.desc pryexe . nl

      struct_widgets rows 3rd
      DO struct_widgets I pryexe (hMass)
         struct_modal I 2 - pryexe (hPhi)
   end

   private halt
      
      
      

End of Using struct, ptr and exe.
\-----------------------------------------------------------------------
