\ {{{1 GNU General Public License
{
Program Tops - a stack-based computing environment
Copyright (C) 1999-2005  Dale R. Williamson

Author: Dale R. Williamson <dale.williamson@prodigy.net>

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software Foundation,
Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
1}}} 
}

{ File math.v  July 1999

   Copyright (c) 1999   D. R. Williamson

   Notes: 

   In C, multiplying 0 by a negative number sets the sign bit, giving 
   -0, as these lines show:

      On big endian machine (aix), sign bit is leftmost:
[tops@bach] ready > 0 -1 * .bin
 10000000 00000000 00000000 00000000 00000000 00000000 00000000 00000000

      On little endian machine (linux), sign bit is 57th:
[tops@gutter] ready > 0 -1 * .bin
 00000000 00000000 00000000 00000000 00000000 00000000 00000000 10000000

      But relational tests in C, such as 0==, must not look at the sign
      bit because this says -0 is equal to 0:
[tops@gutter] ready > 0, 0 -1 * = .i
 -1 (-1 is true, saying -0 equals 0)

      Function display() in tex.c has been tweaked to display -0 as
      0.  But other words, like .m using a C format, will show -0.
}
\-----------------------------------------------------------------------

   CATMSG push no catmsg

   define: .totals (hV --- ) \ display totals of true and false in V
      hand these rows bob, totals abs ontop
      " Heads: " . dup int$ . "  Tails: " . - int$ . nl ;

   inline: bins1 ( hV hb --- hB) \ vector V items into b bins 
{     The first column of returned B contains bin interval beginning
      value, and the second column of B is the number of items it
      contains.

      Examples:

      (1) Expect about 20% of the values (200 of them) to lie outside 
          the two bins from -.4 to 0 and 0 to +.4:

          1000 1 random 0.5 -d \ randoms -.5 to +.5
          list: -INF -.4 0 +.4 INF ; bins1 nl .m

      (2) Expect about 1000 in each of 10 uniform bins:

          10000 1 random .1 10 uniform bins1 nl .m
}
      yes sort "b" book "A" book

      b 1st those rows items park (hXY) A look
      yes sort INF pile, dup sling \ need INF so sling gets endmost
      swap over rake lop "N" book  \ N is list of bin indices

      1st those rows items swap rake lop 
      no swap pile delta 

      2nd those rows nit items reach (hC)    \ items in bins not empty
      b rows those rows less those cols null \ null mat for empty bins
      (hC hCempty) N b rows teeth tier (hC)

      b swap park (hB)
   end

   inline: changes (hA --- hA') \ nonzero changes in quantized A
\     Example:
\        list: 1 1 1 5 5 5 3 3 3 -1 -1 ; dup changes park .m
      delta these 0<> looking ;

   inline: expspace (x1 x2 n --- hX) \ uniform exponential spacing
{     Example: spacings for 25 cm (10 in.) slide rule:
         0 25 9 expspace "  %5.2f" format .
      Also see logspace.
}     tic push no peek ln two listn, rev two listn
      park one pull items ln lerp ;
   
   inline: flatten (hV --- hV1)  \ flatten curve V
{     Best for quantized data; see also plateaus and valleys
      Example: 
         list: 1 1 1.1 2 2 1.5  2 2.1 3 3 ; dup flatten park .m
}     its delta 0= looking ; 

   define: flips (n --- hF) \ true-and-false vector of n coin flips
      (n) one random, -0.5 +d, sign bit ; \ grabbing sign bits

   inline: logspace (x1 x2 n --- hX) \ n uniform log spaces, x1 to x2
\     Example: 1 10000 8 logspace "  %8.2f" format . (see expspace)
      push, swap ln, swap ln, pull intervals e^ ;

   define: ma1 (hA n --- hB) \ n sample moving average, lagged 1 step
      push one lag pull ma ;

   inline: _nearest (hX x --- x1) \ fetch x1 from X nearest to x
\     Incoming X is a vector of numbers in ascending order.
      says x again, x bsearch trash
      2dup pry (x1) push, tic those rows ndx min pry (x2)
      pull (x2 x1) two listn again x two repeat less abs minfetch
      (hX min row col) drop lop (hX row) pry
   end

   inline: nearest (hX x --- x1) \ fetch x1 from X nearest to x
\     Incoming X is a vector of numbers in ascending order; x is a 
\     column vector or a number.
      hand into x, into X
      list: x rows 1st DO X x I pry _nearest LOOP end
   end

   inline: newt (ptrFx x1 --- x) \ root x where Fx[x]=0
{     Approximation of root x using Newton's method.
      ptrFx is the ptr to a word that computes y=F[x]:
            Fx (x --- y).

      Reference: Sokolnikoff, I. S., and R. M. Redheffer,
         "Mathematics of Physics and Modern Engineering,"
         McGraw-Hill, 1958.

      begin man newt
      \ Finding the peak of a parabola by finding where the derivative 
      \ is zero.

         X11 not IF " X11 graphics required" . halt THEN

         "newt" missing IF "math.v" source THEN

         \ Function for newt that returns the derivative of parabola:
         inline: Fx (x --- f[x]) \ slope of a parabola at x
         \  Using a difference equation for the derivative rather than
         \  closed form derivative:
         \     g[x] = B + A*(x - C)^2 (parabola)
         \     f[x] = (g[x+dx] - g[x])/dx (difference equation)

            [ -100 is A, 1e4 is B, 10 is C, 0.1 is dx

              \ Function Gx is the parabola:
              "(x) C - dup star, A star, B plus (g[x])" "Gx" inlinex

            ] dup dx plus Gx, swap Gx less dx slash
         end 

         \ Displaying the parabola and its derivative:
         list: 40 -40 DO I "Fx" "Gx" localrun LOOP ; \ parabola (B)
         list: 40 -40 DO I Fx LOOP ;                 \ derivative (G)
         list: 40 -40 DO 0 LOOP ; 3 parkn            \ line at 0 (R)
         list: 40 -40 DO I LOOP ; plot 
         " Root is where green derivative curve crosses red zero-line" 
         dot nl "Fx" ptr -100 newt " Root: " . .
         pause plotclose
      end man newt

         \ Running newt for a couple of starting locations:
         "Fx" ptr -100 newt
         " Root: " . . " in " . "newt" "count" yank .u " iterations" .

         "Fx" ptr 1000 newt
         " Root: " . . " in " . "newt" "count" yank .u " iterations" .

         \ Result for both starting locations:
         Root:  9.9500E+00 in 2 iterations
}
      [ 1e-4 "delta" book, 1e-4 "eps" book, 1e-6 "teensy" book
        10 is loops
      ]
      "x" book, "Fx" book

      no is failed, zero is count
      BEGIN
         x Fx exe dup "y" book abs eps >
         failed not and
         count loops < and (f)
      WHILE
         x delta plus Fx exe y less \ f(x+delta) - f(x)
         delta slash (slope)    \ slope = [f(x+delta) - f(x)]/delta

         dup (slope) abs teensy >
         IF x y rot slash less "x" book \ next x is x - y/slope
         ELSE drop                                                                  " newt: slope is zero, can't continue" . nl yes is failed
         THEN

         one count bump
      REPEAT
      count loops >= IF " newt: failed to converge" . nl THEN
      x (root)
   end
      
   inline: plateaus (hV --- hV1) \ flat peaks of V
      [ 1e-12 is tiny ] flatten, -INF that 1st reach park bob,
      1st those rows items again push that park bob,
      delta tiny greater rake trash pile pull look ;

   inline: quantize (hV hA --- hA1) \ quantize cols of A to nearest in V
{     Levels in V are unsigned, but signs in A are retained
      Example:
           0.5 10 uniform (hV), " Level every 0.5:" . nl dup .m nl
           list: -1.1 1.3 -1.6 ; list: 2.2 2.9 3.1 ; park (hA)
           dup nl .m quantize nl nl .m
}
\     This version quantizes to nearest:
      dup sign bit push abs "A" book
      abs yes sort "V" book
      A cols 1st DO V A I catch nearest LOOP A cols parkn
      pull (-1, 0) this plus one +d (-1, 1)
      *by, freed is A, freed is V

\     Here is old version; it quantizes to floors, always lower, since
\     word look always returns equal-to or nearest-below:

\inline: quantize (hV hA --- hA1) \ quantize cols of A to floors in V
\      dup sign bit push abs, swap abs, right sort those cows,
\      tic clone back look, pull this plus one, +d *by ;

   end

   inline: stepped (Y X --- Y X) \ Y versus X into stepped form
      dup rows 3 < IF return THEN
      dup  2nd over rows 1- items reach pile 
      swap dup 1 lag 2nd over rows 1- items reach pile
      park yes sort
      1 over cols 1- 1 null pile claw
   end

   inline: stepped1 (hY hX nDX --- hY1 hX1)
{     Show a step in Y data when the interval between successive
      X values (period between X(i) and X(i+1)) is longer than DX.

      Points in X are assumed to be in ascending order, such as
      times in a function Y(X).

      Purpose: for displaying data collected at discrete times, when 
      Y(i) is the last known value until Y(i+1) is later known.  
      A plot of the real time collection process would show Y stepping 
      from Y(i) to Y(i+1) at X(i+1).

      Add new points X(k)=X(i+1)-eps between X(i) and X(i+1),
      where eps = DX * 0.001.

      Add new points Y(k)=Y(i) between Y(i) and Y(i+1).
}
      "DX" book
      (hX) dup 1 endmost 1+ pile \ append an extra point to X

      (hX) dup "X" book
      (hX) delta DX < "F" book

      (hY) dup 1 endmost pile "Y" book \ append an extra point to Y

    \ Added X are at a tiny distance in front of (before) the X(i+1):
      X F rake drop DX 0.001 * - X pile (hX1) 

      Y F -1 lag rake drop Y pile (hY1)

      (hX1 hY1) park yes sort (hA)
      1st over rows 1- items reach \ remove the appended extra point

      (hA) dup 2nd over cols 1- items catch (hY1)
      (hY1 hA) swap (hA) 1st catch (hX1)

      purged "F" book purged "X" book purged "Y" book
   end

   inline: sticks (hY hX --- hY1 hX1) \ 0-to-Y verticals at X
\     Makes Y and X into triplets Y1 and X1:
\        Y1:  0 Yi  0   0  Yj  0   0 Yk  0   ...
\        X1: Xi Xi Xi  Xj  Xj Xj  Xk Xk Xk   ...

      [ list: 0 1 ; makes apart ]
      park yes 2nd sorton, apart claw

      no hand those rows three star, three spikes pile
      1st them rows three star items reach (hRake) push

      swap (hY) peek rows, those rows less, those cols null (hY0)
      swap (hY0 hY) pull tier
      swap (hX) three repeat yes sort
   end

   inline: valleys (hV --- hV1) \ flat valleys of V
      negate plateaus negate ;

   pull catmsg halt

\-----------------------------------------------------------------------

;  Appendix.

   Words replaced by native functions:

  _inline: *diagonal (hA hD --- hA1) \ A1 = A*D, diag D is stored as vec
\     For large square matrices, this is many times faster than the 
\     equivalent phrase >square *.
      hand bend swap hand swap over cols (hD r) repeat *by ;
*diagonal (hA hD --- hA1) multiply square matrix A by matrix D, a diagonal square matrix stored as a column
*diagonal note: note that matrix A must be square
*diagonal related: diagpre, diagpost

   -stkbal \ for one push, branch IF gives two pulls: turn off bal check
   _inline: looking (hV hR --- hV1) \ looking at V(k) when R(k) is true
{     Where R(k) equals 0, set V1(k)=V(j) coinciding with closest
      previous R(j) not equal to 0 (or true), j < k.

      This word forces R(1st)=true.  Otherwise, in real time simula-
      tions past data can receive future values.

      Note: the convention for R is opposite the one for word looking
      in express.
}
      (hR) true over 1st poke
      1st over rows items too push
      rot park back rake lop
      any?
      IF pull look, ELSE pull rows left empty THEN
   end
   stkbal

  _inline: skyline (hA --- hA1) \ A1 is flat at all peaks of A columns
{     Peaks in columns of A are where:
         the value is greater than the previous
         the value is greater than or equal to the next
         and both of these are true.
} 
      dup push cols 1st
      DO peek I catch again
         this one lag >
         that this -1 lag >=
         and looking
      LOOP
      pull cols parkn
   end

  _inline: stats (hC --- hC1) \ C1 holds min, ave, max over cols of C
\     C1 holds min, ave and max taken over the cols of C
      dup bend mean, swap dup min1 1st catch
      rot rot max1 1st catch three parkn
      "_stats" naming
   end

   Words that manipulate things term-by-term should be written in C.
   The following word, tr, is very slow compared to its C counterpart;
   and the C version is much easier to read:

      [tops@gutter] ready > 3000 1 null 1000 +d dup dup 3 parkn is S
      [tops@gutter] ready > time S 3 tr time rot - .i
       10 <<<< took 10 seconds for 3000x3 matrix
      Running the C version, takes 0 seconds

  _inline: tr (hSig n --- hTr) \ exponential trace of signal, Sig
\     Tr(k) = Tr(k-1) + [Sig(k) - Tr(k-1)]/(n+1)
\     Tr(0)=Sig(0)
      xbase push 0based
      "n" book, "Sig" book
      one n tic slash "1/n+1" book
      Sig cols 1st
      DO
         list: 
            Sig 1st I fetch, Sig rows 2nd
            ?DO dup Sig I J fetch over less 1/n+1 star plus LOOP                 end
      LOOP Sig cols parkn
      freed is Sig pull indexbase
   end



