/*
  Top 10, a racing simulator
  Copyright (C) 2003,2005,2006  Johann Deneux
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  
  Authors can be contacted at following electronic addresses:
  Johann Deneux: johann.deneux@gmail.com
*/

#include <string>
#include <algorithm>

namespace top10 {
namespace util {
  
template<class T>
class FindValue
{
public:
  FindValue(const T& value): value(value) {}
  template<class T2>
    bool operator()(const T2& other) const { return value == other; }
private:
  T value;
};

class FindNamed
{
public:
  FindNamed(const std::string& name): name(name) {}
  template<class T>
    bool operator()(const T& other) const { return other.name == name; }
private:
  std::string name;
};

class Find_M_Named
{
public:
  Find_M_Named(const std::string& name): name(name) {}
  template<class T>
    bool operator()(const T& other) const { return other.m_name == name; }
private:
  std::string name;
};

class Find1Named
{
public:
  Find1Named(const std::string& name): name(name) {}
  template<class T>
    bool operator()(const T& other) const { return other.first == name; }
private:
  std::string name;
};

class FindById
{
public:
  FindById(int id): id(id) {}
  template<class T>
    bool operator()(const T& other) const { return other.id == id; }
private:
  int id;
};

}
}
