/*
  Top 10, a racing simulator
  Copyright (C) 2003,2005,2006  Johann Deneux
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  
  Authors can be contacted at following electronic addresses:
  Johann Deneux: johann.deneux@gmail.com
*/
#ifndef TOP10_UTILXMLRESPCHAIN_HH
#define TOP10_UTILXMLRESPCHAIN_HH

#include "ResponsibilityChain.hh"
#include "XmlDumpable.hh"

namespace top10 {
namespace util {

class XmlAccessor {
public:
  static inline bool handles(const XmlDumpable* d, const TiXmlElement* n) { return d->handles(n); }
  static inline int handle(XmlDumpable* d, const TiXmlElement* n) { return d->load(n); }
};
  
class XmlRespChain: public top10::util::ResponsibilityChain< XmlDumpable*, XmlAccessor >
{
public:
  XmlRespChain(): top10::util::ResponsibilityChain< XmlDumpable*, XmlAccessor >( XmlAccessor() ) {}
};

}
}

#endif
