/*
  Top 10, a racing simulator
  Copyright (C) 2003,2005,2006  Johann Deneux
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  
  Authors can be contacted at following electronic addresses:
  Johann Deneux: johann.deneux@gmail.com
*/
#include "XmlDumpable.hh"
#include "strconv.hh"

namespace top10 {
namespace util {

XmlDumpable::XmlDumpable(std::string node_name): node_name(node_name)
{
}

XmlDumpable::~XmlDumpable()
{
}

bool XmlDumpable::handles(const TiXmlElement* node) const
{
  return node->Value() == node_name;
}

int XmlDumpable::load(const TiXmlElement* node)
{
  if (!handles(node)) return -1;
  return loadXml(node);
}

int XmlDumpable::save(TiXmlElement* node) const
{
  node->SetValue(node_name);
  return saveXml(node);
}

void XmlDumpable::logUnexpectedSection(std::string expected, const TiXmlElement* xml_node) const
{
  Log::getSingle()->send(Log::Error, "XmlDumpable/"+node_name, std::string("Expected "+expected+", got ")+xml_node->Value()+
      " on line "+top10::util::toString(xml_node->Row())+
      " column "+top10::util::toString(xml_node->Column()));
}
      
void XmlDumpable::logXmlNodeError(std::string err, const TiXmlElement* xml_node, top10::util::Log::Level level) const
{
  Log::getSingle()->send(level, "XmlDumpable/"+node_name, err +
      " line "+top10::util::toString(xml_node->Row())+
      " column "+top10::util::toString(xml_node->Column()));
}

void logXmlNodeError(std::string err, const TiXmlElement* xml_node, top10::util::Log::Level level)
{
  Log::getSingle()->send(level, "loadXml/", err +
      " line "+top10::util::toString(xml_node->Row())+
      " column "+top10::util::toString(xml_node->Column()));
}


SaveInserterFunction::SaveInserterFunction(TiXmlElement* top):
  m_top(top)
{
}

void SaveInserterFunction::operator()(const top10::util::XmlDumpable& item)
{
  TiXmlElement node("");
  item.save(&node);
  m_top->InsertEndChild(node);
}

}
}
