/*
  Top10, a racing simulator
  Copyright (C) 2000-2004  Johann Deneux
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  
  Authors can be contacted at following electronic addresses:
  Johann Deneux: johann.deneux@it.uu.se
*/

#include "UserFile.hh"
#include <cstdlib>
#include <sys/types.h>
#include <sys/stat.h>
#ifndef WIN32
#include <unistd.h>
#endif

using top10::util::UserFile;

void UserFile::reallyMakePath(std::string user_path)
{
  struct stat buf;
  std::string path = getPath() + "/" + user_path;
  // Remove the trailing '/' if necessary
  if (path[path.size()-1] == '/') path = path.substr(0, path.size()-1);

  if (stat(path.c_str(), &buf) != 0) {
#if defined(HAVE_MKDIR) && !defined(WIN32)
    if (mkdir(path.c_str(), 0700) != 0)
      throw std::string("Could not create directory: ")+path;

#elif defined(WIN32)
    std::string cmd("md ");
    cmd = cmd + "\"" + path + "\"";
    system(cmd.c_str());
    if (stat(path.c_str(), &buf) != 0)
      throw std::string("Could not create directory: ")+path;

#else
    throw std::string("Do not know how to create: ")+path;

#endif
  }
}

void UserFile::makePath(std::string user_path)
{
  // Create all directories down to the final one.
  std::string path;
  std::string::size_type idx(0), idx2;
  do {
    idx2 = user_path.find_first_of("/\\", idx);
    if (idx2 != std::string::npos) {
      path += "/" + user_path.substr(idx, idx2-idx);
      reallyMakePath(path);
      idx = idx2 +1;
    }
  } while (idx2 != std::string::npos);
  path += user_path.substr(idx, user_path.size()-idx);
  reallyMakePath(path);
}

void UserFile::makePath()
{
  makePath("");
}

std::string UserFile::getPath(const char* fname)
{
  std::string app;
  if (fname)
    app = fname;

#ifdef WIN32
  if (fname)
    app = "\\" + app;

  const char* envstr = getenv("APPDATA");
  if (envstr)
    return std::string(envstr)+"\\top10"+app;
  else if (envstr=getenv("USERPROFILE"))
    return std::string(envstr)+"\\top10_user"+app;
  else
    return std::string("user_data")+app;
#else
  if (fname)
    app = "/" + app;
  const char* envstr = getenv("HOME");
  if (envstr) return std::string(envstr)+"/.top10"+app;

#endif

  throw std::string("Can't find user's directory");
}
