/*
  Top 10, a racing simulator
  Copyright (C) 2003,2005  Johann Deneux
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  
  Authors can be contacted at following electronic addresses:
  Johann Deneux: johann.deneux@it.uu.se
*/

#ifndef TOP10_UTILSTORE_HH
#define TOP10_UTILSTORE_HH

#include <map>

namespace top10 {
namespace util {

template<typename T, typename T_Order>
class Store {
public:
  int get(T* inst) {
    typename std::map<T*, int, T_Order>::const_iterator it = inst2id.find(inst);
    if (it != inst2id.end()) return it->second;
    else {
      int new_idx = id2inst.size();
      id2inst[new_idx] = inst;
      inst2id[inst] = new_idx;
      return new_idx;
    }
  }
  
  T* get(int id) {
    typename std::map<int, T*>::const_iterator it = id2inst.find(id);
    if (it != id2inst.end()) return it->second;
    return 0;
  }
  
private:
  std::map<int, T*> id2inst;
  std::map<T*, int, T_Order> inst2id;
};

}
}

#endif
