/*
  Top10, a racing simulator
  Copyright (C) 2000-2007  Johann Deneux
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  
  Authors can be contacted at following electronic addresses:
  Johann Deneux: johann.deneux@gmail.com
*/
#ifndef TOP10_SLOWTIME_HH
#define TOP10_SLOWTIME_HH

#include <SDL/SDL.h>

namespace top10 {
  namespace util {
    //! Timer able to "slow down" time
    class SlowTime {
    public:
      SlowTime();

      //! Set slow down factor (if >1.0, otherwise it's a speed-up)
      /*! If sf is 0.0, time is stopped. */
      void setSlowFactor(double sf);
      inline double getSlowFactor() const { return slow_factor; }

      Uint32 getTicks();

    private:
      Uint32 last_t;
      double last_ret;
      double slow_factor;
      bool first;
    };

    extern SlowTime global_time;
  };
};

#endif
