#include "SlowTime.hh"

using namespace top10::util;

SlowTime top10::util::global_time;

SlowTime::SlowTime(): last_t(0), last_ret(0.0), slow_factor(1.0), first(true)
{
}

void SlowTime::setSlowFactor(double sf)
{
  getTicks(); // To update last_t and last_ret
  slow_factor = sf;
}

Uint32 SlowTime::getTicks()
{
  Uint32 t = SDL_GetTicks();

  if (first) {
    first = false;
    last_t = t;
    last_ret = t;
    return t;
  }
  else {
    double ret;
    if (slow_factor != 0.0)
      ret = last_ret + (t-last_t) / slow_factor;
    else
      ret = last_ret;
    last_t = t;
    last_ret = ret;
    return Uint32(ret);
  }
}
