/*
  Top 10, a racing simulator
  Copyright (C) 2003,2005  Johann Deneux
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  
  Authors can be contacted at following electronic addresses:
  Johann Deneux: johann.deneux@it.uu.se
*/

#ifndef TOP10_UTILLOG_HH
#define TOP10_UTILLOG_HH

#include "RefCount.hh"
#include <vector>
#include <iostream>
#include <string>
#include <sstream>

#if 0
#ifndef NDEBUG

#ifdef assert
#undef assert
#endif

#define assert(condition)\
do { bool b1 = (condition); bool b2 = (condition);\
     if (b1 != b2) { std::cerr<<"Side-effect in assert at "<<__FILE__<<":"<<__LINE__<<std::endl; abort(); }\
     if (!b1) {\
      std::ostringstream buf; \
      buf<<"assertion "<<#condition<<" failed at "<<__FILE__<<":"<<__LINE__;\
      top10::util::Log::getSingle()->send(top10::util::Log::Critical, "/assert", buf.str());\
      abort();\
    }\
  } while (0)

#endif
#endif

namespace top10 {
namespace util {

//! Receives messages, save them and dispatch them
class Log {
public:
  enum Level { Info, Error, Warning, Critical, Debug };

  //! Pure virtual class for message receivers
  class Receiver: public top10::util::RefCount {
    public:
      virtual void receive(Log::Level, std::string origin, std::string msg) =0;
      virtual ~Receiver() {}
  };
  
public:
  Log(const char* log_file_name = "log.txt");
  ~Log();
  
  //! Log and dispatch a message 
  void send(Level, std::string origin, std::string msg);
  
  //! Add a receiver
  void addReceiver(Receiver*);
  
  //! Get or create a Log
  static Log* getSingle(const char* log_file_name="log.txt");
  
private:
  typedef std::vector< Ref<Receiver> > ReceiverRefs;

  inline std::ostream& out() { if (log_stream) return *log_stream; else return std::cerr; }
  
  std::ostream* log_stream;
  ReceiverRefs receivers;
      
  static Log* singleton;
};

}
}

#endif
