/*
  Top 10, a racing simulator
  Copyright (C) 2003,2005  Johann Deneux
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  
  Authors can be contacted at following electronic addresses:
  Johann Deneux: johann.deneux@it.uu.se
*/
#include "Log.hh"
#include <fstream>

namespace top10 {
namespace util {

Log* Log::singleton = 0;

Log::Log(const char* fname):
  log_stream(0)
{
  std::ofstream* file_log = new std::ofstream(fname);
  if (file_log && *file_log) log_stream = file_log;
  else delete file_log;
  
  out()<<"Log opened"<<std::endl;
}

Log::~Log()
{
  out()<<"Log closed"<<std::endl;
  
  if (log_stream != &(std::cerr)) {
    delete log_stream;
    log_stream = 0;
  }
  else (*log_stream)<<std::flush;
}

void Log::send(Level lv, std::string origin, std::string msg)
{
  for (ReceiverRefs::iterator it = receivers.begin(); it != receivers.end(); ++it) {
    (*it)->receive(lv, origin, msg);
  }
  
  switch (lv) {
    case Info:     out()<<"INFO:"; break;
    case Error:    out()<<"ERROR:"; break;
    case Warning:  out()<<"WARNING:"; break;
    case Critical: out()<<"CRITICAL:"; break;
    case Debug:    out()<<"DEBUG:"; break;
  }
  
  if (!origin.empty())
    out()<<" from "<<origin<<" ";
  
  out()<<msg<<std::endl;
  
  out()<<std::flush;
}

void Log::addReceiver(Receiver* r)
{
  receivers.push_back( Ref<Receiver>(r) ); 
}
    
Log* Log::getSingle(const char* log_file_name)
{
  if (!Log::singleton)
    singleton = new Log(log_file_name);

  return singleton;
}

}
}
