#ifndef TOP10_UTIL_HASH_MAP_HH
#define TOP10_UTIL_HASH_MAP_HH

#ifdef __GNUC__
#include <ext/hash_map>
#else
#include <hash_map>
#endif

namespace top10
{
  namespace util
  {
    /*
    Why on Earth does Microsoft require me to group the hash function and the
    ordering function into one template parameter when SGI's does not?
    */
    template<typename Key, typename Value, typename HashFcn, typename KeyCmp>
    struct HashMap
    {
#ifdef __GNUC__
      //! Use a strict total order to test equality.
      struct key_eq
      {
	  key_eq() {}
	  explicit key_eq(const KeyCmp& cmp): m_cmp(cmp) {}

	  bool operator( )(const Key& k1, const Key& k2) const {
	      return !m_cmp(k1, k2) && !m_cmp(k2, k1);
	  }

      private:
	  KeyCmp m_cmp;
      };

      typedef __gnu_cxx::hash_map< Key, Value, HashFcn, key_eq > Type;
#else
      struct hash_compare
      {
	static const size_t bucket_size = 4;
	static const size_t min_buckets = 8;
	hash_compare( ) {}
	hash_compare( KeyCmp pred ): m_cmp(pred) {}
	size_t operator( )( const Key& k ) const { return m_hash(k); }
	bool operator( )(const Key& k1, const Key& k2) const { return m_cmp(k1, k2); }

      private:
	HashFcn m_hash;
	KeyCmp m_cmp;
      };
      typedef stdext::hash_map< Key, Value, hash_compare > Type;
#endif
    };
  }
}

#endif
