/*
  Top 10, a racing simulator
  Copyright (C) 2003,2005  Johann Deneux
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  
  Authors can be contacted at following electronic addresses:
  Johann Deneux: johann.deneux@gmail.com
*/

#ifndef TOP10_UTILGLOBALOPTIONS_HH
#define TOP10_UTILGLOBALOPTIONS_HH

#include <map>
#include <string>
#include "RefCount.hh"
#include <tinyxml.h>

namespace top10 {
namespace util {

class GlobalOptions{
public:
  void load(std::string);
  void save(std::string);
 
  void setStrOption(std::string, std::string);
  void setNumOption(std::string, double);
  
  std::string getStrOption(std::string) const;
  double      getNumOption(std::string) const;
  
  static GlobalOptions* getGlobalOptions();
  
private:
  GlobalOptions();
  
private:
  std::map<std::string, std::string> str_options;  
  std::map<std::string, double>      num_options;
  TiXmlDocument document;
  static GlobalOptions* singleton;
};

}
}

// Shortcuts
inline top10::util::GlobalOptions* getGlobalOpt() { return top10::util::GlobalOptions::getGlobalOptions(); }
inline unsigned char getOptUC(std::string s)      { return (unsigned char)(getGlobalOpt()->getNumOption(s) * 255.0); }
inline int getOptI(std::string s)                 { return (int)getGlobalOpt()->getNumOption(s); }
inline double getOptD(std::string s)              { return getGlobalOpt()->getNumOption(s); }
inline std::string getOptS(std::string s)         { return getGlobalOpt()->getStrOption(s); }

inline bool getEnabledOpt(std::string s) {
  try {
    if (getGlobalOpt()->getNumOption(s) != 0.0) return true;
  }
  catch (...) {}
  try {
    std::string v = getGlobalOpt()->getStrOption(s);
    if (v != "No" && v != "None" && v != "Disabled" && !v.empty()) return true;
  }
  catch (...) {}
  return false;
}

#endif
