/*
  Top10, a racing simulator
  Copyright (C) 2000-2007  Johann Deneux
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  
  Authors can be contacted at following electronic addresses:
  Johann Deneux: johann.deneux@gmail.com
*/

#include "Dumpable.hh"
#include <vector>

namespace top10
{
  namespace util
  {

    void dumpStr(const std::string& s, std::ostream& out)
    {
      out << s.size() << " " << s;
    }

    std::string loadStr(std::istream& in)
    {
      unsigned int n;
      in >> n;
      if (n == 0)
	return std::string("");

      if (n > 1024)
	throw std::string("String too long");

      std::vector<char> buf(n +1);

      // Read the space
      in.read(&buf[0], 1);

      // Read the string
      in.read(&buf[0], n);
      buf.at(n) = 0;

      const std::string ret = &buf[0];
      return ret;
    }
  }
}
