/*
  Top 10, a racing simulator
  Copyright (C) 2000-2007  Johann Deneux
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  
  Authors can be contacted at following electronic addresses:
  Johann Deneux: johann.deneux@gmail.com
*/

#include "Date.hh"
#include <sstream>
#include <ctime>

namespace top10
{
  namespace util
  {

    Date::Date()
      : m_year(0),
      m_month(0),
      m_day(0),
      m_hour(0),
      m_minute(0),
      m_second(0)
    {
    }

    Date Date::now()
    {
      Date ret;
      const time_t now = time(0);
      struct tm t = *localtime(&now);
      // Weird: 1900+ needed on windows
      ret.m_year = 1900 + t.tm_year;
      // Weird: 1+ needed on windows
      ret.m_month = 1 + t.tm_mon;
      ret.m_day = t.tm_mday;
      ret.m_hour = t.tm_hour;
      ret.m_minute = t.tm_min;
      ret.m_second = t.tm_sec;

      return ret;
    }

    std::string Date::getRepr() const
    {
      std::ostringstream buf;
      buf << m_year << "/" << m_month << "/" << m_day << " " << m_hour << ":" << m_minute << ":" << m_second;
      return buf.str();
    }

  }
}
