namespace top10
{
  namespace util
  {

    //! Sets a variable to a value when created, restore it when destroyed.
    template< typename T>
    class AutoSet
    {
    public:
      AutoSet(T* ref, const T& val): m_ref(ref), m_restore(*ref) { *m_ref = val; }
      ~AutoSet() { *m_ref = m_restore; }

    private:
      T* m_ref;
      T m_restore;
    };

  };
};
