/*
  Top10, a racing simulator
  Copyright (C) 2000-2004  Johann Deneux
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  
  Authors can be contacted at following electronic addresses:
  Johann Deneux: johann.deneux@gmail.com
*/

#ifndef UIPANEL_HH
#define UIPANEL_HH

#include "util/NoCopy.hh"
#include "graphX/Node.hh"
#include "sound/SourceAllocator.hh"

#include <SDL/SDL.h>


namespace top10 {
  namespace ui_interactive {

    class Menu;

    class UIPanel: public top10::util::NoCopy
    {
    public:
      UIPanel(top10::sound::SourceAllocator* audio_alloc);

      void setFrontMenu(Menu* m);

      //! Return pointer to current menu, or 0 if the panel is not active.
      Menu*       getCurrentMenu();
      const Menu* getCurrentMenu() const;

      //! Change the current menu.
      void setMenu(Menu* m);

      inline void hide() { setMenu(0); }

      //! Handle events: Forward them to the current menu or the front menu.
      /*! Calls Menu::event() if a menu is shown, Menu::handleFrontEvent() otherwise.
          ESC keypresses are caught. They are used to show/hide the panel.
	  */
      void event(SDL_Event);
      inline void resizeEvent(int w, int h) { window_w = w; window_h = h; }

      //! Return the node representing the menu.
      top10::graphX::Node* getNode();

      /* These methods delegate to the front menu. */
      //! Update the data underlying the main scene.
      void updateFrontData();
      //! Render the main scene.
      void renderGL();
      //! Render the main scene sounds.
      void renderAL();

      inline int getWindowWidth() const { return window_w; }
      inline int getWindowHeight() const { return window_h; }

      void playMusic();
      void stopMusic();

    private:
      void loadMusic();

    private:
      top10::util::Ref<Menu> currentMenu;
      top10::util::Ref<Menu> frontMenu;

      int window_w;
      int window_h;

      // For the background music played when the menu is displayed.
      top10::util::Ref<top10::sound::SourceAllocator> audio_alloc;
      top10::util::Ref<top10::sound::Source> music_source;
      ALuint music_buffer;

    };
  };
};

#endif
