/*
  Top10, a racing simulator
  Copyright (C) 2000-2007  Johann Deneux
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  
  Authors can be contacted at following electronic addresses:
  Johann Deneux: johann.deneux@gmail.com
*/

#ifndef TOP10_UI_TRAINING_MENU_HH
#define TOP10_UI_TRAINING_MENU_HH

#include "Menu.hh"
#include "Controls.hh"
#include "GameManager.hh"
#include "SetupMenu.hh"
#include "graphX/Renderer.hh"
#include "sound/SourceAllocator.hh"
#include "util/SlowTime.hh"
#include "racing/LapRecordDb.hh"

namespace top10
{
  namespace ui_interactive
  {
    class TrainingMenu: public FrontMenu
    {
    public:
      TrainingMenu(UIPanel*,
		   Menu* parent,
		   ActionMapping*,
		   top10::graphX::Renderer*,
		   top10::sound::SourceAllocator*,
		   top10::racing::LapRecordDb*);

      ~TrainingMenu();

      // Implements UIPanel::Menu
      void on_panelShowed();
      void on_panelHidden();
      void on_panelFrontOn();
      void on_panelFrontOff();

      //! Find the action mapped to an event, pass it to the GameManager
      void handleFrontEvent(SDL_Event);
      //! Update the simulation.
      void updateFrontData();
      //! Draw the scene.
      void renderGL();
      //! Render sounds.
      void renderAL();

      //! Starts the simulation.
      void startSession(std::string track_name, std::string kart_model,
	                std::string kart_physx, bool rainy_weather);
      //! Terminate the simulation.
      void killSession();

    private:
      //! The object handling the training sessions.
      GameManager m_session;
      //! The object translating SDL events to actions.
      ActionMapping* m_actions;
      //! The renderer used to render the simulation.
      top10::graphX::Renderer* m_renderer;
      //! Setup menu
      SetupMenuRef m_setup;
      //! Amount by which to steer when using digital controls.
      int m_steer_amount;
      //! Indicate if this menu is currently being shown.
      bool m_is_shown;
      //! Keeps track of the time.
      top10::util::SlowTime m_clock;
    };

    typedef top10::util::Ref<TrainingMenu> TrainingMenuRef;
  }
}

#endif
