/*
  Top 10, a racing simulator
  Copyright (C) 2003,2005,2007  Johann Deneux
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  
  Authors can be contacted at following electronic addresses:
  Johann Deneux: johann.deneux@gmail.com
*/

#ifndef TOP10_TRACK_SCENE_HH
#define TOP10_TRACK_SCENE_HH

#include "util/NoCopy.hh"
#include "util/RefCount.hh"
#include "graphX/Renderer.hh"
#include "graphX/ShadowVolumeNode.hh"
#include "graphX/SkyBoxNode.hh"
#include "graphX/LightNode.hh"
#include "graphX/AlphaNode.hh"
#include "graphX/SwitchNode.hh"
#include "track/Track.hh"

#include "Kart.hh"

namespace top10
{
  namespace ui_interactive
  {  
    //! Draws a track, go-karts and the environment.
    class TrackScene: public top10::util::NoCopy, public top10::util::RefCount
    {
    public:
      TrackScene(top10::graphX::Renderer*);
      ~TrackScene();

      void setTrack(top10::track::Track* track);
      void setSkyBox(const std::string& path);
      void disableSkyBox();
      void setKartShadows(top10::graphX::ShadowVolumeNode::Method);
      void setTrackShadows(top10::graphX::ShadowVolumeNode::Method);

      void renderGL();

      //! Add a kart.
      unsigned int newKart();
      void setKart(unsigned int, const std::string& kart_model);
      void showKart(unsigned int);
      void hideKart(unsigned int);
      void toggleGhost(unsigned int, bool);
      void setKartTransform(unsigned int kart_id,
			    const top10::math::Matrix4&);
      void setKartState(unsigned int kart_id,
			double steer, double left_steer, double right_steer,
			double h_fl, double h_fr, double h_rl, double h_rr,
			double rot_fl, double rot_fr, double rot_rl, double rot_rr);

      
    private:
      top10::graphX::Renderer* m_render;
      top10::graphX::ShadowVolumeNode::Method m_static_shadow_method;
      top10::graphX::ShadowVolumeNode::Method m_dynamic_shadow_method;

      top10::util::Ref<top10::track::Track> m_track;
      top10::util::Ref<top10::graphX::SkyBoxNode> m_skybox;
      top10::util::Ref<top10::graphX::LightNode> m_light;
      top10::graphX::TransformNodeRefs m_transforms;
      top10::graphX::AlphaNodeRefs m_alphas;
      top10::graphX::SwitchNodeRefs m_switches;
      KartNodeRefs m_karts;


      //! Shadows of dynamic objects
      top10::graphX::GroupNodeRef m_dynamic_shadows;
      
      //! Shadows of static objects
      top10::graphX::GroupNodeRef m_static_shadows;      
    };

    typedef top10::util::Ref<TrackScene> TrackSceneRef;
  }
}

#endif
