#ifndef TOP10_UI_STATIC_SCENE_HH
#define TOP10_UI_STATIC_SCENE_HH

#include "util/RefCount.hh"
#include "graphX/LightNode.hh"
#include "helpers/MeshEditor.hh"
#include "math/Frustum.hh"

namespace top10
{
  namespace ui_interactive
  {
    //! A scene composed of meshes and camera positions.
    class StaticScene: public top10::util::XmlDumpable,
		       public top10::util::RefCount
    {
    public:
      StaticScene();
      
      void clearState();
      int loadXml(const TiXmlElement*);
      int saveXml(      TiXmlElement*) const;

      top10::math::Frustum       getView(unsigned int) const;
      unsigned int               getNumViews()         const;
      const top10::graphX::Node* getNode()             const;

    private:
      void loadCameraMatrix(const TiXmlElement*);
      void loadCameraLookAt(const TiXmlElement*);
      void loadLight(const TiXmlElement*);
      void saveCamera(TiXmlElement*, const top10::math::Frustum&) const;

      void setLightNode(const top10::math::Vector&);

    private:
      static const char* s_nodename;

      std::vector<top10::math::Frustum> m_views;
      top10::helpers::MeshEditor m_meshes;
      top10::graphX::LightNodeRef m_light;
    };

    typedef top10::util::Ref<StaticScene> StaticSceneRef;
  }
}

#endif
