#ifndef TOP10_UI_SETUP_SCREEN_HH
#define TOP10_UI_SETUP_SCREEN_HH

#include "util/RefCount.hh"
#include "util/NoCopy.hh"
#include "physX/SetupSettings.hh"
#include "StaticScene.hh"

class fntFont;

namespace top10
{
  namespace graphX
  {
    class Renderer;
  }

  namespace ui_interactive
  {
    class SetupScreen: public top10::util::RefCount,
		       public top10::util::NoCopy
    {
    public:
      SetupScreen(top10::graphX::Renderer*, fntFont*);

      void update();
      void renderGL();

      void increase();
      void decrease();
      void nextComponent();
      void prevComponent();

    private:
      void loadSettings();
      void loadScene();
      void propagate();
      top10::graphX::CameraNode* getCamera() const;

    private:
      top10::util::Ref<top10::physX::Settings> m_settings;

      top10::graphX::Renderer* m_render;
      fntFont* m_font;
      StaticScene m_scene;
      top10::util::Ref<const top10::graphX::Node> m_scene_node;

      top10::physX::SettingsState::Components m_curr_comp;
      top10::physX::SettingsState m_state;
    };

    typedef top10::util::Ref<SetupScreen> SetupScreenRef;
  }
}

#endif
