#ifndef TOP10_SETUP_MENU_HH
#define TOP10_SETUP_MENU_HH

#include "Menu.hh"
#include "GameManager.hh"
#include "SetupScreen.hh"
#include "graphX/Renderer.hh"

namespace top10
{
  namespace ui_interactive
  {

    class SetupMenu: public FrontMenu
    {
    public:
      SetupMenu(UIPanel*, Menu* parent, GameManager*, top10::graphX::Renderer*);

      //! Find the action mapped to an event, pass it to the SetupScreen
      void handleFrontEvent(SDL_Event);
      //! Update the SetupScreen
      void updateFrontData();
      //! Draw the scene.
      void renderGL();

      //! Recreate the go-karts in the training session.
      void killSession();

    private:
      GameManager* m_training_session;
      top10::graphX::Renderer* m_render;
      SetupScreenRef m_setup;
    };

    typedef top10::util::Ref<SetupMenu> SetupMenuRef;
  }
}

#endif
