#include "SetupMenu.hh"

namespace top10
{
  namespace ui_interactive
  {

    SetupMenu::SetupMenu(UIPanel* p, Menu* parent, GameManager* gm, top10::graphX::Renderer* r)
      : FrontMenu(p, parent), 
	m_render(r),
	m_training_session(gm)
    {
      m_setup = new SetupScreen(m_render, getFont());

      setExitText("Return to session");

      updateNode();
    }

    
    
    void SetupMenu::handleFrontEvent(SDL_Event e)
    {
      if (e.type != SDL_KEYDOWN)
	return;

      switch (e.key.keysym.sym)
      {
      case SDLK_UP:
	m_setup->prevComponent();
	break;

      case SDLK_DOWN:
	m_setup->nextComponent();
	break;

      case SDLK_LEFT:
	m_setup->decrease();
	break;

      case SDLK_RIGHT:
	m_setup->increase();
	break;
      
      default:
	break;
      }
    }



    void SetupMenu::updateFrontData()
    {
      m_setup->update();
    }



    void SetupMenu::renderGL()
    {
      m_setup->renderGL();
    }



    void SetupMenu::killSession()
    {
      m_training_session->resetControlledKart();
    }
  }
}