/*
  Top10, a racing simulator
  Copyright (C) 2000-2007  Johann Deneux
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  
  Authors can be contacted at following electronic addresses:
  Johann Deneux: johann.deneux@gmail.com
*/

#ifndef TOP10_SCROLL_TEXT_MENU_HH
#define TOP10_SCROLL_TEXT_MENU_HH

#include "Menu.hh"
#include "graphX/Renderer.hh"
#include "graphX/TransformNode.hh"
#include "graphX/MaterialNode.hh"

namespace top10
{
  namespace ui_interactive
  {
    //! Displays a text scrolling vertically on the main scene.
    /*!
    The menu contains a single "Return" entry to go back to the main screen
    */
    class ScrollTextMenu: public FrontMenu
    {
    public:
      ScrollTextMenu(UIPanel*, Menu* parent, top10::graphX::Renderer*, fntFont*, double spacing);

      void setSpeed(double rows_per_second);
      inline void addRow(const std::string& t, double sz) { addRow(t, m_font, sz); }
      void addRow(const std::string&, fntFont*, double);
      void setColor(unsigned char r, unsigned char g, unsigned char b);

      void on_panelFrontOn();
      void on_panelFrontOff();
      void updateFrontData();
      void renderGL();

    private:
      top10::graphX::Renderer* m_renderer;
      top10::util::Ref<top10::graphX::TransformNode> m_transform;
      top10::util::Ref<top10::graphX::MaterialNode> m_color;

      unsigned int m_last_tick;
      bool m_is_active;
      double m_speed;
      int m_num_rows;
      fntFont* m_font;
      double m_spacing;
    };

    typedef top10::util::Ref<ScrollTextMenu> ScrollTextMenuRef;
  }
}

#endif
