/*
  Top10, a racing simulator
  Copyright (C) 2000-2007  Johann Deneux
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  
  Authors can be contacted at following electronic addresses:
  Johann Deneux: johann.deneux@gmail.com
*/

#include "ScrollTextMenu.hh"
#include "graphX/TextNode.hh"
#include "util/SlowTime.hh"

namespace top10
{
  namespace ui_interactive
  {



    ScrollTextMenu::ScrollTextMenu(UIPanel* panel, Menu* parent, top10::graphX::Renderer* renderer, fntFont* font, double spacing)
      : FrontMenu(panel, parent),
      m_renderer(renderer),
      m_last_tick(0),
      m_is_active(false),
      m_speed(1.0),
      m_num_rows(0),
      m_font(font),
      m_spacing(spacing)
    {
      m_transform = new top10::graphX::TransformNode;
      m_color = new top10::graphX::MaterialNode;
      m_transform->addChild(m_color.getPtr());

      setExitText("Back");

      updateNode();
    }



    void ScrollTextMenu::setSpeed(double s)
    {
      m_speed = s;
    }



    void ScrollTextMenu::addRow(const std::string& text, fntFont* font, double sz)
    {
      top10::graphX::TextNode* text_node = new top10::graphX::TextNode;
      text_node->setPos(-0.9, -1.0 - m_num_rows * m_spacing);
      text_node->setFont(font);
      text_node->setText(text);
      text_node->setPointSize(sz);
      m_color->addChild(text_node);
      ++m_num_rows;
    }



    void ScrollTextMenu::setColor(unsigned char red, unsigned char green, unsigned char blue)
    {
      m_color->r = red;
      m_color->g = green;
      m_color->b = blue;
    }



    void ScrollTextMenu::on_panelFrontOn()
    {
      m_last_tick = top10::util::global_time.getTicks();
      m_is_active = true;
      top10::math::Identity4 M;
      M(0, 0) = 0.8;
      m_transform->setToWorld(M);
    }



    void ScrollTextMenu::on_panelFrontOff()
    {
      m_is_active = false;
    }



    void ScrollTextMenu::updateFrontData()
    {
      if (!m_is_active)
	return;

      unsigned int now = top10::util::global_time.getTicks();

      top10::math::Translation4 T(0.0, m_speed * 0.001*(now - m_last_tick), 0.0);
      top10::math::Matrix4 M = m_transform->toWorld();
      M = T * M;
      m_transform->setToWorld(M);

      m_last_tick = now;
    }



    void ScrollTextMenu::renderGL()
    {
      top10::graphX::RenderList rl;
      m_renderer->setClearColor(0, 0, 0);
      m_renderer->clearAllGL();
      m_renderer->disableFog();
      m_renderer->buildList(m_transform.getPtr(), &rl);
      m_renderer->renderHudGL(rl);
    }
  }
}
