/*
  Top10, a racing simulator
  Copyright (C) 2000-2007  Johann Deneux
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  
  Authors can be contacted at following electronic addresses:
  Johann Deneux: johann.deneux@gmail.com
*/

#ifndef TOP10_REPLAY_RENDERER_HH
#define TOP10_REPLAY_RENDERER_HH

#include "TrackScene.hh"

#include "racing/LapRecordDb.hh"
#include "graphX/Renderer.hh"
#include "util/RefCount.hh"
#include "util/NoCopy.hh"
#include "util/SlowTime.hh"

namespace top10
{
  namespace ui_interactive
  {

    class ReplayRenderer: public top10::util::RefCount,
			  public top10::util::NoCopy
    {
    public:
      enum PresetPosition
      {
	POS_FRONT,
	POS_BACK,
	POS_LEFT,
	POS_RIGHT,
	POS_TOP
      };

    public:
      ReplayRenderer(top10::graphX::Renderer*);

      void setReplay(const top10::racing::LapRecord& lap,
		     const std::string& track_name,
		     const std::string& kart_name,
		     bool foggy);

      void update();
      void renderGL();

      void pause();
      void forward(double speed);
      void backward(double speed);
      void gotoStart();
      void gotoEnd();

      void cameraRotateH(double rad_per_sec);
      void cameraRotateV(double rad_per_sec);
      void cameraMove(double meters_per_sec);
      void cameraZoom(double factor_per_sec);
      void cameraPreset(PresetPosition);

    private:
      top10::graphX::Renderer* m_render;
      TrackSceneRef m_track_scene;
      unsigned int m_kart_id;
      top10::racing::LapRecord m_lap;
      Uint32 m_start_frame;

      top10::util::SlowTime m_timer;
      top10::math::Frustum m_view;

      top10::math::Vector m_local_dir;

      double m_rot_rate_h;
      double m_rot_rate_v;
      double m_move_speed;
      double m_zoom_rate;

      double m_rot_h;
      double m_rot_v;
      double m_dist;
      double m_fov;

      //! Time of the last update, using the wall clock.
      Uint32 m_last_update;
      //! Time of the previous frame, using the replay's clock.
      Uint32 m_last_frame;

    };

    typedef top10::util::Ref<ReplayRenderer> ReplayRendererRef;
  }
}

#endif
