/*
  Top10, a racing simulator
  Copyright (C) 2000-2007  Johann Deneux
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  
  Authors can be contacted at following electronic addresses:
  Johann Deneux: johann.deneux@gmail.com
*/

#include "Menu.hh"
#include "ReplayRenderer.hh"
#include "racing/LapRecordDb.hh"

#ifndef TOP10_REPLAY_MENU_HH
#define TOP10_REPLAY_MENU_HH

namespace top10
{
  namespace ui_interactive
  {
    class ReplayMenu: public FrontMenu
    {
    public:
      ReplayMenu(UIPanel*, Menu* parent, top10::graphX::Renderer*, top10::racing::LapRecordDb*);
	
      //! Find the action mapped to an event, pass it to the ReplayRenderer.
      void handleFrontEvent(SDL_Event);
      //! Update the simulation.
      void updateFrontData();
      //! Draw the scene.
      void renderGL();
      //! Render sounds.
      void renderAL();

      //! Select a lap and replay it.
      void selected();

      void startSession(const top10::racing::LapRecordEntry&);
      void killSession();

    private:
      top10::racing::LapRecordDb* m_laps;
      top10::graphX::Renderer* m_render;
      ReplayRendererRef m_session;
    };

    typedef top10::util::Ref<ReplayMenu> ReplayMenuRef;
  }
}

#endif
