/*
  Top10, a racing simulator
  Copyright (C) 2000-2007  Johann Deneux
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  
  Authors can be contacted at following electronic addresses:
  Johann Deneux: johann.deneux@gmail.com
*/

#include "OptionsMenu.hh"
#include "util/GlobalOptions.hh"
#include "util/strconv.hh"

namespace top10
{
  namespace ui_interactive
  {
    OptionsMenu::OptionsMenu(UIPanel* panel)
      : Menu(panel)
    {
      top10::util::GlobalOptions* opt = top10::util::GlobalOptions::getGlobalOptions();

      std::string entry = "Kart Shadows : ";
      entry += opt->getStrOption("Render.Kart.Shadow.Quality");
      unsigned int id = addMenu(0);
      setMenuText(id, entry);

      entry = "Track Shadows : ";
      entry += opt->getStrOption("Render.Track.Shadow.Quality");
      id = addMenu(0);
      setMenuText(id, entry);

      entry = "A.B.S : ";
      if (opt->getStrOption("Control.Aid.ABS") == "Yes")
	entry += "Yes";
      else
	entry += "No";
      id = addMenu(0);
      setMenuText(id, entry);

      entry = "Master volume : " + top10::util::toStringD(opt->getNumOption("Sound.Master.Volume"));
      id = addMenu(0);
      setMenuText(id, entry);

      entry = "Music volume : " + top10::util::toStringD(opt->getNumOption("Sound.Menu.Music.Volume"));
      id = addMenu(0);
      setMenuText(id, entry);

      updateNode();
    }



    void OptionsMenu::selected()
    {
      switch (getEntryN())
      {
      case 0:
	toggleShadows("Kart");
	break;

      case 1:
	toggleShadows("Track");
	break;
      
      case 2:
	toggleABS();
	break;
      
      case 3:
	changeMasterVolume();
	break;

      case 4:
	changeMusicVolume();
	break;
      }

      updateNode();
    }



    void OptionsMenu::toggleShadows(const std::string& type)
    {
      top10::util::GlobalOptions* options = top10::util::GlobalOptions::getGlobalOptions();

      const std::string opt = "Render."+type+".Shadow.Quality";
      const std::string quality = options->getStrOption(opt);
      std::string entry = type + " Shadows : ";
      std::string new_qual;

      if (quality == "None")
      {
	new_qual = "VeryLow";
      }
      else if (quality == "VeryLow")
      {
	new_qual = "Low";
      }
      else if (quality == "Low")
      {
	new_qual = "Medium";
      }
      else if (quality == "Medium")
      {
	new_qual = "High";
      }
      else if (quality == "High")
      {
	new_qual = "VeryHigh";
      }
      else
      {
	new_qual = "None";
      }

      entry += new_qual;
      options->setStrOption(opt, new_qual);

      setMenuText(getEntryN(), entry);
    }



    void OptionsMenu::toggleABS()
    {
      top10::util::GlobalOptions* opt = top10::util::GlobalOptions::getGlobalOptions();

      std::string entry = "A.B.S : ";
      if (opt->getStrOption("Control.Aid.ABS") == "Yes")
      {
	entry += "No";
	opt->setStrOption("Control.Aid.ABS", "No");
      }
      else
      {
	entry += "Yes";
	opt->setStrOption("Control.Aid.ABS", "Yes");
      }

      setMenuText(getEntryN(), entry);
    }



    void OptionsMenu::changeMasterVolume()
    {
      top10::util::GlobalOptions* opt = top10::util::GlobalOptions::getGlobalOptions();

      std::string entry = "Master volume : ";
      double gain = opt->getNumOption("Sound.Master.Volume");
      gain += 0.125;
      if (gain > 1.0)
	gain = 0.0;
      opt->setNumOption("Sound.Master.Volume", gain);

      entry += top10::util::toStringD(gain);

      setMenuText(getEntryN(), entry);
    }



    void OptionsMenu::changeMusicVolume()
    {
      top10::util::GlobalOptions* opt = top10::util::GlobalOptions::getGlobalOptions();

      std::string entry = "Music volume : ";
      double gain = opt->getNumOption("Sound.Menu.Music.Volume");
      gain += 0.125;
      if (gain > 1.0)
	gain = 0.0;
      opt->setNumOption("Sound.Menu.Music.Volume", gain);

      entry += top10::util::toStringD(gain);

      setMenuText(getEntryN(), entry);
    }

  }
}
