/*
  Top10, a racing simulator
  Copyright (C) 2000-2004  Johann Deneux
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  
  Authors can be contacted at following electronic addresses:
  Johann Deneux: johann.deneux@it.uu.se
*/

#ifndef OPTIONS_HH
#define OPTIONS_HH

#include <string>

#include "ForceFeedback.hh"
#include "util/error.hh"

namespace top10 {
  namespace ui_interactive {
    namespace options {
      extern void parse(int argc, char** argv) throw(top10::util::Error);

      /// Screen size
      extern int w, h;

      /// The joystick type
      extern FFDevice* ffdev;
      extern bool use_ff;

      /// Full screen should be used
      extern bool full_screen;

      /// Play sounds
      extern bool use_audio;

      /// Name of file containing the description of the kart
      extern std::string kart_filename;

      /// Slow factor
      extern double slow_factor;
    };
  };
};

#endif
