/*
  Top10, a racing simulator
  Copyright (C) 2000-2007  Johann Deneux
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  
  Authors can be contacted at following electronic addresses:
  Johann Deneux: johann.deneux@gmail.com
*/

#ifndef MAIN_MENU_HH
#define MAIN_MENU_HH

#include "UIPanel.hh"
#include "Controls.hh"
#include "FileMenu.hh"
#include "YesNoMenu.hh"
#include "OptionsMenu.hh"
#include "ScrollTextMenu.hh"
#include "ReplayMenu.hh"
#include "TrainingMenu.hh"
#include "util/PathFinder.hh"
#include "graphX/Renderer.hh"
#include <iostream>

namespace top10 {
  namespace ui_interactive {

    class MainMenu: public FrontMenu {
    public:
      MainMenu(UIPanel*, ActionMapping* actions,
	       top10::graphX::Renderer* render,
	       top10::sound::SourceAllocator* audio_alloc);

      inline bool getQuit() const { return quit; }

      // Implements UIPanel::Menu
      void selected();
      void on_panelFrontOn();
      void on_panelFrontOff();
      void on_panelHidden();

      //! Render some background picture.
      void renderGL();

      void killSession();

    private:
      void loadPicture();
      void makeCredits();

    private:
      //! Create a training session when a track file is selected
      class TrackFileNotifier: public FileMenu::Notifier {
      public:
	TrackFileNotifier(MainMenu*, ActionMapping*, top10::graphX::Renderer*, top10::sound::SourceAllocator*);

	bool* getIsWetPtr() { return &is_wet; }

	void entrySelected(std::string track_file, FileMenu::EntryType);
      private:
	MainMenu* menu;
	TrainingMenuRef training;
	bool is_wet;
      };

      //! Set the model of the kart to draw
      class KartNotifier: public FileMenu::Notifier {
      public:
	KartNotifier(MainMenu* menu);
	void entrySelected(std::string kart_file, FileMenu::EntryType);
      private:
	MainMenu* menu;
      };

    private:
      TrackFileNotifier track_notifier;
      KartNotifier kart_notifier;
      YesNoMenu::BoolNotifier wet_notifier;

      bool quit;
      std::string kart_model_name;
      std::string kart_physx_name;
      top10::util::PathFinder path_finder;
      
      //! Node showing the background picture
      top10::util::Ref<top10::graphX::Node> pic_node;

      top10::graphX::Renderer* renderer;

      unsigned int replay_id;

      ScrollTextMenuRef scroll_text;
      ReplayMenuRef replay;

      top10::racing::LapRecordDb laps;

      friend class TrackFileNotifier;
      friend class KartNotifier;
    };

    typedef top10::util::Ref<MainMenu> MainMenuRef;
  };
};

#endif
