/*
  Top10, a racing simulator
  Copyright (C) 2000-2004  Johann Deneux
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  
  Authors can be contacted at following electronic addresses:
  Johann Deneux: johann.deneux@gmail.com
*/

#include "MainMenu.hh"
#include "ControlsMenu.hh"
#include "TrainingMenu.hh"
#include "ScrollTextMenu.hh"
#include "ReplayMenu.hh"
#include "util/PathFinder.hh"
#include "util/GlobalOptions.hh"
#include "util/SlowTime.hh"
#include "util/Log.hh"
#include "sound/Listener.hh"
#include "graphX/TextureManager.hh"

#include <fstream>
#include <time.h>
#include <sstream>

using namespace top10::ui_interactive;

MainMenu::MainMenu(UIPanel* p, ActionMapping* actions,
		   top10::graphX::Renderer* render,
		   top10::sound::SourceAllocator* audio_alloc):
  FrontMenu(p, 0),
  track_notifier(this, actions, render, audio_alloc),
  kart_notifier(this),
  wet_notifier(track_notifier.getIsWetPtr()),
  quit(false),
  kart_model_name("default/default.parts"),
  renderer(render)
{
  unsigned int id = addMenu(new FileMenu(p, &track_notifier, "data/track_data", "", FileMenu::Dir));
  setMenuText(id, "Training session");

  YesNoMenuRef wet_menu;
  wet_menu = new YesNoMenu(p, &wet_notifier);
  wet_menu->setYesText("Fog");
  wet_menu->setNoText("Clear");
  id = addMenu(wet_menu.getPtr());
  setMenuText(id, "Weather");

#if 0
  entries.push_back("Load Kart (next session)");
  links.push_back(new FileMenu(p, &kart_notifier, "data/kart_data", "", FileMenu::Dir));  
#endif

  replay_id = addMenu(0);
  setMenuText(replay_id, "Replays");

  id = addMenu(new ControlsMenu(p, actions));
  setMenuText(id, "Controls");

  id = addMenu(new OptionsMenu(p));
  setMenuText(id, "Options");

  scroll_text = new ScrollTextMenu(panel, this, renderer, getFont(), 0.05);
  makeCredits();
  id = addMenu(scroll_text.getPtr());
  setMenuText(id, "Credits");

  setExitText("Quit");

  updateNode();

  loadPicture();
}



void MainMenu::makeCredits()
{
  const double sz_big = 0.045;
  const double sz_small = 0.04;

  scroll_text->setSpeed(0.2);
  scroll_text->setColor(255, 255, 255);

  scroll_text->addRow("Programmer", sz_small);
  scroll_text->addRow("Johann Deneux", sz_big);
  scroll_text->addRow("", sz_big);
  scroll_text->addRow("Track and vehicle design", sz_small);
  scroll_text->addRow("Benoit Roche", sz_big);
  scroll_text->addRow("", sz_big);
  scroll_text->addRow("Music", sz_small);
  scroll_text->addRow("'Ambien', by Kid Cholera", sz_big);
  scroll_text->addRow("", sz_big);
  scroll_text->addRow("Thanks to:", sz_small);
  scroll_text->addRow("Atte Timonen (.deb packages)", sz_big);
  scroll_text->addRow("John HP (previous web site)", sz_big);
  scroll_text->addRow("All testers", sz_big);
  scroll_text->addRow("Others whose names I lost :(", sz_big);
}


void MainMenu::loadPicture()
{
  top10::graphX::MaterialNode* mat_node = new top10::graphX::MaterialNode;
  mat_node->r = mat_node->g = mat_node->b = 255;

  top10::graphX::PanelNode* panel_node = new top10::graphX::PanelNode;
  panel_node->setDist(0.0);
  panel_node->setLowerLeft(-1.0, -1.0);
  panel_node->setUpperRight(1.0, 1.0);
  mat_node->addChild(panel_node);

  top10::graphX::TextureNode* texture_node = new top10::graphX::TextureNode;
  unsigned int id = top10::graphX::TextureManager::getInstance()->getTexture("background.jpg");
  texture_node->setTextureId(id);
  texture_node->addChild(mat_node);

  pic_node = texture_node;
}

void MainMenu::renderGL()
{
  top10::graphX::RenderList rl;
  renderer->buildList(pic_node.getPtr(), &rl);
  renderer->renderHudGL(rl);
}

void MainMenu::on_panelFrontOn()
{
}

void MainMenu::on_panelFrontOff()
{
}

void MainMenu::on_panelHidden()
{
}

void MainMenu::killSession()
{
  quit = true;
}

void MainMenu::selected()
{
  if (getEntryN() == replay_id)
  {
    Entry entry;
    entry.link = new ReplayMenu(panel, this, renderer, &laps);
    entry.text = "Replays";
    setSelected(entry);
  }
  else
    FrontMenu::selected();
}

/*
 * TrackFileNotifier
 */
MainMenu::TrackFileNotifier::TrackFileNotifier(MainMenu* m,
					       ActionMapping* actions, top10::graphX::Renderer* render, top10::sound::SourceAllocator* audio_alloc):
  menu(m),
  training(0),
  is_wet(false)
{
  training = new TrainingMenu(m->panel, m, actions, render, audio_alloc, &m->laps);
}


void MainMenu::TrackFileNotifier::entrySelected(std::string dirname, FileMenu::EntryType t)
{
  assert(t == FileMenu::Dir);
  std::string bn = top10::util::PathFinder::basename(dirname);
  std::string file = dirname+"/"+bn+".xml";

  menu->panel->setFrontMenu(training.getPtr());
  training->startSession(file, menu->kart_model_name, menu->kart_physx_name, is_wet);
}


/*
 * KartNotifier
 */
MainMenu::KartNotifier::KartNotifier(MainMenu* m):
  menu(m)
{
}

void MainMenu::KartNotifier::entrySelected(std::string dirname, FileMenu::EntryType t)
{
  assert(t == FileMenu::Dir);
  std::string bn = top10::util::PathFinder::basename(dirname);
  std::string file = dirname+"/"+bn+".parts";
  menu->kart_model_name = file;
  menu->kart_physx_name = dirname+"/"+bn+".physx";
}

