/*
  Top 10, a racing simulator
  Copyright (C) 2003,2005  Johann Deneux
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  
  Authors can be contacted at following electronic addresses:
  Johann Deneux: johann.deneux@gmail.com
*/

#ifndef TOP10_UI_INTERACTIVEGAMEMANAGER_HH
#define TOP10_UI_INTERACTIVEGAMEMANAGER_HH

#include "Controls.hh"
#include "TrackScene.hh"
#include "racing/Simulation.hh"
#include "util/RefCount.hh"
#include "util/NoCopy.hh"
#include "sound/SourceAllocator.hh"
#include "graphX/FreeCameraNode.hh"
#include "graphX/TextNode.hh"

#include <string>

namespace top10 {
namespace ui_interactive {

  class GameManager: public top10::util::NoCopy
{
public:
  static const unsigned char hud_opacity = 250;
  
  GameManager(top10::graphX::Renderer* render,
	      top10::sound::SourceAllocator* audio_alloc,
	      top10::racing::LapRecordDb* laps);
  
  void createTrainingSession(int n_karts,
			     std::string track_name, std::string kart_model,
                             std::string kart_physx, bool rainy_weather);
  void resetControlledKart();

  void startGame(unsigned int now);
  void updateGame(unsigned int now);
  void terminateGame();
    
  void sendEvent(Action, Sint16 value);

  //! Switch to the next camera
  void nextCamera();
  //! Switch to the previous camera
  void prevCamera();
  //! Switch to the same camera on the next kart
  void nextKart();
  //! Switch to the same camera on the previous kart
  void prevKart();
  //! Allow access to the free camera
  inline top10::graphX::FreeCameraNode* freeCamera() { return free_camera.getPtr(); }
  inline void toggleFreeCamera() { use_freecam = !use_freecam; }
  
  top10::graphX::CameraNode* getCamera();
  void renderGL();
  void renderAL();

  void toggleSimulationSound(bool);

private:
  void createKarts(int);

private:
  top10::graphX::Renderer* render;
  top10::util::Ref<top10::sound::SourceAllocator> audio_alloc;
  top10::racing::LapRecordDb* laps;
  fntFont* font;
  bool is_rainy;
  std::string track_name;
  std::string kart_name;
  top10::util::Ref<TrackScene> track_scene;

  unsigned int time_start;
  unsigned int last_update;
  unsigned int last_sound_update;
  unsigned int sound_update_period;
  bool started;
  bool ghost_hidden;
  
  top10::util::Ref<top10::racing::Simulation> simulation;
  top10::util::Ref<top10::track::Track> track;
  KartRefs karts;

  std::vector<unsigned int> kart_ids;
  unsigned int ghost_id;

  top10::util::Ref<top10::graphX::Node> hud;
  top10::util::Ref<top10::graphX::TextNode> current_time;
  top10::util::Ref<top10::graphX::TextNode> best_time;
  top10::util::Ref<top10::graphX::TextNode> last_time;
  top10::util::Ref<top10::graphX::TextNode> stat_fps;

  int fps_count;
  Uint32 last_fps_mark;

  //! Camera useful for debuging
  top10::util::Ref<top10::graphX::FreeCameraNode> free_camera;
  
  //! Index of the kart whose camera is being the active one
  int camera_kart;
  //! Index of the camera
  int camera;
  bool use_freecam;
  
  //! Render the HUD?
  bool render_hud;

  top10::math::Matrix4 getKartTransform(const Kart*) const;
};

}
}

#endif
