/*
  Top 10, a racing simulator
  Copyright (C) 2007  Johann Deneux
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  
  Authors can be contacted at following electronic addresses:
  Johann Deneux: johann.deneux@gmail.com
*/

#ifndef TOP10_FOG_VALUES_HH
#define TOP10_FOG_VALUES_HH

namespace top10
{
  namespace ui_interactive
  {
    class FogValues
    {
    public:
      FogValues();

      static FogValues createClear();
      static FogValues createRainy();

      inline double getDensity() const       { return m_density; }
      inline double getNear() const          { return m_near; }
      inline double getFar() const           { return m_far; }
      inline unsigned char getRed() const    { return m_col_r; }
      inline unsigned char getGreen() const  { return m_col_g; }
      inline unsigned char getBlue() const   { return m_col_b; }

    private:
      double m_density;
      double m_near;
      double m_far;
      unsigned char m_col_r;
      unsigned char m_col_g;
      unsigned char m_col_b;
    };
  }
}

#endif
